/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.debug;

import com.jme3.bullet.debug.AbstractPhysicsDebugControl;
import com.jme3.bullet.debug.BulletDebugAppState;
import com.jme3.bullet.objects.PhysicsVehicle;
import com.jme3.bullet.objects.VehicleWheel;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.debug.Arrow;

public class BulletVehicleDebugControl
extends AbstractPhysicsDebugControl {
    protected final PhysicsVehicle body;
    protected final Node suspensionNode;
    protected final Vector3f location = new Vector3f();
    protected final Quaternion rotation = new Quaternion();

    public BulletVehicleDebugControl(BulletDebugAppState debugAppState, PhysicsVehicle body) {
        super(debugAppState);
        this.body = body;
        this.suspensionNode = new Node("Suspension");
        this.createVehicle();
    }

    public void setSpatial(Spatial spatial) {
        if (spatial != null && spatial instanceof Node) {
            Node node = (Node)spatial;
            node.attachChild(this.suspensionNode);
        } else if (spatial == null && this.spatial != null) {
            Node node = (Node)this.spatial;
            node.detachChild(this.suspensionNode);
        }
        super.setSpatial(spatial);
    }

    private void createVehicle() {
        this.suspensionNode.detachAllChildren();
        for (int i = 0; i < this.body.getNumWheels(); ++i) {
            VehicleWheel physicsVehicleWheel = this.body.getWheel(i);
            Vector3f location = physicsVehicleWheel.getLocation().clone();
            Vector3f direction = physicsVehicleWheel.getDirection().clone();
            Vector3f axle = physicsVehicleWheel.getAxle().clone();
            float restLength = physicsVehicleWheel.getRestLength();
            float radius = physicsVehicleWheel.getRadius();
            Arrow locArrow = new Arrow(location);
            Arrow axleArrow = new Arrow(axle.normalizeLocal().multLocal(0.3f));
            Arrow wheelArrow = new Arrow(direction.normalizeLocal().multLocal(radius));
            Arrow dirArrow = new Arrow(direction.normalizeLocal().multLocal(restLength));
            Geometry locGeom = new Geometry("WheelLocationDebugShape" + i, locArrow);
            Geometry dirGeom = new Geometry("WheelDirectionDebugShape" + i, dirArrow);
            Geometry axleGeom = new Geometry("WheelAxleDebugShape" + i, axleArrow);
            Geometry wheelGeom = new Geometry("WheelRadiusDebugShape" + i, wheelArrow);
            dirGeom.setLocalTranslation(location);
            axleGeom.setLocalTranslation(location.add(direction));
            wheelGeom.setLocalTranslation(location.add(direction));
            locGeom.setMaterial(this.debugAppState.DEBUG_MAGENTA);
            dirGeom.setMaterial(this.debugAppState.DEBUG_MAGENTA);
            axleGeom.setMaterial(this.debugAppState.DEBUG_MAGENTA);
            wheelGeom.setMaterial(this.debugAppState.DEBUG_MAGENTA);
            this.suspensionNode.attachChild(locGeom);
            this.suspensionNode.attachChild(dirGeom);
            this.suspensionNode.attachChild(axleGeom);
            this.suspensionNode.attachChild(wheelGeom);
        }
    }

    protected void controlUpdate(float tpf) {
        for (int i = 0; i < this.body.getNumWheels(); ++i) {
            VehicleWheel physicsVehicleWheel = this.body.getWheel(i);
            Vector3f location = physicsVehicleWheel.getLocation().clone();
            Vector3f direction = physicsVehicleWheel.getDirection().clone();
            Vector3f axle = physicsVehicleWheel.getAxle().clone();
            float restLength = physicsVehicleWheel.getRestLength();
            float radius = physicsVehicleWheel.getRadius();
            Geometry locGeom = (Geometry)this.suspensionNode.getChild("WheelLocationDebugShape" + i);
            Geometry dirGeom = (Geometry)this.suspensionNode.getChild("WheelDirectionDebugShape" + i);
            Geometry axleGeom = (Geometry)this.suspensionNode.getChild("WheelAxleDebugShape" + i);
            Geometry wheelGeom = (Geometry)this.suspensionNode.getChild("WheelRadiusDebugShape" + i);
            Arrow locArrow = (Arrow)locGeom.getMesh();
            locArrow.setArrowExtent(location);
            Arrow axleArrow = (Arrow)axleGeom.getMesh();
            axleArrow.setArrowExtent(axle.normalizeLocal().multLocal(0.3f));
            Arrow wheelArrow = (Arrow)wheelGeom.getMesh();
            wheelArrow.setArrowExtent(direction.normalizeLocal().multLocal(radius));
            Arrow dirArrow = (Arrow)dirGeom.getMesh();
            dirArrow.setArrowExtent(direction.normalizeLocal().multLocal(restLength));
            dirGeom.setLocalTranslation(location);
            axleGeom.setLocalTranslation(location.addLocal(direction));
            wheelGeom.setLocalTranslation(location);
            ++i;
        }
        this.applyPhysicsTransform(this.body.getPhysicsLocation(this.location), this.body.getPhysicsRotation(this.rotation));
    }

    protected void controlRender(RenderManager rm, ViewPort vp) {
    }
}

