/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.debug;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.debug.Arrow;

public class DebugTools {
    protected final AssetManager manager;
    public Material DEBUG_BLUE;
    public Material DEBUG_RED;
    public Material DEBUG_GREEN;
    public Material DEBUG_YELLOW;
    public Material DEBUG_MAGENTA;
    public Material DEBUG_PINK;
    public Node debugNode = new Node("Debug Node");
    public Arrow arrowBlue = new Arrow(Vector3f.ZERO);
    public Geometry arrowBlueGeom = new Geometry("Blue Arrow", this.arrowBlue);
    public Arrow arrowGreen = new Arrow(Vector3f.ZERO);
    public Geometry arrowGreenGeom = new Geometry("Green Arrow", this.arrowGreen);
    public Arrow arrowRed = new Arrow(Vector3f.ZERO);
    public Geometry arrowRedGeom = new Geometry("Red Arrow", this.arrowRed);
    public Arrow arrowMagenta = new Arrow(Vector3f.ZERO);
    public Geometry arrowMagentaGeom = new Geometry("Magenta Arrow", this.arrowMagenta);
    public Arrow arrowYellow = new Arrow(Vector3f.ZERO);
    public Geometry arrowYellowGeom = new Geometry("Yellow Arrow", this.arrowYellow);
    public Arrow arrowPink = new Arrow(Vector3f.ZERO);
    public Geometry arrowPinkGeom = new Geometry("Pink Arrow", this.arrowPink);
    protected static final Vector3f UNIT_X_CHECK = new Vector3f(1.0f, 0.0f, 0.0f);
    protected static final Vector3f UNIT_Y_CHECK = new Vector3f(0.0f, 1.0f, 0.0f);
    protected static final Vector3f UNIT_Z_CHECK = new Vector3f(0.0f, 0.0f, 1.0f);
    protected static final Vector3f UNIT_XYZ_CHECK = new Vector3f(1.0f, 1.0f, 1.0f);
    protected static final Vector3f ZERO_CHECK = new Vector3f(0.0f, 0.0f, 0.0f);

    public DebugTools(AssetManager manager) {
        this.manager = manager;
        this.setupMaterials();
        this.setupDebugNode();
    }

    public void show(RenderManager rm, ViewPort vp) {
        if (!(Vector3f.UNIT_X.equals(UNIT_X_CHECK) && Vector3f.UNIT_Y.equals(UNIT_Y_CHECK) && Vector3f.UNIT_Z.equals(UNIT_Z_CHECK) && Vector3f.UNIT_XYZ.equals(UNIT_XYZ_CHECK) && Vector3f.ZERO.equals(ZERO_CHECK))) {
            throw new IllegalStateException("Unit vectors compromised!\nX: " + Vector3f.UNIT_X + "\nY: " + Vector3f.UNIT_Y + "\nZ: " + Vector3f.UNIT_Z + "\nXYZ: " + Vector3f.UNIT_XYZ + "\nZERO: " + Vector3f.ZERO);
        }
        this.debugNode.updateLogicalState(0.0f);
        this.debugNode.updateGeometricState();
        rm.renderScene(this.debugNode, vp);
    }

    public void setBlueArrow(Vector3f location, Vector3f extent) {
        this.arrowBlueGeom.setLocalTranslation(location);
        this.arrowBlue.setArrowExtent(extent);
    }

    public void setGreenArrow(Vector3f location, Vector3f extent) {
        this.arrowGreenGeom.setLocalTranslation(location);
        this.arrowGreen.setArrowExtent(extent);
    }

    public void setRedArrow(Vector3f location, Vector3f extent) {
        this.arrowRedGeom.setLocalTranslation(location);
        this.arrowRed.setArrowExtent(extent);
    }

    public void setMagentaArrow(Vector3f location, Vector3f extent) {
        this.arrowMagentaGeom.setLocalTranslation(location);
        this.arrowMagenta.setArrowExtent(extent);
    }

    public void setYellowArrow(Vector3f location, Vector3f extent) {
        this.arrowYellowGeom.setLocalTranslation(location);
        this.arrowYellow.setArrowExtent(extent);
    }

    public void setPinkArrow(Vector3f location, Vector3f extent) {
        this.arrowPinkGeom.setLocalTranslation(location);
        this.arrowPink.setArrowExtent(extent);
    }

    protected void setupDebugNode() {
        this.arrowBlueGeom.setMaterial(this.DEBUG_BLUE);
        this.arrowGreenGeom.setMaterial(this.DEBUG_GREEN);
        this.arrowRedGeom.setMaterial(this.DEBUG_RED);
        this.arrowMagentaGeom.setMaterial(this.DEBUG_MAGENTA);
        this.arrowYellowGeom.setMaterial(this.DEBUG_YELLOW);
        this.arrowPinkGeom.setMaterial(this.DEBUG_PINK);
        this.debugNode.attachChild(this.arrowBlueGeom);
        this.debugNode.attachChild(this.arrowGreenGeom);
        this.debugNode.attachChild(this.arrowRedGeom);
        this.debugNode.attachChild(this.arrowMagentaGeom);
        this.debugNode.attachChild(this.arrowYellowGeom);
        this.debugNode.attachChild(this.arrowPinkGeom);
    }

    protected void setupMaterials() {
        this.DEBUG_BLUE = new Material(this.manager, "Common/MatDefs/Misc/Unshaded.j3md");
        this.DEBUG_BLUE.getAdditionalRenderState().setWireframe(true);
        this.DEBUG_BLUE.setColor("Color", ColorRGBA.Blue);
        this.DEBUG_GREEN = new Material(this.manager, "Common/MatDefs/Misc/Unshaded.j3md");
        this.DEBUG_GREEN.getAdditionalRenderState().setWireframe(true);
        this.DEBUG_GREEN.setColor("Color", ColorRGBA.Green);
        this.DEBUG_RED = new Material(this.manager, "Common/MatDefs/Misc/Unshaded.j3md");
        this.DEBUG_RED.getAdditionalRenderState().setWireframe(true);
        this.DEBUG_RED.setColor("Color", ColorRGBA.Red);
        this.DEBUG_YELLOW = new Material(this.manager, "Common/MatDefs/Misc/Unshaded.j3md");
        this.DEBUG_YELLOW.getAdditionalRenderState().setWireframe(true);
        this.DEBUG_YELLOW.setColor("Color", ColorRGBA.Yellow);
        this.DEBUG_MAGENTA = new Material(this.manager, "Common/MatDefs/Misc/Unshaded.j3md");
        this.DEBUG_MAGENTA.getAdditionalRenderState().setWireframe(true);
        this.DEBUG_MAGENTA.setColor("Color", ColorRGBA.Magenta);
        this.DEBUG_PINK = new Material(this.manager, "Common/MatDefs/Misc/Unshaded.j3md");
        this.DEBUG_PINK.getAdditionalRenderState().setWireframe(true);
        this.DEBUG_PINK.setColor("Color", ColorRGBA.Pink);
    }
}

