/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.util;

import com.bulletphysics.collision.shapes.IndexedMesh;
import com.bulletphysics.dom.HeightfieldTerrainShape;
import com.bulletphysics.linearmath.Transform;
import com.jme3.math.FastMath;
import com.jme3.math.Matrix3f;
import com.jme3.math.Quaternion;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.mesh.IndexBuffer;
import com.jme3.util.BufferUtils;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;

public class Converter {
    private Converter() {
    }

    public static com.jme3.math.Vector3f convert(Vector3f oldVec) {
        com.jme3.math.Vector3f newVec = new com.jme3.math.Vector3f();
        Converter.convert(oldVec, newVec);
        return newVec;
    }

    public static com.jme3.math.Vector3f convert(Vector3f oldVec, com.jme3.math.Vector3f newVec) {
        newVec.x = oldVec.x;
        newVec.y = oldVec.y;
        newVec.z = oldVec.z;
        return newVec;
    }

    public static Vector3f convert(com.jme3.math.Vector3f oldVec) {
        Vector3f newVec = new Vector3f();
        Converter.convert(oldVec, newVec);
        return newVec;
    }

    public static Vector3f convert(com.jme3.math.Vector3f oldVec, Vector3f newVec) {
        newVec.x = oldVec.x;
        newVec.y = oldVec.y;
        newVec.z = oldVec.z;
        return newVec;
    }

    public static Quat4f convert(Quaternion oldQuat, Quat4f newQuat) {
        newQuat.w = oldQuat.getW();
        newQuat.x = oldQuat.getX();
        newQuat.y = oldQuat.getY();
        newQuat.z = oldQuat.getZ();
        return newQuat;
    }

    public static Quat4f convert(Quaternion oldQuat) {
        Quat4f newQuat = new Quat4f();
        Converter.convert(oldQuat, newQuat);
        return newQuat;
    }

    public static Quaternion convert(Quat4f oldQuat, Quaternion newQuat) {
        newQuat.set(oldQuat.x, oldQuat.y, oldQuat.z, oldQuat.w);
        return newQuat;
    }

    public static Quaternion convert(Quat4f oldQuat) {
        Quaternion newQuat = new Quaternion();
        Converter.convert(oldQuat, newQuat);
        return newQuat;
    }

    public static Quaternion convert(javax.vecmath.Matrix3f oldMatrix, Quaternion newQuaternion) {
        float z;
        float y;
        float x;
        float w;
        float t = oldMatrix.m00 + oldMatrix.m11 + oldMatrix.m22;
        if (t >= 0.0f) {
            float s = FastMath.sqrt(t + 1.0f);
            w = 0.5f * s;
            s = 0.5f / s;
            x = (oldMatrix.m21 - oldMatrix.m12) * s;
            y = (oldMatrix.m02 - oldMatrix.m20) * s;
            z = (oldMatrix.m10 - oldMatrix.m01) * s;
        } else if (oldMatrix.m00 > oldMatrix.m11 && oldMatrix.m00 > oldMatrix.m22) {
            float s = FastMath.sqrt(1.0f + oldMatrix.m00 - oldMatrix.m11 - oldMatrix.m22);
            x = s * 0.5f;
            s = 0.5f / s;
            y = (oldMatrix.m10 + oldMatrix.m01) * s;
            z = (oldMatrix.m02 + oldMatrix.m20) * s;
            w = (oldMatrix.m21 - oldMatrix.m12) * s;
        } else if (oldMatrix.m11 > oldMatrix.m22) {
            float s = FastMath.sqrt(1.0f + oldMatrix.m11 - oldMatrix.m00 - oldMatrix.m22);
            y = s * 0.5f;
            s = 0.5f / s;
            x = (oldMatrix.m10 + oldMatrix.m01) * s;
            z = (oldMatrix.m21 + oldMatrix.m12) * s;
            w = (oldMatrix.m02 - oldMatrix.m20) * s;
        } else {
            float s = FastMath.sqrt(1.0f + oldMatrix.m22 - oldMatrix.m00 - oldMatrix.m11);
            z = s * 0.5f;
            s = 0.5f / s;
            x = (oldMatrix.m02 + oldMatrix.m20) * s;
            y = (oldMatrix.m21 + oldMatrix.m12) * s;
            w = (oldMatrix.m10 - oldMatrix.m01) * s;
        }
        return newQuaternion.set(x, y, z, w);
    }

    public static javax.vecmath.Matrix3f convert(Quaternion oldQuaternion, javax.vecmath.Matrix3f newMatrix) {
        float norm = oldQuaternion.getW() * oldQuaternion.getW() + oldQuaternion.getX() * oldQuaternion.getX() + oldQuaternion.getY() * oldQuaternion.getY() + oldQuaternion.getZ() * oldQuaternion.getZ();
        float s = norm == 1.0f ? 2.0f : (norm > 0.0f ? 2.0f / norm : 0.0f);
        float xs = oldQuaternion.getX() * s;
        float ys = oldQuaternion.getY() * s;
        float zs = oldQuaternion.getZ() * s;
        float xx = oldQuaternion.getX() * xs;
        float xy = oldQuaternion.getX() * ys;
        float xz = oldQuaternion.getX() * zs;
        float xw = oldQuaternion.getW() * xs;
        float yy = oldQuaternion.getY() * ys;
        float yz = oldQuaternion.getY() * zs;
        float yw = oldQuaternion.getW() * ys;
        float zz = oldQuaternion.getZ() * zs;
        float zw = oldQuaternion.getW() * zs;
        newMatrix.m00 = 1.0f - (yy + zz);
        newMatrix.m01 = xy - zw;
        newMatrix.m02 = xz + yw;
        newMatrix.m10 = xy + zw;
        newMatrix.m11 = 1.0f - (xx + zz);
        newMatrix.m12 = yz - xw;
        newMatrix.m20 = xz - yw;
        newMatrix.m21 = yz + xw;
        newMatrix.m22 = 1.0f - (xx + yy);
        return newMatrix;
    }

    public static Matrix3f convert(javax.vecmath.Matrix3f oldMatrix) {
        Matrix3f newMatrix = new Matrix3f();
        Converter.convert(oldMatrix, newMatrix);
        return newMatrix;
    }

    public static Matrix3f convert(javax.vecmath.Matrix3f oldMatrix, Matrix3f newMatrix) {
        newMatrix.set(0, 0, oldMatrix.m00);
        newMatrix.set(0, 1, oldMatrix.m01);
        newMatrix.set(0, 2, oldMatrix.m02);
        newMatrix.set(1, 0, oldMatrix.m10);
        newMatrix.set(1, 1, oldMatrix.m11);
        newMatrix.set(1, 2, oldMatrix.m12);
        newMatrix.set(2, 0, oldMatrix.m20);
        newMatrix.set(2, 1, oldMatrix.m21);
        newMatrix.set(2, 2, oldMatrix.m22);
        return newMatrix;
    }

    public static javax.vecmath.Matrix3f convert(Matrix3f oldMatrix) {
        javax.vecmath.Matrix3f newMatrix = new javax.vecmath.Matrix3f();
        Converter.convert(oldMatrix, newMatrix);
        return newMatrix;
    }

    public static javax.vecmath.Matrix3f convert(Matrix3f oldMatrix, javax.vecmath.Matrix3f newMatrix) {
        newMatrix.m00 = oldMatrix.get(0, 0);
        newMatrix.m01 = oldMatrix.get(0, 1);
        newMatrix.m02 = oldMatrix.get(0, 2);
        newMatrix.m10 = oldMatrix.get(1, 0);
        newMatrix.m11 = oldMatrix.get(1, 1);
        newMatrix.m12 = oldMatrix.get(1, 2);
        newMatrix.m20 = oldMatrix.get(2, 0);
        newMatrix.m21 = oldMatrix.get(2, 1);
        newMatrix.m22 = oldMatrix.get(2, 2);
        return newMatrix;
    }

    public static Transform convert(com.jme3.math.Transform in, Transform out) {
        Converter.convert(in.getTranslation(), out.origin);
        Converter.convert(in.getRotation(), out.basis);
        return out;
    }

    public static com.jme3.math.Transform convert(Transform in, com.jme3.math.Transform out) {
        Converter.convert(in.origin, out.getTranslation());
        Converter.convert(in.basis, out.getRotation());
        return out;
    }

    public static synchronized IndexedMesh convert(Mesh mesh) {
        IndexedMesh jBulletIndexedMesh = new IndexedMesh();
        jBulletIndexedMesh.triangleIndexBase = ByteBuffer.allocate(mesh.getTriangleCount() * 3 * 4);
        jBulletIndexedMesh.vertexBase = ByteBuffer.allocate(mesh.getVertexCount() * 3 * 4);
        IndexBuffer indices = mesh.getIndicesAsList();
        FloatBuffer vertices = mesh.getFloatBuffer(VertexBuffer.Type.Position);
        vertices.rewind();
        int verticesLength = mesh.getVertexCount() * 3;
        jBulletIndexedMesh.numVertices = mesh.getVertexCount();
        jBulletIndexedMesh.vertexStride = 12;
        for (int i = 0; i < verticesLength; ++i) {
            float tempFloat = vertices.get();
            jBulletIndexedMesh.vertexBase.putFloat(tempFloat);
        }
        int indicesLength = mesh.getTriangleCount() * 3;
        jBulletIndexedMesh.numTriangles = mesh.getTriangleCount();
        jBulletIndexedMesh.triangleIndexStride = 12;
        for (int i = 0; i < indicesLength; ++i) {
            jBulletIndexedMesh.triangleIndexBase.putInt(indices.get(i));
        }
        vertices.rewind();
        vertices.clear();
        return jBulletIndexedMesh;
    }

    public static Mesh convert(IndexedMesh mesh) {
        int i;
        Mesh jmeMesh = new Mesh();
        jmeMesh.setBuffer(VertexBuffer.Type.Index, 3, BufferUtils.createShortBuffer(mesh.numTriangles * 3));
        jmeMesh.setBuffer(VertexBuffer.Type.Position, 3, BufferUtils.createFloatBuffer(mesh.numVertices * 3));
        IndexBuffer indicess = jmeMesh.getIndexBuffer();
        FloatBuffer vertices = jmeMesh.getFloatBuffer(VertexBuffer.Type.Position);
        for (i = 0; i < mesh.numTriangles * 3; ++i) {
            indicess.put(i, mesh.triangleIndexBase.getInt(i * 4));
        }
        for (i = 0; i < mesh.numVertices * 3; ++i) {
            vertices.put(i, mesh.vertexBase.getFloat(i * 4));
        }
        jmeMesh.updateCounts();
        jmeMesh.updateBound();
        jmeMesh.getFloatBuffer(VertexBuffer.Type.Position).clear();
        return jmeMesh;
    }

    public static Mesh convert(HeightfieldTerrainShape heightfieldShape) {
        return null;
    }
}

