/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.cinematic.events;

import com.jme3.animation.AnimChannel;
import com.jme3.animation.AnimControl;
import com.jme3.animation.LoopMode;
import com.jme3.app.Application;
import com.jme3.cinematic.Cinematic;
import com.jme3.cinematic.PlayState;
import com.jme3.cinematic.events.AbstractCinematicEvent;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.scene.Spatial;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class AnimationEvent
extends AbstractCinematicEvent {
    public static final int SAVABLE_VERSION = 2;
    private static final Logger log = Logger.getLogger(AnimationEvent.class.getName());
    public static final String MODEL_CHANNELS = "modelChannels";
    protected AnimChannel channel;
    protected String animationName;
    protected Spatial model;
    protected String modelName;
    protected float blendTime = 0.0f;
    protected int channelIndex = 0;
    protected Cinematic cinematic;

    public AnimationEvent() {
    }

    public AnimationEvent(Spatial model, String animationName) {
        this.model = model;
        this.animationName = animationName;
        this.initialDuration = model.getControl(AnimControl.class).getAnimationLength(animationName);
    }

    public AnimationEvent(Spatial model, String animationName, float initialDuration) {
        super(initialDuration);
        this.model = model;
        this.animationName = animationName;
    }

    public AnimationEvent(Spatial model, String animationName, LoopMode loopMode) {
        super(loopMode);
        this.initialDuration = model.getControl(AnimControl.class).getAnimationLength(animationName);
        this.model = model;
        this.animationName = animationName;
    }

    public AnimationEvent(Spatial model, String animationName, float initialDuration, LoopMode loopMode) {
        super(initialDuration, loopMode);
        this.model = model;
        this.animationName = animationName;
    }

    public AnimationEvent(Spatial model, String animationName, float initialDuration, float blendTime) {
        super(initialDuration);
        this.model = model;
        this.animationName = animationName;
        this.blendTime = blendTime;
    }

    public AnimationEvent(Spatial model, String animationName, LoopMode loopMode, float blendTime) {
        super(loopMode);
        this.initialDuration = model.getControl(AnimControl.class).getAnimationLength(animationName);
        this.model = model;
        this.animationName = animationName;
        this.blendTime = blendTime;
    }

    public AnimationEvent(Spatial model, String animationName, float initialDuration, LoopMode loopMode, float blendTime) {
        super(initialDuration, loopMode);
        this.model = model;
        this.animationName = animationName;
        this.blendTime = blendTime;
    }

    public AnimationEvent(Spatial model, String animationName, LoopMode loopMode, int channelIndex) {
        super(loopMode);
        this.initialDuration = model.getControl(AnimControl.class).getAnimationLength(animationName);
        this.model = model;
        this.animationName = animationName;
        this.channelIndex = channelIndex;
    }

    public AnimationEvent(Spatial model, String animationName, int channelIndex) {
        this.model = model;
        this.animationName = animationName;
        this.initialDuration = model.getControl(AnimControl.class).getAnimationLength(animationName);
        this.channelIndex = channelIndex;
    }

    public AnimationEvent(Spatial model, String animationName, float initialDuration, int channelIndex) {
        super(initialDuration);
        this.model = model;
        this.animationName = animationName;
        this.channelIndex = channelIndex;
    }

    public AnimationEvent(Spatial model, String animationName, float initialDuration, LoopMode loopMode, int channelIndex) {
        super(initialDuration, loopMode);
        this.model = model;
        this.animationName = animationName;
        this.channelIndex = channelIndex;
    }

    public void initEvent(Application app, Cinematic cinematic) {
        super.initEvent(app, cinematic);
        this.cinematic = cinematic;
        if (this.channel == null) {
            HashMap s = cinematic.getEventData(MODEL_CHANNELS, this.model);
            if (s == null) {
                s = new HashMap();
                cinematic.putEventData(MODEL_CHANNELS, this.model, s);
            }
            Map map = s;
            this.channel = (AnimChannel)map.get(this.channelIndex);
            if (this.channel == null) {
                if (this.model == null) {
                    this.model = cinematic.getScene().getChild(this.modelName);
                }
                if (this.model != null) {
                    this.channel = this.model.getControl(AnimControl.class).createChannel();
                    map.put(this.channelIndex, this.channel);
                } else {
                    throw new UnsupportedOperationException("model should not be null");
                }
            }
        }
    }

    public void setTime(float time) {
        super.setTime(time);
        if (!this.animationName.equals(this.channel.getAnimationName())) {
            this.channel.setAnim(this.animationName, this.blendTime);
        }
        float t = time;
        if (this.loopMode == LoopMode.Loop) {
            t %= this.channel.getAnimMaxTime();
        }
        if (this.loopMode == LoopMode.Cycle) {
            float parity = (float)Math.ceil(time / this.channel.getAnimMaxTime());
            t = parity > 0.0f && parity % 2.0f == 0.0f ? this.channel.getAnimMaxTime() - t % this.channel.getAnimMaxTime() : (t %= this.channel.getAnimMaxTime());
        }
        if (t < 0.0f) {
            this.channel.setTime(0.0f);
            this.channel.reset(true);
        }
        if (t > this.channel.getAnimMaxTime()) {
            this.channel.setTime(t);
            this.channel.getControl().update(0.0f);
            this.stop();
        } else {
            this.channel.setTime(t);
            this.channel.getControl().update(0.0f);
        }
    }

    public void onPlay() {
        this.channel.getControl().setEnabled(true);
        if (this.playState == PlayState.Stopped) {
            this.channel.setAnim(this.animationName, this.blendTime);
            this.channel.setSpeed(this.speed);
            this.channel.setLoopMode(this.loopMode);
            this.channel.setTime(0.0f);
        }
    }

    public void setSpeed(float speed) {
        super.setSpeed(speed);
        if (this.channel != null) {
            this.channel.setSpeed(speed);
        }
    }

    public void onUpdate(float tpf) {
    }

    public void onStop() {
    }

    public void forceStop() {
        if (this.channel != null) {
            this.channel.setTime(this.time);
            this.channel.reset(false);
        }
        super.forceStop();
    }

    public void onPause() {
        if (this.channel != null) {
            this.channel.getControl().setEnabled(false);
        }
    }

    public void setLoopMode(LoopMode loopMode) {
        super.setLoopMode(loopMode);
        if (this.channel != null) {
            this.channel.setLoopMode(loopMode);
        }
    }

    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.model, "model", null);
        oc.write(this.animationName, "animationName", "");
        oc.write(this.blendTime, "blendTime", 0.0f);
        oc.write(this.channelIndex, "channelIndex", 0);
    }

    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule(this);
        if (im.getFormatVersion() == 0) {
            this.modelName = ic.readString("modelName", "");
        }
        this.model = (Spatial)ic.readSavable("model", null);
        this.animationName = ic.readString("animationName", "");
        this.blendTime = ic.readFloat("blendTime", 0.0f);
        this.channelIndex = ic.readInt("channelIndex", 0);
    }

    public void dispose() {
        super.dispose();
        Object o = this.cinematic.getEventData(MODEL_CHANNELS, this.model);
        if (o != null) {
            ArrayList list = (ArrayList)o;
            list.remove(this.channel);
            if (list.isEmpty()) {
                this.cinematic.removeEventData(MODEL_CHANNELS, this.model);
            }
        }
        this.cinematic = null;
        this.channel = null;
    }
}

