/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.light;

import com.jme3.bounding.BoundingVolume;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.light.Light;
import com.jme3.math.FastMath;
import com.jme3.math.Vector3f;
import com.jme3.scene.Spatial;
import java.io.IOException;

public class SpotLight
extends Light
implements Savable {
    protected Vector3f position = new Vector3f();
    protected Vector3f direction = new Vector3f(0.0f, -1.0f, 0.0f);
    protected float spotInnerAngle = 0.09817477f;
    protected float spotOuterAngle = 0.1308997f;
    protected float spotRange = 100.0f;
    protected float invSpotRange = 0.0f;
    protected float packedAngleCos = 0.0f;

    public SpotLight() {
        this.computePackedCos();
    }

    private void computePackedCos() {
        float innerCos = FastMath.cos(this.spotInnerAngle);
        float outerCos = FastMath.cos(this.spotOuterAngle);
        this.packedAngleCos = (int)(innerCos * 1000.0f);
        if ((int)this.packedAngleCos == (int)(outerCos * 1000.0f)) {
            outerCos -= 0.001f;
        }
        this.packedAngleCos += outerCos;
    }

    protected void computeLastDistance(Spatial owner) {
        if (owner.getWorldBound() != null) {
            BoundingVolume bv = owner.getWorldBound();
            this.lastDistance = bv.distanceSquaredTo(this.position);
        } else {
            this.lastDistance = owner.getWorldTranslation().distanceSquared(this.position);
        }
    }

    public Light.Type getType() {
        return Light.Type.Spot;
    }

    public Vector3f getDirection() {
        return this.direction;
    }

    public void setDirection(Vector3f direction) {
        this.direction.set(direction);
    }

    public Vector3f getPosition() {
        return this.position;
    }

    public void setPosition(Vector3f position) {
        this.position.set(position);
    }

    public float getSpotRange() {
        return this.spotRange;
    }

    public void setSpotRange(float spotRange) {
        if (spotRange < 0.0f) {
            throw new IllegalArgumentException("SpotLight range cannot be negative");
        }
        this.spotRange = spotRange;
        this.invSpotRange = spotRange != 0.0f ? 1.0f / spotRange : 0.0f;
    }

    public float getInvSpotRange() {
        return this.invSpotRange;
    }

    public float getSpotInnerAngle() {
        return this.spotInnerAngle;
    }

    public void setSpotInnerAngle(float spotInnerAngle) {
        this.spotInnerAngle = spotInnerAngle;
        this.computePackedCos();
    }

    public float getSpotOuterAngle() {
        return this.spotOuterAngle;
    }

    public void setSpotOuterAngle(float spotOuterAngle) {
        this.spotOuterAngle = spotOuterAngle;
        this.computePackedCos();
    }

    public float getPackedAngleCos() {
        return this.packedAngleCos;
    }

    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.direction, "direction", new Vector3f());
        oc.write(this.position, "position", new Vector3f());
        oc.write(this.spotInnerAngle, "spotInnerAngle", 0.09817477f);
        oc.write(this.spotOuterAngle, "spotOuterAngle", 0.1308997f);
        oc.write(this.spotRange, "spotRange", 100.0f);
    }

    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule(this);
        this.spotInnerAngle = ic.readFloat("spotInnerAngle", 0.09817477f);
        this.spotOuterAngle = ic.readFloat("spotOuterAngle", 0.1308997f);
        this.computePackedCos();
        this.direction = (Vector3f)ic.readSavable("direction", new Vector3f());
        this.position = (Vector3f)ic.readSavable("position", new Vector3f());
        this.spotRange = ic.readFloat("spotRange", 100.0f);
        this.invSpotRange = this.spotRange != 0.0f ? 1.0f / this.spotRange : 0.0f;
    }
}

