/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.material;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.material.RenderState;
import com.jme3.material.ShaderGenerationInfo;
import com.jme3.renderer.Caps;
import com.jme3.shader.DefineList;
import com.jme3.shader.ShaderNode;
import com.jme3.shader.UniformBinding;
import com.jme3.shader.VarType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TechniqueDef
implements Savable {
    public static final int SAVABLE_VERSION = 1;
    private EnumSet<Caps> requiredCaps = EnumSet.noneOf(Caps.class);
    private String name;
    private String vertName;
    private String fragName;
    private String vertLanguage;
    private String fragLanguage;
    private DefineList presetDefines;
    private boolean usesShaders;
    private boolean usesNodes = false;
    private List<ShaderNode> shaderNodes;
    private ShaderGenerationInfo shaderGenerationInfo;
    private RenderState renderState;
    private RenderState forcedRenderState;
    private LightMode lightMode = LightMode.Disable;
    private ShadowMode shadowMode = ShadowMode.Disable;
    private HashMap<String, String> defineParams;
    private ArrayList<UniformBinding> worldBinds;

    public TechniqueDef(String name) {
        this.name = name == null ? "Default" : name;
    }

    public TechniqueDef() {
    }

    public String getName() {
        return this.name;
    }

    public LightMode getLightMode() {
        return this.lightMode;
    }

    public void setLightMode(LightMode lightMode) {
        this.lightMode = lightMode;
    }

    public ShadowMode getShadowMode() {
        return this.shadowMode;
    }

    public void setShadowMode(ShadowMode shadowMode) {
        this.shadowMode = shadowMode;
    }

    public RenderState getRenderState() {
        return this.renderState;
    }

    public void setRenderState(RenderState renderState) {
        this.renderState = renderState;
    }

    public boolean isUsingShaders() {
        return this.usesShaders;
    }

    public boolean isUsingShaderNodes() {
        return this.usesNodes;
    }

    public EnumSet<Caps> getRequiredCaps() {
        return this.requiredCaps;
    }

    public void setShaderFile(String vertexShader, String fragmentShader, String vertLanguage, String fragLanguage) {
        this.vertName = vertexShader;
        this.fragName = fragmentShader;
        this.vertLanguage = vertLanguage;
        this.fragLanguage = fragLanguage;
        Caps vertCap = Caps.valueOf(vertLanguage);
        this.requiredCaps.add(vertCap);
        Caps fragCap = Caps.valueOf(fragLanguage);
        this.requiredCaps.add(fragCap);
        this.usesShaders = true;
    }

    public String getShaderParamDefine(String paramName) {
        if (this.defineParams == null) {
            return null;
        }
        return this.defineParams.get(paramName);
    }

    public void addShaderParamDefine(String paramName, String defineName) {
        if (this.defineParams == null) {
            this.defineParams = new HashMap();
        }
        this.defineParams.put(paramName, defineName);
    }

    public DefineList getShaderPresetDefines() {
        return this.presetDefines;
    }

    public void addShaderPresetDefine(String defineName, VarType type, Object value) {
        if (this.presetDefines == null) {
            this.presetDefines = new DefineList();
        }
        this.presetDefines.set(defineName, type, value);
    }

    public String getFragmentShaderName() {
        return this.fragName;
    }

    public String getVertexShaderName() {
        return this.vertName;
    }

    @Deprecated
    public String getShaderLanguage() {
        return this.vertLanguage;
    }

    public String getFragmentShaderLanguage() {
        return this.fragLanguage;
    }

    public String getVertexShaderLanguage() {
        return this.vertLanguage;
    }

    public boolean addWorldParam(String name) {
        if (this.worldBinds == null) {
            this.worldBinds = new ArrayList();
        }
        try {
            this.worldBinds.add(UniformBinding.valueOf(name));
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public RenderState getForcedRenderState() {
        return this.forcedRenderState;
    }

    public void setForcedRenderState(RenderState forcedRenderState) {
        this.forcedRenderState = forcedRenderState;
    }

    public List<UniformBinding> getWorldBindings() {
        return this.worldBinds;
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.name, "name", null);
        oc.write(this.vertName, "vertName", null);
        oc.write(this.fragName, "fragName", null);
        oc.write(this.vertLanguage, "vertLanguage", null);
        oc.write(this.vertLanguage, "fragLanguage", null);
        oc.write(this.presetDefines, "presetDefines", null);
        oc.write(this.lightMode, "lightMode", LightMode.Disable);
        oc.write(this.shadowMode, "shadowMode", ShadowMode.Disable);
        oc.write(this.renderState, "renderState", null);
        oc.write(this.usesShaders, "usesShaders", false);
        oc.write(this.usesNodes, "usesNodes", false);
        oc.writeSavableArrayList((ArrayList)this.shaderNodes, "shaderNodes", null);
        oc.write(this.shaderGenerationInfo, "shaderGenerationInfo", null);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        InputCapsule ic = im.getCapsule(this);
        this.name = ic.readString("name", null);
        this.vertName = ic.readString("vertName", null);
        this.fragName = ic.readString("fragName", null);
        this.presetDefines = (DefineList)ic.readSavable("presetDefines", null);
        this.lightMode = ic.readEnum("lightMode", LightMode.class, LightMode.Disable);
        this.shadowMode = ic.readEnum("shadowMode", ShadowMode.class, ShadowMode.Disable);
        this.renderState = (RenderState)ic.readSavable("renderState", null);
        this.usesShaders = ic.readBoolean("usesShaders", false);
        if (ic.getSavableVersion(TechniqueDef.class) == 0) {
            this.fragLanguage = this.vertLanguage = ic.readString("shaderLang", null);
        } else {
            this.vertLanguage = ic.readString("vertLanguage", null);
            this.fragLanguage = ic.readString("fragLanguage", null);
        }
        this.usesNodes = ic.readBoolean("usesNodes", false);
        this.shaderNodes = ic.readSavableArrayList("shaderNodes", null);
        this.shaderGenerationInfo = (ShaderGenerationInfo)ic.readSavable("shaderGenerationInfo", null);
    }

    public List<ShaderNode> getShaderNodes() {
        return this.shaderNodes;
    }

    public void setShaderNodes(List<ShaderNode> shaderNodes) {
        this.shaderNodes = shaderNodes;
        this.usesNodes = true;
        this.usesShaders = true;
    }

    public ShaderGenerationInfo getShaderGenerationInfo() {
        return this.shaderGenerationInfo;
    }

    public void setShaderGenerationInfo(ShaderGenerationInfo shaderGenerationInfo) {
        this.shaderGenerationInfo = shaderGenerationInfo;
    }

    public String toString() {
        return "TechniqueDef{requiredCaps=" + this.requiredCaps + ", name=" + this.name + ", vertName=" + this.vertName + ", fragName=" + this.fragName + ", vertLanguage=" + this.vertLanguage + ", fragLanguage=" + this.fragLanguage + ", presetDefines=" + this.presetDefines + ", usesShaders=" + this.usesShaders + ", usesNodes=" + this.usesNodes + ", shaderNodes=" + this.shaderNodes + ", shaderGenerationInfo=" + this.shaderGenerationInfo + ", renderState=" + this.renderState + ", forcedRenderState=" + this.forcedRenderState + ", lightMode=" + (Object)((Object)this.lightMode) + ", shadowMode=" + (Object)((Object)this.shadowMode) + ", defineParams=" + this.defineParams + ", worldBinds=" + this.worldBinds + '}';
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ShadowMode {
        Disable,
        InPass,
        PostPass;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LightMode {
        Disable,
        SinglePass,
        MultiPass,
        FixedPipeline;

    }
}

