/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.material.plugins;

import com.jme3.asset.AssetManager;
import com.jme3.asset.AssetNotFoundException;
import com.jme3.asset.ShaderNodeDefinitionKey;
import com.jme3.material.MatParam;
import com.jme3.material.MaterialDef;
import com.jme3.material.ShaderGenerationInfo;
import com.jme3.material.TechniqueDef;
import com.jme3.material.plugins.ConditionParser;
import com.jme3.material.plugins.MatParseException;
import com.jme3.shader.Shader;
import com.jme3.shader.ShaderNode;
import com.jme3.shader.ShaderNodeDefinition;
import com.jme3.shader.ShaderNodeVariable;
import com.jme3.shader.ShaderUtils;
import com.jme3.shader.UniformBinding;
import com.jme3.shader.VariableMapping;
import com.jme3.util.blockparser.Statement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShaderNodeLoaderDelegate {
    protected Map<String, ShaderNodeDefinition> nodeDefinitions;
    protected Map<String, ShaderNode> nodes;
    protected ShaderNodeDefinition shaderNodeDefinition;
    protected ShaderNode shaderNode;
    protected TechniqueDef techniqueDef;
    protected Map<String, DeclaredVariable> attributes = new HashMap<String, DeclaredVariable>();
    protected Map<String, DeclaredVariable> vertexDeclaredUniforms = new HashMap<String, DeclaredVariable>();
    protected Map<String, DeclaredVariable> fragmentDeclaredUniforms = new HashMap<String, DeclaredVariable>();
    protected Map<String, DeclaredVariable> varyings = new HashMap<String, DeclaredVariable>();
    protected MaterialDef materialDef;
    protected String shaderLanguage;
    protected String shaderName;
    protected String varNames = "";
    protected AssetManager assetManager;
    protected ConditionParser conditionParser = new ConditionParser();
    protected List<String> nulledConditions = new ArrayList<String>();

    protected void computeConditions() {
        this.updateConditions(this.vertexDeclaredUniforms);
        this.updateConditions(this.fragmentDeclaredUniforms);
        this.updateConditions(this.varyings);
        for (DeclaredVariable v : this.varyings.values()) {
            for (ShaderNode sn : this.techniqueDef.getShaderNodes()) {
                if (sn.getDefinition().getType() != Shader.ShaderType.Vertex) continue;
                for (VariableMapping mapping : sn.getInputMapping()) {
                    if (!mapping.getLeftVariable().equals(v.var)) continue;
                    if (mapping.getCondition() == null || v.var.getCondition() == null) {
                        mapping.setCondition(v.var.getCondition());
                        continue;
                    }
                    mapping.setCondition("(" + mapping.getCondition() + ") || (" + v.var.getCondition() + ")");
                }
            }
        }
        this.updateConditions(this.attributes);
    }

    public List<ShaderNodeDefinition> readNodesDefinitions(List<Statement> statements, ShaderNodeDefinitionKey key) throws IOException {
        for (Statement statement : statements) {
            String[] split = statement.getLine().split("[ \\{]");
            if (statement.getLine().startsWith("ShaderNodeDefinition")) {
                String name = statement.getLine().substring("ShaderNodeDefinition".length()).trim();
                if (this.getNodeDefinitions().containsKey(name)) continue;
                this.shaderNodeDefinition = new ShaderNodeDefinition();
                this.getNodeDefinitions().put(name, this.shaderNodeDefinition);
                this.shaderNodeDefinition.setName(name);
                this.readShaderNodeDefinition(statement.getContents(), key);
                continue;
            }
            throw new MatParseException("ShaderNodeDefinition", split[0], statement);
        }
        return new ArrayList<ShaderNodeDefinition>(this.getNodeDefinitions().values());
    }

    public void readNodesDefinitions(List<Statement> statements) throws IOException {
        this.readNodesDefinitions(statements, new ShaderNodeDefinitionKey());
    }

    protected void readShaderNodeDefinition(List<Statement> statements, ShaderNodeDefinitionKey key) throws IOException {
        boolean isLoadDoc = key instanceof ShaderNodeDefinitionKey && key.isLoadDocumentation();
        for (Statement statement : statements) {
            String[] split = statement.getLine().split("[ \\{]");
            String line = statement.getLine();
            if (line.startsWith("Type")) {
                String type = line.substring(line.lastIndexOf(58) + 1).trim();
                this.shaderNodeDefinition.setType(Shader.ShaderType.valueOf(type));
                continue;
            }
            if (line.startsWith("Shader ")) {
                this.readShaderStatement(statement);
                this.shaderNodeDefinition.getShadersLanguage().add(this.shaderLanguage);
                this.shaderNodeDefinition.getShadersPath().add(this.shaderName);
                continue;
            }
            if (line.startsWith("Documentation")) {
                if (!isLoadDoc) continue;
                String doc = "";
                for (Statement statement1 : statement.getContents()) {
                    doc = doc + "\n" + statement1.getLine();
                }
                this.shaderNodeDefinition.setDocumentation(doc);
                continue;
            }
            if (line.startsWith("Input")) {
                this.varNames = "";
                for (Statement statement1 : statement.getContents()) {
                    this.shaderNodeDefinition.getInputs().add(this.readVariable(statement1));
                }
                continue;
            }
            if (line.startsWith("Output")) {
                this.varNames = "";
                for (Statement statement1 : statement.getContents()) {
                    this.shaderNodeDefinition.getOutputs().add(this.readVariable(statement1));
                }
                continue;
            }
            throw new MatParseException("one of Type, Shader, Documentation, Input, Output", split[0], statement);
        }
    }

    protected ShaderNodeVariable readVariable(Statement statement) throws IOException {
        String line = statement.getLine().trim().replaceAll("\\s*\\[", "[");
        String[] splitVar = line.split("\\s");
        String varName = splitVar[1];
        String varType = splitVar[0];
        String multiplicity = null;
        if (varName.contains("[")) {
            String[] arr = splitVar[1].split("\\[");
            varName = arr[0].trim();
            multiplicity = arr[1].replaceAll("\\]", "").trim();
        }
        if (this.varNames.contains(varName + ";")) {
            throw new MatParseException("Duplicate variable name " + varName, statement);
        }
        this.varNames = this.varNames + varName + ";";
        return new ShaderNodeVariable(varType, "", varName, multiplicity);
    }

    public void readVertexShaderNodes(List<Statement> statements) throws IOException {
        this.attributes.clear();
        this.readNodes(statements);
    }

    protected void readShaderNode(List<Statement> statements) throws IOException {
        for (Statement statement : statements) {
            VariableMapping mapping;
            String line = statement.getLine();
            String[] split = statement.getLine().split("[ \\{]");
            if (line.startsWith("Definition")) {
                ShaderNodeDefinition def = this.findDefinition(statement);
                this.shaderNode.setDefinition(def);
                continue;
            }
            if (line.startsWith("Condition")) {
                String condition = line.substring(line.lastIndexOf(":") + 1).trim();
                this.extractCondition(condition, statement);
                this.shaderNode.setCondition(this.conditionParser.getFormattedExpression());
                continue;
            }
            if (line.startsWith("InputMapping")) {
                for (Statement statement1 : statement.getContents()) {
                    mapping = this.readInputMapping(statement1);
                    this.techniqueDef.getShaderGenerationInfo().getUnusedNodes().remove(mapping.getRightVariable().getNameSpace());
                    this.shaderNode.getInputMapping().add(mapping);
                }
                continue;
            }
            if (line.startsWith("OutputMapping")) {
                for (Statement statement1 : statement.getContents()) {
                    mapping = this.readOutputMapping(statement1);
                    this.techniqueDef.getShaderGenerationInfo().getUnusedNodes().remove(this.shaderNode.getName());
                    this.shaderNode.getOutputMapping().add(mapping);
                }
                continue;
            }
            throw new MatParseException("ShaderNodeDefinition", split[0], statement);
        }
    }

    protected VariableMapping parseMapping(Statement statement, boolean[] hasNameSpace) throws IOException {
        VariableMapping mapping = new VariableMapping();
        String[] cond = statement.getLine().split(":");
        String[] vars = cond[0].split("=");
        this.checkMappingFormat(vars, statement);
        ShaderNodeVariable[] variables = new ShaderNodeVariable[2];
        String[] swizzle = new String[2];
        for (int i = 0; i < vars.length; ++i) {
            String[] expression = vars[i].trim().split("\\.");
            if (hasNameSpace[i]) {
                if (expression.length <= 3) {
                    variables[i] = new ShaderNodeVariable("", expression[0].trim(), expression[1].trim());
                }
                if (expression.length != 3) continue;
                swizzle[i] = expression[2].trim();
                continue;
            }
            if (expression.length <= 2) {
                variables[i] = new ShaderNodeVariable("", expression[0].trim());
            }
            if (expression.length != 2) continue;
            swizzle[i] = expression[1].trim();
        }
        mapping.setLeftVariable(variables[0]);
        mapping.setLeftSwizzling(swizzle[0] != null ? swizzle[0] : "");
        mapping.setRightVariable(variables[1]);
        mapping.setRightSwizzling(swizzle[1] != null ? swizzle[1] : "");
        if (cond.length > 1) {
            this.extractCondition(cond[1], statement);
            mapping.setCondition(this.conditionParser.getFormattedExpression());
        }
        return mapping;
    }

    public void readFragmentShaderNodes(List<Statement> statements) throws IOException {
        this.readNodes(statements);
    }

    protected void readShaderStatement(Statement statement) throws IOException {
        String[] split = statement.getLine().split(":");
        if (split.length != 2) {
            throw new MatParseException("Shader statement syntax incorrect", statement);
        }
        String[] typeAndLang = split[0].split("\\p{javaWhitespace}+");
        if (typeAndLang.length != 2) {
            throw new MatParseException("Shader statement syntax incorrect", statement);
        }
        this.shaderName = split[1].trim();
        this.shaderLanguage = typeAndLang[1];
    }

    public void setTechniqueDef(TechniqueDef techniqueDef) {
        this.techniqueDef = techniqueDef;
    }

    public void setMaterialDef(MaterialDef materialDef) {
        this.materialDef = materialDef;
    }

    protected boolean updateVariableFromList(ShaderNodeVariable var, List<ShaderNodeVariable> list) {
        for (ShaderNodeVariable shaderNodeVariable : list) {
            if (!shaderNodeVariable.getName().equals(var.getName())) continue;
            var.setType(shaderNodeVariable.getType());
            var.setMultiplicity(shaderNodeVariable.getMultiplicity());
            var.setNameSpace(this.shaderNode.getName());
            return true;
        }
        return false;
    }

    protected void updateRightTypeFromLeftType(VariableMapping mapping) {
        String type = mapping.getLeftVariable().getType();
        int card = ShaderUtils.getCardinality(type, mapping.getRightSwizzling());
        if (card > 0) {
            type = card == 1 ? "float" : "vec" + card;
        }
        mapping.getRightVariable().setType(type);
    }

    protected void checkMappingFormat(String[] vars, Statement statement) throws IOException {
        if (vars.length != 2) {
            throw new MatParseException("Not a valid expression should be '<varName>[.<swizzling>] = <nameSpace>.<varName>[.<swizzling>][:Condition]'", statement);
        }
    }

    protected MatParam findMatParam(String varName) {
        for (MatParam matParam : this.materialDef.getMaterialParams()) {
            if (!varName.equals(matParam.getName())) continue;
            return matParam;
        }
        return null;
    }

    protected UniformBinding findWorldParam(String varName) {
        for (UniformBinding worldParam : this.techniqueDef.getWorldBindings()) {
            if (!varName.equals(worldParam.toString())) continue;
            return worldParam;
        }
        return null;
    }

    protected boolean updateRightFromUniforms(UniformBinding param, VariableMapping mapping, Map<String, DeclaredVariable> map) {
        ShaderNodeVariable right = mapping.getRightVariable();
        String name = "g_" + param.toString();
        DeclaredVariable dv = map.get(name);
        if (dv == null) {
            right.setType(param.getGlslType());
            right.setName(name);
            dv = new DeclaredVariable(right);
            map.put(right.getName(), dv);
            dv.addNode(this.shaderNode);
            mapping.setRightVariable(right);
            return true;
        }
        dv.addNode(this.shaderNode);
        mapping.setRightVariable(dv.var);
        return false;
    }

    public boolean updateRightFromUniforms(MatParam param, VariableMapping mapping, Map<String, DeclaredVariable> map, Statement statement) throws MatParseException {
        ShaderNodeVariable right = mapping.getRightVariable();
        DeclaredVariable dv = map.get(param.getPrefixedName());
        if (dv == null) {
            right.setType(param.getVarType().getGlslType());
            right.setName(param.getPrefixedName());
            if (mapping.getLeftVariable().getMultiplicity() != null) {
                if (!param.getVarType().name().endsWith("Array")) {
                    throw new MatParseException(param.getName() + " is not of Array type", statement);
                }
                String multiplicity = mapping.getLeftVariable().getMultiplicity();
                try {
                    Integer.parseInt(multiplicity);
                }
                catch (NumberFormatException nfe) {
                    MatParam mp = this.findMatParam(multiplicity);
                    if (mp != null) {
                        this.addDefine(multiplicity);
                        multiplicity = multiplicity.toUpperCase();
                    }
                    throw new MatParseException("Wrong multiplicity for variable" + mapping.getLeftVariable().getName() + ". " + multiplicity + " should be an int or a declared material parameter.", statement);
                }
                right.setMultiplicity(multiplicity);
            }
            dv = new DeclaredVariable(right);
            map.put(right.getName(), dv);
            dv.addNode(this.shaderNode);
            mapping.setRightVariable(right);
            return true;
        }
        dv.addNode(this.shaderNode);
        mapping.setRightVariable(dv.var);
        return false;
    }

    public void updateVarFromAttributes(ShaderNodeVariable right, VariableMapping mapping) {
        DeclaredVariable dv = this.attributes.get(right.getName());
        if (dv == null) {
            dv = new DeclaredVariable(right);
            this.attributes.put(right.getName(), dv);
            this.updateRightTypeFromLeftType(mapping);
        } else {
            mapping.setRightVariable(dv.var);
        }
        dv.addNode(this.shaderNode);
    }

    public void addDefine(String paramName) {
        if (this.techniqueDef.getShaderParamDefine(paramName) == null) {
            this.techniqueDef.addShaderParamDefine(paramName, paramName.toUpperCase());
        }
    }

    public ShaderNodeVariable findNodeOutput(List<ShaderNodeVariable> vars, String rightVarName) {
        ShaderNodeVariable var = null;
        for (ShaderNodeVariable variable : vars) {
            if (!variable.getName().equals(rightVarName)) continue;
            var = variable;
        }
        return var;
    }

    public void extractCondition(String cond, Statement statement) throws IOException {
        List<String> defines = this.conditionParser.extractDefines(cond);
        for (String string : defines) {
            MatParam param = this.findMatParam(string);
            if (param != null) {
                this.addDefine(param.getName());
                continue;
            }
            throw new MatParseException("Invalid condition, condition must match a Material Parameter named " + cond, statement);
        }
    }

    public VariableMapping readInputMapping(Statement statement1) throws IOException {
        VariableMapping mapping = null;
        try {
            mapping = this.parseMapping(statement1, new boolean[]{false, true});
        }
        catch (Exception e) {
            throw new MatParseException("Unexpected mapping format", statement1, e);
        }
        ShaderNodeVariable left = mapping.getLeftVariable();
        ShaderNodeVariable right = mapping.getRightVariable();
        if (!this.updateVariableFromList(left, this.shaderNode.getDefinition().getInputs())) {
            throw new MatParseException(left.getName() + " is not an input variable of " + this.shaderNode.getDefinition().getName(), statement1);
        }
        if (left.getType().startsWith("sampler") && !right.getNameSpace().equals("MatParam")) {
            throw new MatParseException("Samplers can only be assigned to MatParams", statement1);
        }
        if (right.getNameSpace().equals("Global")) {
            right.setType("vec4");
            this.storeGlobal(right, statement1);
        } else if (right.getNameSpace().equals("Attr")) {
            if (this.shaderNode.getDefinition().getType() == Shader.ShaderType.Fragment) {
                throw new MatParseException("Cannot have an attribute as input in a fragment shader" + right.getName(), statement1);
            }
            this.updateVarFromAttributes(mapping.getRightVariable(), mapping);
            this.storeAttribute(mapping.getRightVariable());
        } else if (right.getNameSpace().equals("MatParam")) {
            MatParam param = this.findMatParam(right.getName());
            if (param == null) {
                throw new MatParseException("Could not find a Material Parameter named " + right.getName(), statement1);
            }
            if (this.shaderNode.getDefinition().getType() == Shader.ShaderType.Vertex) {
                if (this.updateRightFromUniforms(param, mapping, this.vertexDeclaredUniforms, statement1)) {
                    this.storeVertexUniform(mapping.getRightVariable());
                }
            } else if (this.updateRightFromUniforms(param, mapping, this.fragmentDeclaredUniforms, statement1)) {
                if (mapping.getRightVariable().getType().contains("|")) {
                    String type = this.fixSamplerType(left.getType(), mapping.getRightVariable().getType());
                    if (type != null) {
                        mapping.getRightVariable().setType(type);
                    } else {
                        throw new MatParseException(param.getVarType().toString() + " can only be matched to one of " + param.getVarType().getGlslType().replaceAll("\\|", ",") + " found " + left.getType(), statement1);
                    }
                }
                this.storeFragmentUniform(mapping.getRightVariable());
            }
        } else if (right.getNameSpace().equals("WorldParam")) {
            UniformBinding worldParam = this.findWorldParam(right.getName());
            if (worldParam == null) {
                throw new MatParseException("Could not find a World Parameter named " + right.getName(), statement1);
            }
            if (this.shaderNode.getDefinition().getType() == Shader.ShaderType.Vertex) {
                if (this.updateRightFromUniforms(worldParam, mapping, this.vertexDeclaredUniforms)) {
                    this.storeVertexUniform(mapping.getRightVariable());
                }
            } else if (this.updateRightFromUniforms(worldParam, mapping, this.fragmentDeclaredUniforms)) {
                this.storeFragmentUniform(mapping.getRightVariable());
            }
        } else {
            ShaderNode node = this.nodes.get(right.getNameSpace());
            if (node == null) {
                throw new MatParseException("Undeclared node" + right.getNameSpace() + ". Make sure this node is declared before the current node", statement1);
            }
            ShaderNodeVariable var = this.findNodeOutput(node.getDefinition().getOutputs(), right.getName());
            if (var == null) {
                throw new MatParseException("Cannot find output variable" + right.getName() + " form ShaderNode " + node.getName(), statement1);
            }
            right.setNameSpace(node.getName());
            right.setType(var.getType());
            mapping.setRightVariable(right);
            this.storeVaryings(node, mapping.getRightVariable());
        }
        this.checkTypes(mapping, statement1);
        return mapping;
    }

    public VariableMapping readOutputMapping(Statement statement1) throws IOException {
        VariableMapping mapping = null;
        try {
            mapping = this.parseMapping(statement1, new boolean[]{true, false});
        }
        catch (Exception e) {
            throw new MatParseException("Unexpected mapping format", statement1, e);
        }
        ShaderNodeVariable left = mapping.getLeftVariable();
        ShaderNodeVariable right = mapping.getRightVariable();
        if (left.getType().startsWith("sampler") || right.getType().startsWith("sampler")) {
            throw new MatParseException("Samplers can only be inputs", statement1);
        }
        if (!left.getNameSpace().equals("Global")) {
            throw new MatParseException("Only Global nameSpace is allowed for outputMapping, got" + left.getNameSpace(), statement1);
        }
        left.setType("vec4");
        this.storeGlobal(left, statement1);
        if (!this.updateVariableFromList(right, this.shaderNode.getDefinition().getOutputs())) {
            throw new MatParseException(right.getName() + " is not an output variable of " + this.shaderNode.getDefinition().getName(), statement1);
        }
        this.checkTypes(mapping, statement1);
        return mapping;
    }

    public void readNodes(List<Statement> statements) throws IOException {
        if (this.techniqueDef.getShaderNodes() == null) {
            this.techniqueDef.setShaderNodes(new ArrayList<ShaderNode>());
            this.techniqueDef.setShaderGenerationInfo(new ShaderGenerationInfo());
        }
        for (Statement statement : statements) {
            String[] split = statement.getLine().split("[ \\{]");
            if (statement.getLine().startsWith("ShaderNode ")) {
                String name = statement.getLine().substring("ShaderNode".length()).trim();
                if (this.nodes == null) {
                    this.nodes = new HashMap<String, ShaderNode>();
                }
                if (!this.nodes.containsKey(name)) {
                    this.shaderNode = new ShaderNode();
                    this.shaderNode.setName(name);
                    this.techniqueDef.getShaderGenerationInfo().getUnusedNodes().add(name);
                    this.readShaderNode(statement.getContents());
                    this.nodes.put(name, this.shaderNode);
                    this.techniqueDef.getShaderNodes().add(this.shaderNode);
                    continue;
                }
                throw new MatParseException("ShaderNode " + name + " is already defined", statement);
            }
            throw new MatParseException("ShaderNode", split[0], statement);
        }
    }

    public String fixSamplerType(String leftType, String rightType) {
        String[] types;
        for (String string : types = rightType.split("\\|")) {
            if (!leftType.equals(string)) continue;
            return string;
        }
        return null;
    }

    public void storeGlobal(ShaderNodeVariable var, Statement statement1) throws IOException {
        var.setShaderOutput(true);
        if (this.shaderNode.getDefinition().getType() == Shader.ShaderType.Vertex) {
            ShaderNodeVariable global = this.techniqueDef.getShaderGenerationInfo().getVertexGlobal();
            if (global != null) {
                if (!global.getName().equals(var.getName())) {
                    throw new MatParseException("A global output is already defined for the vertex shader: " + global.getName() + ". vertex shader can only have one global output", statement1);
                }
            } else {
                this.techniqueDef.getShaderGenerationInfo().setVertexGlobal(var);
            }
        } else if (this.shaderNode.getDefinition().getType() == Shader.ShaderType.Fragment) {
            this.storeVariable(var, this.techniqueDef.getShaderGenerationInfo().getFragmentGlobals());
        }
    }

    public void storeAttribute(ShaderNodeVariable var) {
        this.storeVariable(var, this.techniqueDef.getShaderGenerationInfo().getAttributes());
    }

    public void storeVertexUniform(ShaderNodeVariable var) {
        this.storeVariable(var, this.techniqueDef.getShaderGenerationInfo().getVertexUniforms());
    }

    public void storeFragmentUniform(ShaderNodeVariable var) {
        this.storeVariable(var, this.techniqueDef.getShaderGenerationInfo().getFragmentUniforms());
    }

    public void setAssetManager(AssetManager assetManager) {
        this.assetManager = assetManager;
    }

    public ShaderNodeDefinition findDefinition(Statement statement) throws IOException {
        String[] defLine = statement.getLine().split(":");
        String defName = defLine[1].trim();
        ShaderNodeDefinition def = this.getNodeDefinitions().get(defName);
        if (def == null) {
            if (defLine.length == 3) {
                List<ShaderNodeDefinition> defs = null;
                try {
                    defs = this.assetManager.loadAsset(new ShaderNodeDefinitionKey(defLine[2].trim()));
                }
                catch (AssetNotFoundException e) {
                    throw new MatParseException("Couldn't find " + defLine[2].trim(), statement, e);
                }
                for (ShaderNodeDefinition definition : defs) {
                    definition.setPath(defLine[2].trim());
                    if (defName.equals(definition.getName())) {
                        def = definition;
                    }
                    if (this.getNodeDefinitions().containsKey(definition.getName())) continue;
                    this.getNodeDefinitions().put(definition.getName(), definition);
                }
            }
            if (def == null) {
                throw new MatParseException(defName + " is not a declared as Shader Node Definition", statement);
            }
        }
        return def;
    }

    public void storeVaryings(ShaderNode node, ShaderNodeVariable variable) {
        variable.setShaderOutput(true);
        if (node.getDefinition().getType() == Shader.ShaderType.Vertex && this.shaderNode.getDefinition().getType() == Shader.ShaderType.Fragment) {
            DeclaredVariable dv = this.varyings.get(variable.getName());
            if (dv == null) {
                this.techniqueDef.getShaderGenerationInfo().getVaryings().add(variable);
                dv = new DeclaredVariable(variable);
                this.varyings.put(variable.getName(), dv);
            }
            dv.addNode(this.shaderNode);
            for (VariableMapping variableMapping : node.getInputMapping()) {
                if (!variableMapping.getLeftVariable().getName().equals(variable.getName())) continue;
                variableMapping.getLeftVariable().setShaderOutput(true);
            }
        }
    }

    public String mergeConditions(String condition1, String condition2, String operator) {
        if (operator.equals("||") && (condition1 == null || condition2 == null)) {
            return null;
        }
        if (condition1 != null) {
            if (condition2 == null) {
                return condition1;
            }
            String mergedCondition = "(" + condition1 + ") " + operator + " (" + condition2 + ")";
            return mergedCondition;
        }
        return condition2;
    }

    public void storeVariable(ShaderNodeVariable variable, List<ShaderNodeVariable> varList) {
        for (ShaderNodeVariable var : varList) {
            if (!var.getName().equals(variable.getName())) continue;
            return;
        }
        varList.add(variable);
    }

    protected void checkTypes(VariableMapping mapping, Statement statement1) throws MatParseException {
        if (!ShaderUtils.typesMatch(mapping)) {
            String ls = mapping.getLeftSwizzling().length() == 0 ? "" : "." + mapping.getLeftSwizzling();
            String rs = mapping.getRightSwizzling().length() == 0 ? "" : "." + mapping.getRightSwizzling();
            throw new MatParseException("Type mismatch, cannot convert" + mapping.getLeftVariable().getType() + ls + " to " + mapping.getRightVariable().getType() + rs, statement1);
        }
        if (!ShaderUtils.multiplicityMatch(mapping)) {
            String type1 = mapping.getLeftVariable().getType() + "[" + mapping.getLeftVariable().getMultiplicity() + "]";
            String type2 = mapping.getRightVariable().getType() + "[" + mapping.getRightVariable().getMultiplicity() + "]";
            throw new MatParseException("Type mismatch, cannot convert" + type1 + " to " + type2, statement1);
        }
    }

    private Map<String, ShaderNodeDefinition> getNodeDefinitions() {
        if (this.nodeDefinitions == null) {
            this.nodeDefinitions = new HashMap<String, ShaderNodeDefinition>();
        }
        return this.nodeDefinitions;
    }

    private void updateConditions(Map<String, DeclaredVariable> map) {
        for (DeclaredVariable declaredVariable : map.values()) {
            declaredVariable.makeCondition();
        }
    }

    protected class DeclaredVariable {
        ShaderNodeVariable var;
        List<ShaderNode> nodes = new ArrayList<ShaderNode>();

        public DeclaredVariable(ShaderNodeVariable var) {
            this.var = var;
        }

        public void makeCondition() {
            this.var.setCondition(null);
            for (ShaderNode node : this.nodes) {
                String condition = null;
                for (VariableMapping mapping : node.getInputMapping()) {
                    if (!mapping.getRightVariable().equals(this.var)) continue;
                    if (mapping.getCondition() == null) {
                        condition = null;
                        break;
                    }
                    if (condition == null) {
                        condition = "(" + mapping.getCondition() + ")";
                        continue;
                    }
                    if (condition.contains(mapping.getCondition())) continue;
                    condition = condition + " || (" + mapping.getCondition() + ")";
                }
                if (node.getCondition() == null && condition == null) {
                    this.var.setCondition(null);
                    return;
                }
                if (node.getCondition() != null) {
                    if (condition == null) {
                        condition = node.getCondition();
                    } else if (!condition.contains(node.getCondition())) {
                        condition = "(" + node.getCondition() + ") && (" + condition + ")";
                    }
                }
                if (this.var.getCondition() == null) {
                    this.var.setCondition(condition);
                    continue;
                }
                if (this.var.getCondition().contains(condition)) continue;
                this.var.setCondition("(" + this.var.getCondition() + ") || (" + condition + ")");
            }
        }

        public final void addNode(ShaderNode c) {
            if (!this.nodes.contains(c)) {
                this.nodes.add(c);
            }
        }
    }
}

