/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.post.filters;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.post.Filter;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;

public class CrossHatchFilter
extends Filter {
    private ColorRGBA lineColor = ColorRGBA.Black.clone();
    private ColorRGBA paperColor = ColorRGBA.White.clone();
    private float colorInfluenceLine = 0.8f;
    private float colorInfluencePaper = 0.1f;
    private float fillValue = 0.9f;
    private float luminance1 = 0.9f;
    private float luminance2 = 0.7f;
    private float luminance3 = 0.5f;
    private float luminance4 = 0.3f;
    private float luminance5 = 0.0f;
    private float lineThickness = 1.0f;
    private float lineDistance = 4.0f;

    public CrossHatchFilter() {
        super("CrossHatchFilter");
    }

    public CrossHatchFilter(ColorRGBA lineColor, ColorRGBA paperColor) {
        this();
        this.lineColor = lineColor;
        this.paperColor = paperColor;
    }

    protected boolean isRequiresDepthTexture() {
        return false;
    }

    protected void initFilter(AssetManager manager, RenderManager renderManager, ViewPort vp, int w, int h) {
        this.material = new Material(manager, "Common/MatDefs/Post/CrossHatch.j3md");
        this.material.setColor("LineColor", this.lineColor);
        this.material.setColor("PaperColor", this.paperColor);
        this.material.setFloat("ColorInfluenceLine", this.colorInfluenceLine);
        this.material.setFloat("ColorInfluencePaper", this.colorInfluencePaper);
        this.material.setFloat("FillValue", this.fillValue);
        this.material.setFloat("Luminance1", this.luminance1);
        this.material.setFloat("Luminance2", this.luminance2);
        this.material.setFloat("Luminance3", this.luminance3);
        this.material.setFloat("Luminance4", this.luminance4);
        this.material.setFloat("Luminance5", this.luminance5);
        this.material.setFloat("LineThickness", this.lineThickness);
        this.material.setFloat("LineDistance", this.lineDistance);
    }

    protected Material getMaterial() {
        return this.material;
    }

    public void setLineColor(ColorRGBA lineColor) {
        this.lineColor = lineColor;
        if (this.material != null) {
            this.material.setColor("LineColor", lineColor);
        }
    }

    public void setPaperColor(ColorRGBA paperColor) {
        this.paperColor = paperColor;
        if (this.material != null) {
            this.material.setColor("PaperColor", paperColor);
        }
    }

    public void setColorInfluenceLine(float colorInfluenceLine) {
        this.colorInfluenceLine = colorInfluenceLine;
        if (this.material != null) {
            this.material.setFloat("ColorInfluenceLine", colorInfluenceLine);
        }
    }

    public void setColorInfluencePaper(float colorInfluencePaper) {
        this.colorInfluencePaper = colorInfluencePaper;
        if (this.material != null) {
            this.material.setFloat("ColorInfluencePaper", colorInfluencePaper);
        }
    }

    public void setFillValue(float fillValue) {
        this.fillValue = fillValue;
        if (this.material != null) {
            this.material.setFloat("FillValue", fillValue);
        }
    }

    public void setLuminanceLevels(float luminance1, float luminance2, float luminance3, float luminance4, float luminance5) {
        this.luminance1 = luminance1;
        this.luminance2 = luminance2;
        this.luminance3 = luminance3;
        this.luminance4 = luminance4;
        this.luminance5 = luminance5;
        if (this.material != null) {
            this.material.setFloat("Luminance1", luminance1);
            this.material.setFloat("Luminance2", luminance2);
            this.material.setFloat("Luminance3", luminance3);
            this.material.setFloat("Luminance4", luminance4);
            this.material.setFloat("Luminance5", luminance5);
        }
    }

    public void setLineThickness(float lineThickness) {
        this.lineThickness = lineThickness;
        if (this.material != null) {
            this.material.setFloat("LineThickness", lineThickness);
        }
    }

    public void setLineDistance(float lineDistance) {
        this.lineDistance = lineDistance;
        if (this.material != null) {
            this.material.setFloat("LineDistance", lineDistance);
        }
    }

    public ColorRGBA getLineColor() {
        return this.lineColor;
    }

    public ColorRGBA getPaperColor() {
        return this.paperColor;
    }

    public float getColorInfluenceLine() {
        return this.colorInfluenceLine;
    }

    public float getColorInfluencePaper() {
        return this.colorInfluencePaper;
    }

    public float getFillValue() {
        return this.fillValue;
    }

    public float getLineThickness() {
        return this.lineThickness;
    }

    public float getLineDistance() {
        return this.lineDistance;
    }

    public float getLuminance1() {
        return this.luminance1;
    }

    public float getLuminance2() {
        return this.luminance2;
    }

    public float getLuminance3() {
        return this.luminance3;
    }

    public float getLuminance4() {
        return this.luminance4;
    }

    public float getLuminance5() {
        return this.luminance5;
    }
}

