/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.post.filters;

import com.jme3.asset.AssetManager;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.material.Material;
import com.jme3.post.Filter;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import java.io.IOException;

public class FadeFilter
extends Filter {
    private float value = 1.0f;
    private boolean playing = false;
    private float direction = 1.0f;
    private float duration = 1.0f;

    public FadeFilter() {
        super("Fade In/Out");
    }

    public FadeFilter(float duration) {
        this();
        this.duration = duration;
    }

    protected Material getMaterial() {
        this.material.setFloat("Value", this.value);
        return this.material;
    }

    protected void initFilter(AssetManager manager, RenderManager renderManager, ViewPort vp, int w, int h) {
        this.material = new Material(manager, "Common/MatDefs/Post/Fade.j3md");
    }

    protected void preFrame(float tpf) {
        if (this.playing) {
            this.value += tpf * this.direction / this.duration;
            if (this.direction > 0.0f && this.value > 1.0f) {
                this.value = 1.0f;
                this.playing = false;
            }
            if (this.direction < 0.0f && this.value < 0.0f) {
                this.value = 0.0f;
                this.playing = false;
            }
        }
    }

    public float getDuration() {
        return this.duration;
    }

    public void setDuration(float duration) {
        this.duration = duration;
    }

    public void fadeIn() {
        this.setEnabled(true);
        this.direction = 1.0f;
        this.playing = true;
    }

    public void fadeOut() {
        this.setEnabled(true);
        this.direction = -1.0f;
        this.playing = true;
    }

    public void pause() {
        this.playing = false;
    }

    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.duration, "duration", 1.0f);
    }

    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule(this);
        this.duration = ic.readFloat("duration", 1.0f);
    }

    public float getValue() {
        return this.value;
    }

    public void setValue(float value) {
        this.value = value;
        if (this.material != null) {
            this.material.setFloat("Value", value);
        }
    }
}

