/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.renderer;

import com.jme3.math.ColorRGBA;
import com.jme3.post.SceneProcessor;
import com.jme3.renderer.Camera;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Spatial;
import com.jme3.texture.FrameBuffer;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewPort {
    protected final String name;
    protected final Camera cam;
    protected final RenderQueue queue = new RenderQueue();
    protected final ArrayList<Spatial> sceneList = new ArrayList();
    protected final ArrayList<SceneProcessor> processors = new ArrayList();
    protected FrameBuffer out = null;
    protected final ColorRGBA backColor = new ColorRGBA(0.0f, 0.0f, 0.0f, 0.0f);
    protected boolean clearDepth = false;
    protected boolean clearColor = false;
    protected boolean clearStencil = false;
    private boolean enabled = true;

    public ViewPort(String name, Camera cam) {
        this.name = name;
        this.cam = cam;
    }

    public String getName() {
        return this.name;
    }

    public List<SceneProcessor> getProcessors() {
        return this.processors;
    }

    public void addProcessor(SceneProcessor processor) {
        if (processor == null) {
            throw new IllegalArgumentException("Processor cannot be null.");
        }
        this.processors.add(processor);
    }

    public void removeProcessor(SceneProcessor processor) {
        if (processor == null) {
            throw new IllegalArgumentException("Processor cannot be null.");
        }
        this.processors.remove(processor);
        processor.cleanup();
    }

    public void clearProcessors() {
        for (SceneProcessor proc : this.processors) {
            proc.cleanup();
        }
        this.processors.clear();
    }

    public boolean isClearDepth() {
        return this.clearDepth;
    }

    public void setClearDepth(boolean clearDepth) {
        this.clearDepth = clearDepth;
    }

    public boolean isClearColor() {
        return this.clearColor;
    }

    public void setClearColor(boolean clearColor) {
        this.clearColor = clearColor;
    }

    public boolean isClearStencil() {
        return this.clearStencil;
    }

    public void setClearStencil(boolean clearStencil) {
        this.clearStencil = clearStencil;
    }

    public void setClearFlags(boolean color, boolean depth, boolean stencil) {
        this.clearColor = color;
        this.clearDepth = depth;
        this.clearStencil = stencil;
    }

    public FrameBuffer getOutputFrameBuffer() {
        return this.out;
    }

    public void setOutputFrameBuffer(FrameBuffer out) {
        this.out = out;
    }

    public Camera getCamera() {
        return this.cam;
    }

    public RenderQueue getQueue() {
        return this.queue;
    }

    public void attachScene(Spatial scene) {
        if (scene == null) {
            throw new IllegalArgumentException("Scene cannot be null.");
        }
        this.sceneList.add(scene);
        if (scene instanceof Geometry) {
            scene.forceRefresh(true, false, true);
        }
    }

    public void detachScene(Spatial scene) {
        if (scene == null) {
            throw new IllegalArgumentException("Scene cannot be null.");
        }
        this.sceneList.remove(scene);
        if (scene instanceof Geometry) {
            scene.forceRefresh(true, false, true);
        }
    }

    public void clearScenes() {
        this.sceneList.clear();
    }

    public List<Spatial> getScenes() {
        return this.sceneList;
    }

    public void setBackgroundColor(ColorRGBA background) {
        this.backColor.set(background);
    }

    public ColorRGBA getBackgroundColor() {
        return this.backColor;
    }

    public void setEnabled(boolean enable) {
        this.enabled = enable;
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

