/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.renderer.lwjgl;

import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.light.LightList;
import com.jme3.light.PointLight;
import com.jme3.light.SpotLight;
import com.jme3.material.FixedFuncBinding;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.FastMath;
import com.jme3.math.Matrix4f;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Caps;
import com.jme3.renderer.GL1Renderer;
import com.jme3.renderer.RenderContext;
import com.jme3.renderer.RendererException;
import com.jme3.renderer.Statistics;
import com.jme3.renderer.lwjgl.LwjglRenderer;
import com.jme3.renderer.lwjgl.TextureUtil;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.shader.Shader;
import com.jme3.texture.FrameBuffer;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.util.BufferUtils;
import com.jme3.util.NativeObjectManager;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3tools.converters.MipMapGenerator;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LwjglGL1Renderer
implements GL1Renderer {
    private static final Logger logger = Logger.getLogger(LwjglRenderer.class.getName());
    private final ByteBuffer nameBuf = BufferUtils.createByteBuffer(250);
    private final StringBuilder stringBuf = new StringBuilder(250);
    private final IntBuffer ib1 = BufferUtils.createIntBuffer(1);
    private final IntBuffer intBuf16 = BufferUtils.createIntBuffer(16);
    private final FloatBuffer fb16 = BufferUtils.createFloatBuffer(16);
    private final FloatBuffer fb4Null = BufferUtils.createFloatBuffer(4);
    private final RenderContext context = new RenderContext();
    private final NativeObjectManager objManager = new NativeObjectManager();
    private final EnumSet<Caps> caps = EnumSet.noneOf(Caps.class);
    private int maxTexSize;
    private int maxCubeTexSize;
    private int maxVertCount;
    private int maxTriCount;
    private int maxLights;
    private boolean gl12 = false;
    private final Statistics statistics = new Statistics();
    private int vpX;
    private int vpY;
    private int vpW;
    private int vpH;
    private int clipX;
    private int clipY;
    private int clipW;
    private int clipH;
    private Matrix4f worldMatrix = new Matrix4f();
    private Matrix4f viewMatrix = new Matrix4f();
    private ArrayList<Light> lightList = new ArrayList(8);
    private ColorRGBA materialAmbientColor = new ColorRGBA();
    private Vector3f tempVec = new Vector3f();

    protected void updateNameBuffer() {
        int len = this.stringBuf.length();
        this.nameBuf.position(0);
        this.nameBuf.limit(len);
        for (int i = 0; i < len; ++i) {
            this.nameBuf.put((byte)this.stringBuf.charAt(i));
        }
        this.nameBuf.rewind();
    }

    @Override
    public Statistics getStatistics() {
        return this.statistics;
    }

    @Override
    public EnumSet<Caps> getCaps() {
        return this.caps;
    }

    public void initialize() {
        if (GLContext.getCapabilities().OpenGL12) {
            this.gl12 = true;
        }
        GL11.glShadeModel(7425);
        GL11.glColorMaterial(1032, 4609);
        GL11.glHint(3152, 4354);
        if (this.gl12) {
            GL11.glEnable(32826);
        } else {
            GL11.glEnable(2977);
        }
        if (GLContext.getCapabilities().GL_ARB_texture_non_power_of_two) {
            this.caps.add(Caps.NonPowerOfTwoTextures);
        } else {
            logger.log(Level.WARNING, "Your graphics card does not support non-power-of-2 textures. Some features might not work.");
        }
        this.maxLights = GL11.glGetInteger(3377);
        this.maxTexSize = GL11.glGetInteger(3379);
    }

    @Override
    public void invalidateState() {
        this.context.reset();
    }

    @Override
    public void resetGLObjects() {
        logger.log(Level.FINE, "Reseting objects and invalidating state");
        this.objManager.resetObjects();
        this.statistics.clearMemory();
        this.invalidateState();
    }

    @Override
    public void cleanup() {
        logger.log(Level.FINE, "Deleting objects and invalidating state");
        this.objManager.deleteAllObjects(this);
        this.statistics.clearMemory();
        this.invalidateState();
    }

    @Override
    public void setDepthRange(float start, float end) {
        GL11.glDepthRange(start, end);
    }

    @Override
    public void clearBuffers(boolean color, boolean depth, boolean stencil) {
        int bits = 0;
        if (color) {
            if (!this.context.colorWriteEnabled) {
                GL11.glColorMask(true, true, true, true);
                this.context.colorWriteEnabled = true;
            }
            bits = 16384;
        }
        if (depth) {
            if (!this.context.depthWriteEnabled) {
                GL11.glDepthMask(true);
                this.context.depthWriteEnabled = true;
            }
            bits |= 0x100;
        }
        if (stencil) {
            bits |= 0x400;
        }
        if (bits != 0) {
            GL11.glClear(bits);
        }
    }

    @Override
    public void setBackgroundColor(ColorRGBA color) {
        GL11.glClearColor(color.r, color.g, color.b, color.a);
    }

    private void setMaterialColor(int type, ColorRGBA color, ColorRGBA defaultColor) {
        if (color != null) {
            this.fb16.put(color.r).put(color.g).put(color.b).put(color.a).flip();
        } else {
            this.fb16.put(defaultColor.r).put(defaultColor.g).put(defaultColor.b).put(defaultColor.a).flip();
        }
        GL11.glMaterial(1032, type, this.fb16);
    }

    private void applyFixedFuncBindings(boolean forLighting) {
        if (forLighting) {
            GL11.glMaterialf(1032, 5633, this.context.shininess);
            this.setMaterialColor(4608, this.context.ambient, ColorRGBA.DarkGray);
            this.setMaterialColor(4609, this.context.diffuse, ColorRGBA.White);
            this.setMaterialColor(4610, this.context.specular, ColorRGBA.Black);
            if (this.context.useVertexColor) {
                GL11.glEnable(2903);
            } else {
                GL11.glDisable(2903);
            }
        } else {
            ColorRGBA color = this.context.color;
            if (color != null) {
                GL11.glColor4f(color.r, color.g, color.b, color.a);
            } else {
                GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
        if (this.context.alphaTestFallOff > 0.0f) {
            GL11.glEnable(3008);
            GL11.glAlphaFunc(516, this.context.alphaTestFallOff);
        } else {
            GL11.glDisable(3008);
        }
    }

    private void resetFixedFuncBindings() {
        this.context.alphaTestFallOff = 0.0f;
        this.context.color = null;
        this.context.ambient = null;
        this.context.diffuse = null;
        this.context.specular = null;
        this.context.shininess = 0.0f;
        this.context.useVertexColor = false;
    }

    @Override
    public void setFixedFuncBinding(FixedFuncBinding ffBinding, Object val) {
        switch (ffBinding) {
            case Color: {
                this.context.color = (ColorRGBA)val;
                break;
            }
            case MaterialAmbient: {
                this.context.ambient = (ColorRGBA)val;
                break;
            }
            case MaterialDiffuse: {
                this.context.diffuse = (ColorRGBA)val;
                break;
            }
            case MaterialSpecular: {
                this.context.specular = (ColorRGBA)val;
                break;
            }
            case MaterialShininess: {
                this.context.shininess = ((Float)val).floatValue();
                break;
            }
            case UseVertexColor: {
                this.context.useVertexColor = (Boolean)val;
                break;
            }
            case AlphaTestFallOff: {
                this.context.alphaTestFallOff = ((Float)val).floatValue();
            }
        }
    }

    @Override
    public void applyRenderState(RenderState state) {
        if (state.isWireframe() && !this.context.wireframe) {
            GL11.glPolygonMode(1032, 6913);
            this.context.wireframe = true;
        } else if (!state.isWireframe() && this.context.wireframe) {
            GL11.glPolygonMode(1032, 6914);
            this.context.wireframe = false;
        }
        if (state.isDepthTest() && !this.context.depthTestEnabled) {
            GL11.glEnable(2929);
            GL11.glDepthFunc(515);
            this.context.depthTestEnabled = true;
        } else if (!state.isDepthTest() && this.context.depthTestEnabled) {
            GL11.glDisable(2929);
            this.context.depthTestEnabled = false;
        }
        if (state.isAlphaTest()) {
            this.setFixedFuncBinding(FixedFuncBinding.AlphaTestFallOff, Float.valueOf(state.getAlphaFallOff()));
        } else {
            this.setFixedFuncBinding(FixedFuncBinding.AlphaTestFallOff, Float.valueOf(0.0f));
        }
        if (state.isDepthWrite() && !this.context.depthWriteEnabled) {
            GL11.glDepthMask(true);
            this.context.depthWriteEnabled = true;
        } else if (!state.isDepthWrite() && this.context.depthWriteEnabled) {
            GL11.glDepthMask(false);
            this.context.depthWriteEnabled = false;
        }
        if (state.isColorWrite() && !this.context.colorWriteEnabled) {
            GL11.glColorMask(true, true, true, true);
            this.context.colorWriteEnabled = true;
        } else if (!state.isColorWrite() && this.context.colorWriteEnabled) {
            GL11.glColorMask(false, false, false, false);
            this.context.colorWriteEnabled = false;
        }
        if (state.isPointSprite()) {
            logger.log(Level.WARNING, "Point Sprite unsupported!");
        }
        if (state.isPolyOffset()) {
            if (!this.context.polyOffsetEnabled) {
                GL11.glEnable(32823);
                GL11.glPolygonOffset(state.getPolyOffsetFactor(), state.getPolyOffsetUnits());
                this.context.polyOffsetEnabled = true;
                this.context.polyOffsetFactor = state.getPolyOffsetFactor();
                this.context.polyOffsetUnits = state.getPolyOffsetUnits();
            } else if (state.getPolyOffsetFactor() != this.context.polyOffsetFactor || state.getPolyOffsetUnits() != this.context.polyOffsetUnits) {
                GL11.glPolygonOffset(state.getPolyOffsetFactor(), state.getPolyOffsetUnits());
                this.context.polyOffsetFactor = state.getPolyOffsetFactor();
                this.context.polyOffsetUnits = state.getPolyOffsetUnits();
            }
        } else if (this.context.polyOffsetEnabled) {
            GL11.glDisable(32823);
            this.context.polyOffsetEnabled = false;
            this.context.polyOffsetFactor = 0.0f;
            this.context.polyOffsetUnits = 0.0f;
        }
        if (state.getFaceCullMode() != this.context.cullMode) {
            if (state.getFaceCullMode() == RenderState.FaceCullMode.Off) {
                GL11.glDisable(2884);
            } else {
                GL11.glEnable(2884);
            }
            switch (state.getFaceCullMode()) {
                case Off: {
                    break;
                }
                case Back: {
                    GL11.glCullFace(1029);
                    break;
                }
                case Front: {
                    GL11.glCullFace(1028);
                    break;
                }
                case FrontAndBack: {
                    GL11.glCullFace(1032);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unrecognized face cull mode: " + (Object)((Object)state.getFaceCullMode()));
                }
            }
            this.context.cullMode = state.getFaceCullMode();
        }
        if (state.getBlendMode() != this.context.blendMode) {
            if (state.getBlendMode() == RenderState.BlendMode.Off) {
                GL11.glDisable(3042);
            } else {
                GL11.glEnable(3042);
                switch (state.getBlendMode()) {
                    case Off: {
                        break;
                    }
                    case Additive: {
                        GL11.glBlendFunc(1, 1);
                        break;
                    }
                    case AlphaAdditive: {
                        GL11.glBlendFunc(770, 1);
                        break;
                    }
                    case Color: {
                        GL11.glBlendFunc(1, 769);
                        break;
                    }
                    case Alpha: {
                        GL11.glBlendFunc(770, 771);
                        break;
                    }
                    case PremultAlpha: {
                        GL11.glBlendFunc(1, 771);
                        break;
                    }
                    case Modulate: {
                        GL11.glBlendFunc(774, 0);
                        break;
                    }
                    case ModulateX2: {
                        GL11.glBlendFunc(774, 768);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unrecognized blend mode: " + (Object)((Object)state.getBlendMode()));
                    }
                }
            }
            this.context.blendMode = state.getBlendMode();
        }
        if (state.isStencilTest()) {
            throw new UnsupportedOperationException("OpenGL 1.1 doesn't support two sided stencil operations.");
        }
    }

    @Override
    public void setViewPort(int x, int y, int w, int h) {
        if (x != this.vpX || this.vpY != y || this.vpW != w || this.vpH != h) {
            GL11.glViewport(x, y, w, h);
            this.vpX = x;
            this.vpY = y;
            this.vpW = w;
            this.vpH = h;
        }
    }

    @Override
    public void setClipRect(int x, int y, int width, int height) {
        if (!this.context.clipRectEnabled) {
            GL11.glEnable(3089);
            this.context.clipRectEnabled = true;
        }
        if (this.clipX != x || this.clipY != y || this.clipW != width || this.clipH != height) {
            GL11.glScissor(x, y, width, height);
            this.clipX = x;
            this.clipY = y;
            this.clipW = width;
            this.clipH = height;
        }
    }

    @Override
    public void clearClipRect() {
        if (this.context.clipRectEnabled) {
            GL11.glDisable(3089);
            this.context.clipRectEnabled = false;
            this.clipX = 0;
            this.clipY = 0;
            this.clipW = 0;
            this.clipH = 0;
        }
    }

    @Override
    public void onFrame() {
        this.objManager.deleteUnused(this);
    }

    private FloatBuffer storeMatrix(Matrix4f matrix, FloatBuffer store) {
        store.clear();
        matrix.fillFloatBuffer(store, true);
        store.clear();
        return store;
    }

    private void setModelView(Matrix4f modelMatrix, Matrix4f viewMatrix) {
        if (this.context.matrixMode != 5888) {
            GL11.glMatrixMode(5888);
            this.context.matrixMode = 5888;
        }
        GL11.glLoadMatrix(this.storeMatrix(viewMatrix, this.fb16));
        GL11.glMultMatrix(this.storeMatrix(modelMatrix, this.fb16));
    }

    private void setProjection(Matrix4f projMatrix) {
        if (this.context.matrixMode != 5889) {
            GL11.glMatrixMode(5889);
            this.context.matrixMode = 5889;
        }
        GL11.glLoadMatrix(this.storeMatrix(projMatrix, this.fb16));
    }

    @Override
    public void setWorldMatrix(Matrix4f worldMatrix) {
        this.worldMatrix.set(worldMatrix);
    }

    @Override
    public void setViewProjectionMatrices(Matrix4f viewMatrix, Matrix4f projMatrix) {
        this.viewMatrix.set(viewMatrix);
        this.setProjection(projMatrix);
    }

    @Override
    public void setLighting(LightList list) {
        int i;
        if (list == null || list.size() == 0) {
            GL11.glDisable(2896);
            this.applyFixedFuncBindings(false);
            this.setModelView(this.worldMatrix, this.viewMatrix);
            return;
        }
        int numLightsSetPrev = this.lightList.size();
        this.lightList.clear();
        this.materialAmbientColor.set(0.0f, 0.0f, 0.0f, 0.0f);
        for (i = 0; i < list.size(); ++i) {
            Light l = list.get(i);
            if (l.getType() == Light.Type.Ambient) {
                this.materialAmbientColor.addLocal(l.getColor());
                continue;
            }
            this.lightList.add(l);
            if (this.lightList.size() >= this.maxLights) break;
        }
        this.applyFixedFuncBindings(true);
        GL11.glEnable(2896);
        this.fb16.clear();
        this.fb16.put(this.materialAmbientColor.r).put(this.materialAmbientColor.g).put(this.materialAmbientColor.b).put(1.0f).flip();
        GL11.glLightModel(2899, this.fb16);
        if (this.context.matrixMode != 5888) {
            GL11.glMatrixMode(5888);
            this.context.matrixMode = 5888;
        }
        GL11.glLoadMatrix(this.storeMatrix(this.viewMatrix, this.fb16));
        block6: for (i = 0; i < this.lightList.size(); ++i) {
            int glLightIndex = 16384 + i;
            Light light = this.lightList.get(i);
            Light.Type lightType = light.getType();
            ColorRGBA col = light.getColor();
            GL11.glEnable(glLightIndex);
            switch (lightType) {
                case Directional: {
                    DirectionalLight dLight = (DirectionalLight)light;
                    this.fb16.clear();
                    this.fb16.put(col.r).put(col.g).put(col.b).put(col.a).flip();
                    GL11.glLight(glLightIndex, 4609, this.fb16);
                    GL11.glLight(glLightIndex, 4610, this.fb16);
                    Vector3f pos = this.tempVec.set(dLight.getDirection()).negateLocal().normalizeLocal();
                    this.fb16.clear();
                    this.fb16.put(pos.x).put(pos.y).put(pos.z).put(0.0f).flip();
                    GL11.glLight(glLightIndex, 4611, this.fb16);
                    GL11.glLightf(glLightIndex, 4614, 180.0f);
                    continue block6;
                }
                case Point: {
                    PointLight pLight = (PointLight)light;
                    this.fb16.clear();
                    this.fb16.put(col.r).put(col.g).put(col.b).put(col.a).flip();
                    GL11.glLight(glLightIndex, 4609, this.fb16);
                    GL11.glLight(glLightIndex, 4610, this.fb16);
                    Vector3f pos = pLight.getPosition();
                    this.fb16.clear();
                    this.fb16.put(pos.x).put(pos.y).put(pos.z).put(1.0f).flip();
                    GL11.glLight(glLightIndex, 4611, this.fb16);
                    GL11.glLightf(glLightIndex, 4614, 180.0f);
                    if (pLight.getRadius() > 0.0f) {
                        GL11.glLightf(glLightIndex, 4615, 1.0f);
                        GL11.glLightf(glLightIndex, 4616, pLight.getInvRadius() * 2.0f);
                        GL11.glLightf(glLightIndex, 4617, pLight.getInvRadius() * pLight.getInvRadius());
                        continue block6;
                    }
                    GL11.glLightf(glLightIndex, 4615, 1.0f);
                    GL11.glLightf(glLightIndex, 4616, 0.0f);
                    GL11.glLightf(glLightIndex, 4617, 0.0f);
                    continue block6;
                }
                case Spot: {
                    SpotLight sLight = (SpotLight)light;
                    this.fb16.clear();
                    this.fb16.put(col.r).put(col.g).put(col.b).put(col.a).flip();
                    GL11.glLight(glLightIndex, 4609, this.fb16);
                    GL11.glLight(glLightIndex, 4610, this.fb16);
                    Vector3f pos = sLight.getPosition();
                    this.fb16.clear();
                    this.fb16.put(pos.x).put(pos.y).put(pos.z).put(1.0f).flip();
                    GL11.glLight(glLightIndex, 4611, this.fb16);
                    Vector3f dir = sLight.getDirection();
                    this.fb16.clear();
                    this.fb16.put(dir.x).put(dir.y).put(dir.z).put(1.0f).flip();
                    GL11.glLight(glLightIndex, 4612, this.fb16);
                    float outerAngleRad = sLight.getSpotOuterAngle();
                    float innerAngleRad = sLight.getSpotInnerAngle();
                    float spotCut = outerAngleRad * 57.295776f;
                    float spotExpo = 0.0f;
                    if (outerAngleRad > 0.0f) {
                        spotExpo = (1.0f - innerAngleRad / outerAngleRad) * 128.0f;
                    }
                    GL11.glLightf(glLightIndex, 4614, spotCut);
                    GL11.glLightf(glLightIndex, 4613, spotExpo);
                    if (sLight.getSpotRange() > 0.0f) {
                        GL11.glLightf(glLightIndex, 4616, sLight.getInvSpotRange());
                        continue block6;
                    }
                    GL11.glLightf(glLightIndex, 4616, 0.0f);
                    continue block6;
                }
                default: {
                    throw new UnsupportedOperationException("Unrecognized light type: " + (Object)((Object)lightType));
                }
            }
        }
        for (i = this.lightList.size(); i < numLightsSetPrev; ++i) {
            GL11.glDisable(16384 + i);
        }
        this.setModelView(this.worldMatrix, this.viewMatrix);
    }

    private int convertTextureType(Texture.Type type) {
        switch (type) {
            case TwoDimensional: {
                return 3553;
            }
        }
        throw new UnsupportedOperationException("Unknown texture type: " + (Object)((Object)type));
    }

    private int convertMagFilter(Texture.MagFilter filter) {
        switch (filter) {
            case Bilinear: {
                return 9729;
            }
            case Nearest: {
                return 9728;
            }
        }
        throw new UnsupportedOperationException("Unknown mag filter: " + (Object)((Object)filter));
    }

    private int convertMinFilter(Texture.MinFilter filter) {
        switch (filter) {
            case Trilinear: {
                return 9987;
            }
            case BilinearNearestMipMap: {
                return 9985;
            }
            case NearestLinearMipMap: {
                return 9986;
            }
            case NearestNearestMipMap: {
                return 9984;
            }
            case BilinearNoMipMaps: {
                return 9729;
            }
            case NearestNoMipMaps: {
                return 9728;
            }
        }
        throw new UnsupportedOperationException("Unknown min filter: " + (Object)((Object)filter));
    }

    private int convertWrapMode(Texture.WrapMode mode) {
        switch (mode) {
            case EdgeClamp: 
            case Clamp: 
            case BorderClamp: {
                return 10496;
            }
            case Repeat: {
                return 10497;
            }
        }
        throw new UnsupportedOperationException("Unknown wrap mode: " + (Object)((Object)mode));
    }

    private void setupTextureParams(Texture tex) {
        int target = this.convertTextureType(tex.getType());
        int minFilter = this.convertMinFilter(tex.getMinFilter());
        int magFilter = this.convertMagFilter(tex.getMagFilter());
        GL11.glTexParameteri(target, 10241, minFilter);
        GL11.glTexParameteri(target, 10240, magFilter);
        switch (tex.getType()) {
            case TwoDimensional: {
                GL11.glTexParameteri(target, 10243, this.convertWrapMode(tex.getWrap(Texture.WrapAxis.T)));
                GL11.glTexParameteri(target, 10242, this.convertWrapMode(tex.getWrap(Texture.WrapAxis.S)));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown texture type: " + (Object)((Object)tex.getType()));
            }
        }
    }

    public void updateTexImageData(Image img, Texture.Type type, int unit) {
        int texId = img.getId();
        if (texId == -1) {
            GL11.glGenTextures(this.ib1);
            texId = this.ib1.get(0);
            img.setId(texId);
            this.objManager.registerObject(img);
            this.statistics.onNewTexture();
        }
        int target = this.convertTextureType(type);
        if (this.context.boundTextures[unit] != img) {
            GL11.glEnable(target);
            GL11.glBindTexture(target, texId);
            this.context.boundTextures[unit] = img;
            this.statistics.onTextureUse(img, true);
        }
        if (!(GLContext.getCapabilities().GL_ARB_texture_non_power_of_two || img.getWidth() == 0 || img.getHeight() == 0 || FastMath.isPowerOfTwo(img.getWidth()) && FastMath.isPowerOfTwo(img.getHeight()))) {
            MipMapGenerator.resizeToPowerOf2(img);
        }
        if (!img.hasMipmaps() && img.isGeneratedMipmapsRequired()) {
            if (GLContext.getCapabilities().OpenGL14) {
                GL11.glTexParameteri(target, 33169, 1);
            } else {
                MipMapGenerator.generateMipMaps(img);
            }
            img.setMipmapsGenerated(true);
        }
        if (img.getWidth() > this.maxTexSize || img.getHeight() > this.maxTexSize) {
            throw new RendererException("Cannot upload texture " + img + ". The maximum supported texture resolution is " + this.maxTexSize);
        }
        TextureUtil.uploadTexture(img, target, 0, 0);
        img.clearUpdateNeeded();
    }

    @Override
    public void setTexture(int unit, Texture tex) {
        if (unit != 0 || tex.getType() != Texture.Type.TwoDimensional) {
            return;
        }
        Image image = tex.getImage();
        if (image.isUpdateNeeded() || image.isGeneratedMipmapsRequired() && !image.isMipmapsGenerated()) {
            this.updateTexImageData(image, tex.getType(), unit);
        }
        int texId = image.getId();
        assert (texId != -1);
        Image[] textures = this.context.boundTextures;
        int type = this.convertTextureType(tex.getType());
        if (textures[unit] != image) {
            GL11.glEnable(type);
            GL11.glBindTexture(type, texId);
            textures[unit] = image;
            this.statistics.onTextureUse(image, true);
        } else {
            this.statistics.onTextureUse(image, false);
        }
        this.setupTextureParams(tex);
    }

    @Override
    public void modifyTexture(Texture tex, Image pixels, int x, int y) {
        this.setTexture(0, tex);
        TextureUtil.uploadSubTexture(pixels, this.convertTextureType(tex.getType()), 0, x, y);
    }

    private void clearTextureUnits() {
        Image[] textures = this.context.boundTextures;
        if (textures[0] != null) {
            GL11.glDisable(3553);
            textures[0] = null;
        }
    }

    @Override
    public void deleteImage(Image image) {
        int texId = image.getId();
        if (texId != -1) {
            this.ib1.put(0, texId);
            this.ib1.position(0).limit(1);
            GL11.glDeleteTextures(this.ib1);
            image.resetObject();
        }
    }

    private int convertArrayType(VertexBuffer.Type type) {
        switch (type) {
            case Position: {
                return 32884;
            }
            case Normal: {
                return 32885;
            }
            case TexCoord: {
                return 32888;
            }
            case Color: {
                return 32886;
            }
        }
        return -1;
    }

    private int convertVertexFormat(VertexBuffer.Format fmt) {
        switch (fmt) {
            case Byte: {
                return 5120;
            }
            case Float: {
                return 5126;
            }
            case Int: {
                return 5124;
            }
            case Short: {
                return 5122;
            }
            case UnsignedByte: {
                return 5121;
            }
            case UnsignedInt: {
                return 5125;
            }
            case UnsignedShort: {
                return 5123;
            }
        }
        throw new UnsupportedOperationException("Unrecognized vertex format: " + (Object)((Object)fmt));
    }

    private int convertElementMode(Mesh.Mode mode) {
        switch (mode) {
            case Points: {
                return 0;
            }
            case Lines: {
                return 1;
            }
            case LineLoop: {
                return 2;
            }
            case LineStrip: {
                return 3;
            }
            case Triangles: {
                return 4;
            }
            case TriangleFan: {
                return 6;
            }
            case TriangleStrip: {
                return 5;
            }
        }
        throw new UnsupportedOperationException("Unrecognized mesh mode: " + (Object)((Object)mode));
    }

    public void drawTriangleArray(Mesh.Mode mode, int count, int vertCount) {
        if (count > 1) {
            throw new UnsupportedOperationException();
        }
        GL11.glDrawArrays(this.convertElementMode(mode), 0, vertCount);
    }

    public void setVertexAttrib(VertexBuffer vb, VertexBuffer idb) {
        if (vb.getBufferType() == VertexBuffer.Type.Color && !this.context.useVertexColor) {
            return;
        }
        int arrayType = this.convertArrayType(vb.getBufferType());
        if (arrayType == -1) {
            return;
        }
        GL11.glEnableClientState(arrayType);
        this.context.boundAttribs[vb.getBufferType().ordinal()] = vb;
        if (vb.getBufferType() == VertexBuffer.Type.Normal) {
            if (vb.isNormalized() && !this.context.normalizeEnabled) {
                GL11.glEnable(2977);
                this.context.normalizeEnabled = true;
            } else if (!vb.isNormalized() && this.context.normalizeEnabled) {
                GL11.glDisable(2977);
                this.context.normalizeEnabled = false;
            }
        }
        Buffer data = idb != null ? idb.getData() : vb.getData();
        int comps = vb.getNumComponents();
        int type = this.convertVertexFormat(vb.getFormat());
        data.rewind();
        switch (vb.getBufferType()) {
            case Position: {
                if (!(data instanceof FloatBuffer)) {
                    throw new UnsupportedOperationException();
                }
                GL11.glVertexPointer(comps, vb.getStride(), (FloatBuffer)data);
                break;
            }
            case Normal: {
                if (!(data instanceof FloatBuffer)) {
                    throw new UnsupportedOperationException();
                }
                GL11.glNormalPointer(vb.getStride(), (FloatBuffer)data);
                break;
            }
            case Color: {
                if (data instanceof FloatBuffer) {
                    GL11.glColorPointer(comps, vb.getStride(), (FloatBuffer)data);
                    break;
                }
                if (data instanceof ByteBuffer) {
                    GL11.glColorPointer(comps, true, vb.getStride(), (ByteBuffer)data);
                    break;
                }
                throw new UnsupportedOperationException();
            }
            case TexCoord: {
                if (!(data instanceof FloatBuffer)) {
                    throw new UnsupportedOperationException();
                }
                GL11.glTexCoordPointer(comps, vb.getStride(), (FloatBuffer)data);
                break;
            }
        }
    }

    public void setVertexAttrib(VertexBuffer vb) {
        this.setVertexAttrib(vb, null);
    }

    private void drawElements(int mode, int format, Buffer data) {
        switch (format) {
            case 5121: {
                GL11.glDrawElements(mode, (ByteBuffer)data);
                break;
            }
            case 5123: {
                GL11.glDrawElements(mode, (ShortBuffer)data);
                break;
            }
            case 5125: {
                GL11.glDrawElements(mode, (IntBuffer)data);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    public void drawTriangleList(VertexBuffer indexBuf, Mesh mesh, int count) {
        Mesh.Mode mode = mesh.getMode();
        Buffer indexData = indexBuf.getData();
        indexData.rewind();
        if (mesh.getMode() == Mesh.Mode.Hybrid) {
            throw new UnsupportedOperationException();
        }
        this.drawElements(this.convertElementMode(mode), this.convertVertexFormat(indexBuf.getFormat()), indexData);
    }

    public void clearVertexAttribs() {
        for (int i = 0; i < 16; ++i) {
            VertexBuffer vb = this.context.boundAttribs[i];
            if (vb == null) continue;
            int arrayType = this.convertArrayType(vb.getBufferType());
            GL11.glDisableClientState(arrayType);
            this.context.boundAttribs[vb.getBufferType().ordinal()] = null;
        }
    }

    private void renderMeshDefault(Mesh mesh, int lod, int count) {
        VertexBuffer indices = null;
        VertexBuffer interleavedData = mesh.getBuffer(VertexBuffer.Type.InterleavedData);
        if (interleavedData != null && interleavedData.isUpdateNeeded()) {
            this.updateBufferData(interleavedData);
        }
        indices = mesh.getNumLodLevels() > 0 ? mesh.getLodLevel(lod) : mesh.getBuffer(VertexBuffer.Type.Index);
        for (VertexBuffer vb : mesh.getBufferList().getArray()) {
            if (vb.getBufferType() == VertexBuffer.Type.InterleavedData || vb.getUsage() == VertexBuffer.Usage.CpuOnly || vb.getBufferType() == VertexBuffer.Type.Index) continue;
            if (vb.getStride() == 0) {
                this.setVertexAttrib(vb);
                continue;
            }
            this.setVertexAttrib(vb, interleavedData);
        }
        if (indices != null) {
            this.drawTriangleList(indices, mesh, count);
        } else {
            GL11.glDrawArrays(this.convertElementMode(mesh.getMode()), 0, mesh.getVertexCount());
        }
        this.clearVertexAttribs();
        this.clearTextureUnits();
        this.resetFixedFuncBindings();
    }

    @Override
    public void renderMesh(Mesh mesh, int lod, int count) {
        if (mesh.getVertexCount() == 0) {
            return;
        }
        if (this.context.pointSize != mesh.getPointSize()) {
            GL11.glPointSize(mesh.getPointSize());
            this.context.pointSize = mesh.getPointSize();
        }
        if (this.context.lineWidth != mesh.getLineWidth()) {
            GL11.glLineWidth(mesh.getLineWidth());
            this.context.lineWidth = mesh.getLineWidth();
        }
        boolean dynamic = false;
        if (mesh.getBuffer(VertexBuffer.Type.InterleavedData) != null) {
            throw new UnsupportedOperationException("Interleaved meshes are not supported");
        }
        if (mesh.getNumLodLevels() == 0) {
            for (VertexBuffer vb : mesh.getBufferList().getArray()) {
                if (vb.getUsage() == VertexBuffer.Usage.Static) continue;
                dynamic = true;
                break;
            }
        } else {
            dynamic = true;
        }
        this.statistics.onMeshDrawn(mesh, lod);
        this.renderMeshDefault(mesh, lod, count);
    }

    @Override
    public void setAlphaToCoverage(boolean value) {
    }

    @Override
    public void setShader(Shader shader) {
    }

    @Override
    public void deleteShader(Shader shader) {
    }

    @Override
    public void deleteShaderSource(Shader.ShaderSource source) {
    }

    @Override
    public void copyFrameBuffer(FrameBuffer src, FrameBuffer dst) {
    }

    @Override
    public void copyFrameBuffer(FrameBuffer src, FrameBuffer dst, boolean copyDepth) {
    }

    @Override
    public void setMainFrameBufferOverride(FrameBuffer fb) {
    }

    @Override
    public void setFrameBuffer(FrameBuffer fb) {
    }

    @Override
    public void readFrameBuffer(FrameBuffer fb, ByteBuffer byteBuf) {
    }

    @Override
    public void deleteFrameBuffer(FrameBuffer fb) {
    }

    @Override
    public void updateBufferData(VertexBuffer vb) {
    }

    @Override
    public void deleteBuffer(VertexBuffer vb) {
    }
}

