/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.material.Material;
import com.jme3.math.Matrix4f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.mesh.IndexBuffer;
import com.jme3.util.SafeArrayList;
import com.jme3.util.TempVars;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchNode
extends Node
implements Savable {
    private static final Logger logger = Logger.getLogger(BatchNode.class.getName());
    protected SafeArrayList<Batch> batches = new SafeArrayList<Batch>(Batch.class);
    protected Map<Geometry, Batch> batchesByGeom = new HashMap<Geometry, Batch>();
    private float[] tmpFloat;
    private float[] tmpFloatN;
    private float[] tmpFloatT;
    int maxVertCount = 0;
    boolean useTangents = false;
    boolean needsFullRebatch = true;

    public BatchNode() {
    }

    public BatchNode(String name) {
        super(name);
    }

    @Override
    public void updateGeometricState() {
        if ((this.refreshFlags & 4) != 0) {
            this.updateWorldLightList();
        }
        if ((this.refreshFlags & 1) != 0) {
            this.updateWorldTransforms();
        }
        if (!this.children.isEmpty()) {
            for (Spatial child : (Spatial[])this.children.getArray()) {
                child.updateGeometricState();
            }
            for (Batch batch : this.batches.getArray()) {
                if (!batch.needMeshUpdate) continue;
                batch.geometry.updateModelBound();
                batch.geometry.updateWorldBound();
                batch.needMeshUpdate = false;
            }
        }
        if ((this.refreshFlags & 2) != 0) {
            this.updateWorldBound();
        }
        assert (this.refreshFlags == 0);
    }

    protected Matrix4f getTransformMatrix(Geometry g) {
        return g.cachedWorldMat;
    }

    protected void updateSubBatch(Geometry bg) {
        Batch batch = this.batchesByGeom.get(bg);
        if (batch != null) {
            Mesh mesh = batch.geometry.getMesh();
            Mesh origMesh = bg.getMesh();
            VertexBuffer pvb = mesh.getBuffer(VertexBuffer.Type.Position);
            FloatBuffer posBuf = (FloatBuffer)pvb.getData();
            VertexBuffer nvb = mesh.getBuffer(VertexBuffer.Type.Normal);
            FloatBuffer normBuf = (FloatBuffer)nvb.getData();
            VertexBuffer opvb = origMesh.getBuffer(VertexBuffer.Type.Position);
            FloatBuffer oposBuf = (FloatBuffer)opvb.getData();
            VertexBuffer onvb = origMesh.getBuffer(VertexBuffer.Type.Normal);
            FloatBuffer onormBuf = (FloatBuffer)onvb.getData();
            Matrix4f transformMat = this.getTransformMatrix(bg);
            if (mesh.getBuffer(VertexBuffer.Type.Tangent) != null) {
                VertexBuffer tvb = mesh.getBuffer(VertexBuffer.Type.Tangent);
                FloatBuffer tanBuf = (FloatBuffer)tvb.getData();
                VertexBuffer otvb = origMesh.getBuffer(VertexBuffer.Type.Tangent);
                FloatBuffer otanBuf = (FloatBuffer)otvb.getData();
                this.doTransformsTangents(oposBuf, onormBuf, otanBuf, posBuf, normBuf, tanBuf, bg.startIndex, bg.startIndex + bg.getVertexCount(), transformMat);
                tvb.updateData(tanBuf);
            } else {
                this.doTransforms(oposBuf, onormBuf, posBuf, normBuf, bg.startIndex, bg.startIndex + bg.getVertexCount(), transformMat);
            }
            pvb.updateData(posBuf);
            nvb.updateData(normBuf);
            batch.needMeshUpdate = true;
        }
    }

    public void batch() {
        this.doBatch();
        for (Batch batch : this.batches.getArray()) {
            batch.geometry.setIgnoreTransform(true);
            batch.geometry.setUserData("JmePhysicsIgnore", true);
        }
        this.updateGeometricState();
    }

    protected void doBatch() {
        HashMap<Material, List<Geometry>> matMap = new HashMap<Material, List<Geometry>>();
        int nbGeoms = 0;
        this.gatherGeomerties(matMap, this, this.needsFullRebatch);
        if (this.needsFullRebatch) {
            for (Batch batch : this.batches.getArray()) {
                batch.geometry.removeFromParent();
            }
            this.batches.clear();
            this.batchesByGeom.clear();
        }
        if (matMap.size() > 0) {
            this.maxVertCount = 0;
        }
        for (Map.Entry entry : matMap.entrySet()) {
            Batch batch;
            Mesh m = new Mesh();
            Material material = (Material)entry.getKey();
            List list = (List)entry.getValue();
            nbGeoms += list.size();
            String batchName = this.name + "-batch" + this.batches.size();
            if (!this.needsFullRebatch) {
                batch = this.findBatchByMaterial(material);
                if (batch != null) {
                    list.add(0, batch.geometry);
                    batchName = batch.geometry.getName();
                    batch.geometry.removeFromParent();
                } else {
                    batch = new Batch();
                }
            } else {
                batch = new Batch();
            }
            this.mergeGeometries(m, list);
            m.setDynamic();
            batch.updateGeomList(list);
            batch.geometry = new Geometry(batchName);
            batch.geometry.setMaterial(material);
            this.attachChild(batch.geometry);
            batch.geometry.setMesh(m);
            batch.geometry.getMesh().updateCounts();
            batch.geometry.getMesh().updateBound();
            this.batches.add(batch);
        }
        if (this.batches.size() > 0) {
            this.needsFullRebatch = false;
        }
        logger.log(Level.FINE, "Batched {0} geometries in {1} batches.", new Object[]{nbGeoms, this.batches.size()});
        if (matMap.size() > 0) {
            this.tmpFloat = new float[this.maxVertCount * 3];
            this.tmpFloatN = new float[this.maxVertCount * 3];
            if (this.useTangents) {
                this.tmpFloatT = new float[this.maxVertCount * 4];
            }
        }
    }

    @Override
    public Spatial detachChildAt(int index) {
        Spatial s = super.detachChildAt(index);
        if (s instanceof Node) {
            this.unbatchSubGraph(s);
        }
        return s;
    }

    private void unbatchSubGraph(Spatial s) {
        Geometry g;
        if (s instanceof Node) {
            for (Spatial sp : ((Node)s).getChildren()) {
                this.unbatchSubGraph(sp);
            }
        } else if (s instanceof Geometry && (g = (Geometry)s).isBatched()) {
            g.unBatch();
        }
    }

    private void gatherGeomerties(Map<Material, List<Geometry>> map, Spatial n, boolean rebatch) {
        if (n instanceof Geometry) {
            Geometry g;
            if (!(this.isBatch(n) || n.getBatchHint() == Spatial.BatchHint.Never || (g = (Geometry)n).isBatched() && !rebatch)) {
                if (g.getMaterial() == null) {
                    throw new IllegalStateException("No material is set for Geometry: " + g.getName() + " please set a material before batching");
                }
                List<Geometry> list = map.get(g.getMaterial());
                if (list == null) {
                    for (Map.Entry<Material, List<Geometry>> mat : map.entrySet()) {
                        if (!g.getMaterial().contentEquals(mat.getKey())) continue;
                        list = mat.getValue();
                    }
                }
                if (list == null) {
                    list = new ArrayList<Geometry>();
                    map.put(g.getMaterial(), list);
                }
                g.setTransformRefresh();
                list.add(g);
            }
        } else if (n instanceof Node) {
            for (Spatial child : ((Node)n).getChildren()) {
                if (child instanceof BatchNode) continue;
                this.gatherGeomerties(map, child, rebatch);
            }
        }
    }

    private Batch findBatchByMaterial(Material m) {
        for (Batch batch : this.batches.getArray()) {
            if (!batch.geometry.getMaterial().contentEquals(m)) continue;
            return batch;
        }
        return null;
    }

    private boolean isBatch(Spatial s) {
        for (Batch batch : this.batches.getArray()) {
            if (batch.geometry != s) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setMaterial(Material material) {
        throw new UnsupportedOperationException("Unsupported for now, please set the material on the geoms before batching");
    }

    public Material getMaterial() {
        if (!this.batches.isEmpty()) {
            Batch b = this.batches.iterator().next();
            return b.geometry.getMaterial();
        }
        return null;
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule(this);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule(this);
    }

    private void mergeGeometries(Mesh outMesh, List<Geometry> geometries) {
        int[] compsForBuf = new int[VertexBuffer.Type.values().length];
        VertexBuffer.Format[] formatForBuf = new VertexBuffer.Format[compsForBuf.length];
        int totalVerts = 0;
        int totalTris = 0;
        int totalLodLevels = 0;
        int maxWeights = -1;
        Mesh.Mode mode = null;
        for (Geometry geom : geometries) {
            int components;
            Mesh.Mode listMode;
            totalVerts += geom.getVertexCount();
            totalTris += geom.getTriangleCount();
            totalLodLevels = Math.min(totalLodLevels, geom.getMesh().getNumLodLevels());
            if (this.maxVertCount < geom.getVertexCount()) {
                this.maxVertCount = geom.getVertexCount();
            }
            switch (geom.getMesh().getMode()) {
                case Points: {
                    listMode = Mesh.Mode.Points;
                    components = 1;
                    break;
                }
                case LineLoop: 
                case LineStrip: 
                case Lines: {
                    listMode = Mesh.Mode.Lines;
                    components = 2;
                    break;
                }
                case TriangleFan: 
                case TriangleStrip: 
                case Triangles: {
                    listMode = Mesh.Mode.Triangles;
                    components = 3;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            for (VertexBuffer vb : geom.getMesh().getBufferList().getArray()) {
                compsForBuf[vb.getBufferType().ordinal()] = vb.getNumComponents();
                formatForBuf[vb.getBufferType().ordinal()] = vb.getFormat();
            }
            maxWeights = Math.max(maxWeights, geom.getMesh().getMaxNumWeights());
            if (mode != null && mode != listMode) {
                throw new UnsupportedOperationException("Cannot combine different primitive types: " + (Object)((Object)mode) + " != " + (Object)((Object)listMode));
            }
            mode = listMode;
            compsForBuf[VertexBuffer.Type.Index.ordinal()] = components;
        }
        outMesh.setMaxNumWeights(maxWeights);
        outMesh.setMode(mode);
        formatForBuf[VertexBuffer.Type.Index.ordinal()] = totalVerts >= 65536 ? VertexBuffer.Format.UnsignedInt : VertexBuffer.Format.UnsignedShort;
        for (int i = 0; i < compsForBuf.length; ++i) {
            if (compsForBuf[i] == 0) continue;
            Buffer data = i == VertexBuffer.Type.Index.ordinal() ? VertexBuffer.createBuffer(formatForBuf[i], compsForBuf[i], totalTris) : VertexBuffer.createBuffer(formatForBuf[i], compsForBuf[i], totalVerts);
            VertexBuffer vb = new VertexBuffer(VertexBuffer.Type.values()[i]);
            vb.setupData(VertexBuffer.Usage.Dynamic, compsForBuf[i], formatForBuf[i], data);
            outMesh.setBuffer(vb);
        }
        int globalVertIndex = 0;
        int globalTriIndex = 0;
        for (Geometry geom : geometries) {
            Mesh inMesh = geom.getMesh();
            if (!this.isBatch(geom)) {
                geom.batch(this, globalVertIndex);
            }
            int geomVertCount = inMesh.getVertexCount();
            int geomTriCount = inMesh.getTriangleCount();
            for (int bufType = 0; bufType < compsForBuf.length; ++bufType) {
                FloatBuffer outPos;
                VertexBuffer inBuf = inMesh.getBuffer(VertexBuffer.Type.values()[bufType]);
                VertexBuffer outBuf = outMesh.getBuffer(VertexBuffer.Type.values()[bufType]);
                if (outBuf == null) continue;
                if (VertexBuffer.Type.Index.ordinal() == bufType) {
                    int components = compsForBuf[bufType];
                    IndexBuffer inIdx = inMesh.getIndicesAsList();
                    IndexBuffer outIdx = outMesh.getIndexBuffer();
                    for (int tri = 0; tri < geomTriCount; ++tri) {
                        for (int comp = 0; comp < components; ++comp) {
                            int idx = inIdx.get(tri * components + comp) + globalVertIndex;
                            outIdx.put((globalTriIndex + tri) * components + comp, idx);
                        }
                    }
                    continue;
                }
                if (VertexBuffer.Type.Position.ordinal() == bufType) {
                    FloatBuffer inPos = (FloatBuffer)inBuf.getData();
                    outPos = (FloatBuffer)outBuf.getData();
                    this.doCopyBuffer(inPos, globalVertIndex, outPos, 3);
                    continue;
                }
                if (VertexBuffer.Type.Normal.ordinal() == bufType || VertexBuffer.Type.Tangent.ordinal() == bufType) {
                    FloatBuffer inPos = (FloatBuffer)inBuf.getData();
                    outPos = (FloatBuffer)outBuf.getData();
                    this.doCopyBuffer(inPos, globalVertIndex, outPos, compsForBuf[bufType]);
                    if (VertexBuffer.Type.Tangent.ordinal() != bufType) continue;
                    this.useTangents = true;
                    continue;
                }
                inBuf.copyElements(0, outBuf, globalVertIndex, geomVertCount);
            }
            globalVertIndex += geomVertCount;
            globalTriIndex += geomTriCount;
        }
    }

    private void doTransforms(FloatBuffer bindBufPos, FloatBuffer bindBufNorm, FloatBuffer bufPos, FloatBuffer bufNorm, int start, int end, Matrix4f transform) {
        TempVars vars = TempVars.get();
        Vector3f pos = vars.vect1;
        Vector3f norm = vars.vect2;
        int length = (end - start) * 3;
        int offset = start * 3;
        bindBufPos.rewind();
        bindBufNorm.rewind();
        bindBufPos.get(this.tmpFloat, 0, length);
        bindBufNorm.get(this.tmpFloatN, 0, length);
        int index = 0;
        while (index < length) {
            pos.x = this.tmpFloat[index];
            norm.x = this.tmpFloatN[index++];
            pos.y = this.tmpFloat[index];
            norm.y = this.tmpFloatN[index++];
            pos.z = this.tmpFloat[index];
            norm.z = this.tmpFloatN[index];
            transform.mult(pos, pos);
            transform.multNormal(norm, norm);
            this.tmpFloat[index -= 2] = pos.x;
            this.tmpFloatN[index++] = norm.x;
            this.tmpFloat[index] = pos.y;
            this.tmpFloatN[index++] = norm.y;
            this.tmpFloat[index] = pos.z;
            this.tmpFloatN[index++] = norm.z;
        }
        vars.release();
        bufPos.position(offset);
        bufPos.put(this.tmpFloat, 0, length);
        bufNorm.position(offset);
        bufNorm.put(this.tmpFloatN, 0, length);
    }

    private void doTransformsTangents(FloatBuffer bindBufPos, FloatBuffer bindBufNorm, FloatBuffer bindBufTangents, FloatBuffer bufPos, FloatBuffer bufNorm, FloatBuffer bufTangents, int start, int end, Matrix4f transform) {
        TempVars vars = TempVars.get();
        Vector3f pos = vars.vect1;
        Vector3f norm = vars.vect2;
        Vector3f tan = vars.vect3;
        int length = (end - start) * 3;
        int tanLength = (end - start) * 4;
        int offset = start * 3;
        int tanOffset = start * 4;
        bindBufPos.rewind();
        bindBufNorm.rewind();
        bindBufTangents.rewind();
        bindBufPos.get(this.tmpFloat, 0, length);
        bindBufNorm.get(this.tmpFloatN, 0, length);
        bindBufTangents.get(this.tmpFloatT, 0, tanLength);
        int index = 0;
        int tanIndex = 0;
        while (index < length) {
            pos.x = this.tmpFloat[index];
            norm.x = this.tmpFloatN[index++];
            pos.y = this.tmpFloat[index];
            norm.y = this.tmpFloatN[index++];
            pos.z = this.tmpFloat[index];
            norm.z = this.tmpFloatN[index];
            tan.x = this.tmpFloatT[tanIndex++];
            tan.y = this.tmpFloatT[tanIndex++];
            tan.z = this.tmpFloatT[tanIndex++];
            transform.mult(pos, pos);
            transform.multNormal(norm, norm);
            transform.multNormal(tan, tan);
            tanIndex -= 3;
            this.tmpFloat[index -= 2] = pos.x;
            this.tmpFloatN[index++] = norm.x;
            this.tmpFloat[index] = pos.y;
            this.tmpFloatN[index++] = norm.y;
            this.tmpFloat[index] = pos.z;
            this.tmpFloatN[index++] = norm.z;
            this.tmpFloatT[tanIndex++] = tan.x;
            this.tmpFloatT[tanIndex++] = tan.y;
            this.tmpFloatT[tanIndex++] = tan.z;
            ++tanIndex;
        }
        vars.release();
        bufPos.position(offset);
        bufPos.put(this.tmpFloat, 0, length);
        bufNorm.position(offset);
        bufNorm.put(this.tmpFloatN, 0, length);
        bufTangents.position(tanOffset);
        bufTangents.put(this.tmpFloatT, 0, tanLength);
    }

    private void doCopyBuffer(FloatBuffer inBuf, int offset, FloatBuffer outBuf, int componentSize) {
        TempVars vars = TempVars.get();
        Vector3f pos = vars.vect1;
        offset *= componentSize;
        for (int i = 0; i < inBuf.limit() / componentSize; ++i) {
            pos.x = inBuf.get(i * componentSize + 0);
            pos.y = inBuf.get(i * componentSize + 1);
            pos.z = inBuf.get(i * componentSize + 2);
            outBuf.put(offset + i * componentSize + 0, pos.x);
            outBuf.put(offset + i * componentSize + 1, pos.y);
            outBuf.put(offset + i * componentSize + 2, pos.z);
        }
        vars.release();
    }

    protected void setNeedsFullRebatch(boolean needsFullRebatch) {
        this.needsFullRebatch = needsFullRebatch;
    }

    public int getOffsetIndex(Geometry batchedGeometry) {
        return batchedGeometry.startIndex;
    }

    @Override
    public Node clone(boolean cloneMaterials) {
        BatchNode clone = (BatchNode)super.clone(cloneMaterials);
        if (this.batches.size() > 0) {
            block0: for (Batch b : this.batches) {
                for (int i = 0; i < clone.children.size(); ++i) {
                    if (!((Spatial)clone.children.get(i)).getName().equals(b.geometry.getName())) continue;
                    clone.children.remove(i);
                    continue block0;
                }
            }
            clone.needsFullRebatch = true;
            clone.batches.clear();
            clone.batchesByGeom.clear();
            clone.batch();
        }
        return clone;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Batch {
        Geometry geometry;
        boolean needMeshUpdate = false;

        protected Batch() {
        }

        void updateGeomList(List<Geometry> list) {
            for (Geometry geom : list) {
                if (BatchNode.this.isBatch(geom)) continue;
                BatchNode.this.batchesByGeom.put(geom, this);
            }
        }
    }
}

