/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.debug;

import com.jme3.animation.Bone;
import com.jme3.animation.Skeleton;
import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;

public class SkeletonWire
extends Mesh {
    private int numConnections = 0;
    private Skeleton skeleton;

    private void countConnections(Bone bone) {
        for (Bone child : bone.getChildren()) {
            ++this.numConnections;
            this.countConnections(child);
        }
    }

    private void writeConnections(ShortBuffer indexBuf, Bone bone) {
        for (Bone child : bone.getChildren()) {
            indexBuf.put((short)this.skeleton.getBoneIndex(bone));
            indexBuf.put((short)this.skeleton.getBoneIndex(child));
            this.writeConnections(indexBuf, child);
        }
    }

    public SkeletonWire(Skeleton skeleton) {
        this.skeleton = skeleton;
        for (Bone bone : skeleton.getRoots()) {
            this.countConnections(bone);
        }
        this.setMode(Mesh.Mode.Lines);
        VertexBuffer pb = new VertexBuffer(VertexBuffer.Type.Position);
        FloatBuffer fpb = BufferUtils.createFloatBuffer(skeleton.getBoneCount() * 3);
        pb.setupData(VertexBuffer.Usage.Stream, 3, VertexBuffer.Format.Float, fpb);
        this.setBuffer(pb);
        VertexBuffer ib = new VertexBuffer(VertexBuffer.Type.Index);
        ShortBuffer sib = BufferUtils.createShortBuffer(this.numConnections * 2);
        ib.setupData(VertexBuffer.Usage.Static, 2, VertexBuffer.Format.UnsignedShort, sib);
        this.setBuffer(ib);
        for (Bone bone : skeleton.getRoots()) {
            this.writeConnections(sib, bone);
        }
        sib.flip();
        this.updateCounts();
    }

    public void updateGeometry() {
        VertexBuffer vb = this.getBuffer(VertexBuffer.Type.Position);
        FloatBuffer posBuf = this.getFloatBuffer(VertexBuffer.Type.Position);
        posBuf.clear();
        for (int i = 0; i < this.skeleton.getBoneCount(); ++i) {
            Bone bone = this.skeleton.getBone(i);
            Vector3f bonePos = bone.getModelSpacePosition();
            posBuf.put(bonePos.getX()).put(bonePos.getY()).put(bonePos.getZ());
        }
        posBuf.flip();
        vb.updateData(posBuf);
        this.updateBound();
    }
}

