/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.animations;

import com.jme3.animation.Bone;
import com.jme3.animation.Skeleton;
import com.jme3.math.Matrix4f;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.objects.ObjectHelper;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoneContext {
    private BlenderContext blenderContext;
    private Long armatureObjectOMA;
    private Structure boneStructure;
    private String boneName;
    private Matrix4f armatureMatrix;
    private BoneContext parent;
    private List<BoneContext> children = new ArrayList<BoneContext>();
    private Bone bone;
    private Matrix4f restMatrix;
    private Matrix4f inverseTotalTransformation;
    private float length;

    public BoneContext(Long armatureObjectOMA, Structure boneStructure, BlenderContext blenderContext) throws BlenderFileException {
        this(boneStructure, armatureObjectOMA, null, blenderContext);
    }

    private BoneContext(Structure boneStructure, Long armatureObjectOMA, BoneContext parent, BlenderContext blenderContext) throws BlenderFileException {
        this.parent = parent;
        this.blenderContext = blenderContext;
        this.boneStructure = boneStructure;
        this.armatureObjectOMA = armatureObjectOMA;
        this.boneName = boneStructure.getFieldValue("name").toString();
        this.length = ((Number)boneStructure.getFieldValue("length")).floatValue();
        ObjectHelper objectHelper = (ObjectHelper)blenderContext.getHelper(ObjectHelper.class);
        this.armatureMatrix = objectHelper.getMatrix(boneStructure, "arm_mat", blenderContext.getBlenderKey().isFixUpAxis());
        this.restMatrix = this.armatureMatrix.clone();
        this.inverseTotalTransformation = this.restMatrix.invert();
        if (parent != null) {
            this.restMatrix = parent.inverseTotalTransformation.mult(this.restMatrix);
        }
        List<Structure> childbase = ((Structure)boneStructure.getFieldValue("childbase")).evaluateListBase(blenderContext);
        for (Structure child : childbase) {
            this.children.add(new BoneContext(child, armatureObjectOMA, this, blenderContext));
        }
        blenderContext.setBoneContext(boneStructure.getOldMemoryAddress(), this);
    }

    public Bone buildBone(List<Bone> bones, Matrix4f objectToArmatureMatrix, BlenderContext blenderContext) {
        Long boneOMA = this.boneStructure.getOldMemoryAddress();
        this.bone = new Bone(this.boneName);
        bones.add(this.bone);
        blenderContext.addLoadedFeatures(boneOMA, this.boneName, this.boneStructure, this.bone);
        Vector3f poseLocation = this.restMatrix.toTranslationVector();
        Quaternion rotation = this.restMatrix.toRotationQuat().normalizeLocal();
        Vector3f scale = this.restMatrix.toScaleVector();
        if (this.parent == null) {
            Quaternion rotationQuaternion = objectToArmatureMatrix.toRotationQuat().normalizeLocal();
            scale.multLocal(objectToArmatureMatrix.toScaleVector());
            rotationQuaternion.multLocal(poseLocation.addLocal(objectToArmatureMatrix.toTranslationVector()));
            rotation.multLocal(rotationQuaternion);
        }
        this.bone.setBindTransforms(poseLocation, rotation, scale);
        for (BoneContext child : this.children) {
            this.bone.addChild(child.buildBone(bones, objectToArmatureMatrix, blenderContext));
        }
        return this.bone;
    }

    public Bone getBone() {
        return this.bone;
    }

    public Long getBoneOma() {
        return this.boneStructure.getOldMemoryAddress();
    }

    public float getLength() {
        return this.length;
    }

    public Long getArmatureObjectOMA() {
        return this.armatureObjectOMA;
    }

    public Skeleton getSkeleton() {
        return this.blenderContext.getSkeleton(this.armatureObjectOMA);
    }
}

