/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.file;

import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicArray<T>
implements Cloneable {
    private T[] array;
    private int[] tableSizes;

    public DynamicArray(int[] tableSizes, T[] data) throws BlenderFileException {
        this.tableSizes = tableSizes;
        int totalSize = 1;
        for (int size : tableSizes) {
            if (size <= 0) {
                throw new BlenderFileException("The size of the table must be positive!");
            }
            totalSize *= size;
        }
        if (totalSize != data.length) {
            throw new IllegalArgumentException("The size of the table does not match the size of the given data!");
        }
        this.array = data;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public T get(int position) {
        return this.array[position];
    }

    public T get(int ... position) {
        if (position.length != this.tableSizes.length) {
            throw new ArrayIndexOutOfBoundsException("The table accepts " + this.tableSizes.length + " indexing number(s)!");
        }
        int index = 0;
        for (int i = 0; i < position.length - 1; ++i) {
            index += position[i] * this.tableSizes[i + 1];
        }
        return this.array[index += position[position.length - 1]];
    }

    public int getTotalSize() {
        return this.array.length;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.array instanceof Character[]) {
            for (int i = 0; i < this.array.length && ((Character)this.array[i]).charValue() != '\u0000'; ++i) {
                result.append(this.array[i]);
            }
        } else {
            result.append('[');
            for (int i = 0; i < this.array.length; ++i) {
                result.append(this.array[i].toString());
                if (i + 1 >= this.array.length) continue;
                result.append(',');
            }
            result.append(']');
        }
        return result.toString();
    }
}

