/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.lights;

import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.light.PointLight;
import com.jme3.light.SpotLight;
import com.jme3.math.ColorRGBA;
import com.jme3.math.FastMath;
import com.jme3.scene.LightNode;
import com.jme3.scene.plugins.blender.AbstractBlenderHelper;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.Structure;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LightHelper
extends AbstractBlenderHelper {
    private static final Logger LOGGER = Logger.getLogger(LightHelper.class.getName());

    public LightHelper(String blenderVersion, BlenderContext blenderContext) {
        super(blenderVersion, blenderContext);
    }

    public LightNode toLight(Structure structure, BlenderContext blenderContext) throws BlenderFileException {
        LightNode result = (LightNode)blenderContext.getLoadedFeature(structure.getOldMemoryAddress(), BlenderContext.LoadedFeatureDataType.LOADED_FEATURE);
        if (result != null) {
            return result;
        }
        Light light = null;
        int type = ((Number)structure.getFieldValue("type")).intValue();
        switch (type) {
            case 0: {
                light = new PointLight();
                float distance = ((Number)structure.getFieldValue("dist")).floatValue();
                ((PointLight)light).setRadius(distance);
                break;
            }
            case 1: {
                LOGGER.log(Level.WARNING, "'Sun' lamp is not supported in jMonkeyEngine.");
                break;
            }
            case 2: {
                light = new SpotLight();
                ((SpotLight)light).setSpotRange(((Number)structure.getFieldValue("dist")).floatValue());
                float outerAngle = ((Number)structure.getFieldValue("spotsize")).floatValue() * ((float)Math.PI / 180) * 0.5f;
                ((SpotLight)light).setSpotOuterAngle(outerAngle);
                float spotblend = ((Number)structure.getFieldValue("spotblend")).floatValue();
                spotblend = FastMath.clamp(spotblend, 0.0f, 1.0f);
                float innerAngle = outerAngle * (1.0f - spotblend);
                ((SpotLight)light).setSpotInnerAngle(innerAngle);
                break;
            }
            case 3: {
                LOGGER.log(Level.WARNING, "'Hemi' lamp is not supported in jMonkeyEngine.");
                break;
            }
            case 4: {
                light = new DirectionalLight();
                break;
            }
            default: {
                throw new BlenderFileException("Unknown light source type: " + type);
            }
        }
        if (light != null) {
            float r = ((Number)structure.getFieldValue("r")).floatValue();
            float g = ((Number)structure.getFieldValue("g")).floatValue();
            float b = ((Number)structure.getFieldValue("b")).floatValue();
            light.setColor(new ColorRGBA(r, g, b, 1.0f));
            result = new LightNode(null, light);
        }
        return result;
    }

    public boolean shouldBeLoaded(Structure structure, BlenderContext blenderContext) {
        return (blenderContext.getBlenderKey().getFeaturesToLoad() & 0x10) != 0;
    }
}

