/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.materials;

import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector2f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.DynamicArray;
import com.jme3.scene.plugins.blender.file.Pointer;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.materials.MaterialHelper;
import com.jme3.scene.plugins.blender.textures.CombinedTexture;
import com.jme3.scene.plugins.blender.textures.TextureHelper;
import com.jme3.scene.plugins.blender.textures.blending.TextureBlender;
import com.jme3.scene.plugins.blender.textures.blending.TextureBlenderFactory;
import com.jme3.texture.Texture;
import com.jme3.util.BufferUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MaterialContext {
    private static final Logger LOGGER = Logger.getLogger(MaterialContext.class.getName());
    public static final int MTEX_COL = 1;
    public static final int MTEX_NOR = 2;
    public static final int MTEX_SPEC = 4;
    public static final int MTEX_EMIT = 64;
    public static final int MTEX_ALPHA = 128;
    public static final int MTEX_AMB = 2048;
    final String name;
    final Map<Number, CombinedTexture> loadedTextures;
    final ColorRGBA diffuseColor;
    final MaterialHelper.DiffuseShader diffuseShader;
    final MaterialHelper.SpecularShader specularShader;
    final ColorRGBA specularColor;
    final ColorRGBA ambientColor;
    final float shininess;
    final boolean shadeless;
    final boolean vertexColor;
    final boolean transparent;
    final boolean vTangent;
    RenderState.FaceCullMode faceCullMode;

    MaterialContext(Structure structure, BlenderContext blenderContext) throws BlenderFileException {
        this.name = structure.getName();
        int mode = ((Number)structure.getFieldValue("mode")).intValue();
        this.shadeless = (mode & 4) != 0;
        this.vertexColor = (mode & 0x80) != 0;
        this.vTangent = (mode & 0x4000000) != 0;
        int diff_shader = ((Number)structure.getFieldValue("diff_shader")).intValue();
        this.diffuseShader = MaterialHelper.DiffuseShader.values()[diff_shader];
        if (this.shadeless) {
            float r = ((Number)structure.getFieldValue("r")).floatValue();
            float g = ((Number)structure.getFieldValue("g")).floatValue();
            float b = ((Number)structure.getFieldValue("b")).floatValue();
            float alpha = ((Number)structure.getFieldValue("alpha")).floatValue();
            this.diffuseColor = new ColorRGBA(r, g, b, alpha);
            this.specularShader = null;
            this.ambientColor = null;
            this.specularColor = null;
            this.shininess = 0.0f;
        } else {
            this.diffuseColor = this.readDiffuseColor(structure, this.diffuseShader);
            int spec_shader = ((Number)structure.getFieldValue("spec_shader")).intValue();
            this.specularShader = MaterialHelper.SpecularShader.values()[spec_shader];
            this.specularColor = this.readSpecularColor(structure, this.specularShader);
            float r = ((Number)structure.getFieldValue("ambr")).floatValue();
            float g = ((Number)structure.getFieldValue("ambg")).floatValue();
            float b = ((Number)structure.getFieldValue("ambb")).floatValue();
            float alpha = ((Number)structure.getFieldValue("alpha")).floatValue();
            this.ambientColor = new ColorRGBA(r, g, b, alpha);
            float shininess = ((Number)structure.getFieldValue("emit")).floatValue();
            this.shininess = shininess > 0.0f ? shininess : 20.0f;
        }
        DynamicArray mtexsArray = (DynamicArray)structure.getFieldValue("mtex");
        int separatedTextures = ((Number)structure.getFieldValue("septex")).intValue();
        ArrayList<TextureData> texturesList = new ArrayList<TextureData>();
        for (int i = 0; i < mtexsArray.getTotalSize(); ++i) {
            Structure tex;
            Pointer pTex;
            Pointer p = (Pointer)mtexsArray.get(i);
            if (!p.isNotNull() || (separatedTextures & 1 << i) != 0) continue;
            TextureData textureData = new TextureData();
            textureData.mtex = p.fetchData(blenderContext.getInputStream()).get(0);
            textureData.uvCoordinatesType = ((Number)textureData.mtex.getFieldValue("texco")).intValue();
            textureData.projectionType = ((Number)textureData.mtex.getFieldValue("mapping")).intValue();
            textureData.uvCoordinatesName = textureData.mtex.getFieldValue("uvName").toString();
            if (textureData.uvCoordinatesName != null && textureData.uvCoordinatesName.trim().length() == 0) {
                textureData.uvCoordinatesName = null;
            }
            if (!(pTex = (Pointer)textureData.mtex.getFieldValue("tex")).isNotNull()) continue;
            textureData.textureStructure = tex = pTex.fetchData(blenderContext.getInputStream()).get(0);
            texturesList.add(textureData);
        }
        Map<Number, List<TextureData>> textureDataMap = this.sortAndFilterTextures(texturesList);
        this.loadedTextures = new HashMap<Number, CombinedTexture>();
        float[] diffuseColorArray = new float[]{this.diffuseColor.r, this.diffuseColor.g, this.diffuseColor.b, this.diffuseColor.a};
        TextureHelper textureHelper = (TextureHelper)blenderContext.getHelper(TextureHelper.class);
        for (Map.Entry<Number, List<TextureData>> entry : textureDataMap.entrySet()) {
            if (entry.getValue().size() <= 0) continue;
            CombinedTexture combinedTexture = new CombinedTexture(entry.getKey().intValue());
            for (TextureData textureData : entry.getValue()) {
                boolean negateTexture;
                int texflag = ((Number)textureData.mtex.getFieldValue("texflag")).intValue();
                boolean bl = negateTexture = (texflag & 4) != 0;
                Texture texture = textureHelper.getTexture(textureData.textureStructure, textureData.mtex, blenderContext);
                if (texture == null) continue;
                int blendType = ((Number)textureData.mtex.getFieldValue("blendtype")).intValue();
                float[] color = new float[]{((Number)textureData.mtex.getFieldValue("r")).floatValue(), ((Number)textureData.mtex.getFieldValue("g")).floatValue(), ((Number)textureData.mtex.getFieldValue("b")).floatValue()};
                float colfac = ((Number)textureData.mtex.getFieldValue("colfac")).floatValue();
                TextureBlender textureBlender = TextureBlenderFactory.createTextureBlender(texture.getImage().getFormat(), texflag, negateTexture, blendType, diffuseColorArray, color, colfac);
                combinedTexture.add(texture, textureBlender, textureData.uvCoordinatesType, textureData.projectionType, textureData.textureStructure, textureData.uvCoordinatesName, blenderContext);
            }
            if (combinedTexture.getTexturesCount() <= 0) continue;
            this.loadedTextures.put(entry.getKey(), combinedTexture);
        }
        boolean transparent = false;
        if (this.diffuseColor != null) {
            boolean bl = transparent = this.diffuseColor.a < 1.0f;
            if (textureDataMap.size() > 0) {
                this.diffuseColor.set(1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
        if (this.specularColor != null) {
            boolean bl = transparent = transparent || this.specularColor.a < 1.0f;
        }
        if (this.ambientColor != null) {
            transparent = transparent || this.ambientColor.a < 1.0f;
        }
        this.transparent = transparent;
    }

    public void applyMaterial(Geometry geometry, Long geometriesOMA, LinkedHashMap<String, List<Vector2f>> userDefinedUVCoordinates, BlenderContext blenderContext) {
        Material material = null;
        if (this.shadeless) {
            material = new Material(blenderContext.getAssetManager(), "Common/MatDefs/Misc/Unshaded.j3md");
            if (!this.transparent) {
                this.diffuseColor.a = 1.0f;
            }
            material.setColor("Color", this.diffuseColor);
        } else {
            material = new Material(blenderContext.getAssetManager(), "Common/MatDefs/Light/Lighting.j3md");
            material.setBoolean("UseMaterialColors", Boolean.TRUE);
            material.setBoolean("Minnaert", this.diffuseShader == MaterialHelper.DiffuseShader.MINNAERT);
            if (!this.transparent) {
                this.diffuseColor.a = 1.0f;
            }
            material.setColor("Diffuse", this.diffuseColor);
            material.setBoolean("WardIso", this.specularShader == MaterialHelper.SpecularShader.WARDISO);
            material.setColor("Specular", this.specularColor);
            material.setColor("Ambient", this.ambientColor);
            material.setFloat("Shininess", this.shininess);
        }
        if (this.loadedTextures != null && this.loadedTextures.size() > 0) {
            int textureIndex = 0;
            if (this.loadedTextures.size() > 8) {
                LOGGER.log(Level.WARNING, "The blender file has defined more than {0} different textures. JME supports only {0} UV mappings.", TextureHelper.TEXCOORD_TYPES.length);
            }
            for (Map.Entry<Number, CombinedTexture> entry : this.loadedTextures.entrySet()) {
                if (textureIndex < TextureHelper.TEXCOORD_TYPES.length) {
                    CombinedTexture combinedTexture = entry.getValue();
                    combinedTexture.flatten(geometry, geometriesOMA, userDefinedUVCoordinates, blenderContext);
                    this.setTexture(material, entry.getKey().intValue(), combinedTexture.getResultTexture());
                    List<Vector2f> uvs = entry.getValue().getResultUVS();
                    VertexBuffer uvCoordsBuffer = new VertexBuffer(TextureHelper.TEXCOORD_TYPES[textureIndex++]);
                    uvCoordsBuffer.setupData(VertexBuffer.Usage.Static, 2, VertexBuffer.Format.Float, BufferUtils.createFloatBuffer(uvs.toArray(new Vector2f[uvs.size()])));
                    geometry.getMesh().setBuffer(uvCoordsBuffer);
                    continue;
                }
                LOGGER.log(Level.WARNING, "The texture could not be applied because JME only supports up to {0} different UV's.", TextureHelper.TEXCOORD_TYPES.length);
            }
        }
        material.setName(this.name);
        if (this.vertexColor) {
            material.setBoolean(this.shadeless ? "VertexColor" : "UseVertexColor", true);
        }
        material.getAdditionalRenderState().setFaceCullMode(this.faceCullMode != null ? this.faceCullMode : blenderContext.getBlenderKey().getFaceCullMode());
        if (this.transparent) {
            material.setTransparent(true);
            material.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
            geometry.setQueueBucket(RenderQueue.Bucket.Transparent);
        }
        geometry.setMaterial(material);
    }

    private void setTexture(Material material, int mapTo, Texture texture) {
        switch (mapTo) {
            case 1: {
                material.setTexture(this.shadeless ? "ColorMap" : "DiffuseMap", texture);
                break;
            }
            case 2: {
                material.setTexture("NormalMap", texture);
                break;
            }
            case 4: {
                material.setTexture("SpecularMap", texture);
                break;
            }
            case 64: {
                material.setTexture("GlowMap", texture);
                break;
            }
            case 128: {
                if (!this.shadeless) {
                    material.setTexture("AlphaMap", texture);
                    break;
                }
                LOGGER.warning("JME does not support alpha map on unshaded material. Material name is " + this.name);
                break;
            }
            case 2048: {
                material.setTexture("LightMap", texture);
                break;
            }
            default: {
                LOGGER.severe("Unknown mapping type: " + mapTo);
            }
        }
    }

    public boolean hasGeneratedTextures() {
        if (this.loadedTextures != null) {
            for (Map.Entry<Number, CombinedTexture> entry : this.loadedTextures.entrySet()) {
                if (!entry.getValue().hasGeneratedTextures()) continue;
                return true;
            }
        }
        return false;
    }

    private Map<Number, List<TextureData>> sortAndFilterTextures(List<TextureData> textures) {
        int[] mappings = new int[]{1, 2, 64, 4, 128, 2048};
        HashMap<Number, List<TextureData>> result = new HashMap<Number, List<TextureData>>();
        for (TextureData data : textures) {
            Number mapto = (Number)data.mtex.getFieldValue("mapto");
            for (int i = 0; i < mappings.length; ++i) {
                if ((mappings[i] & mapto.intValue()) == 0) continue;
                ArrayList<TextureData> datas = (ArrayList<TextureData>)result.get(mappings[i]);
                if (datas == null) {
                    datas = new ArrayList<TextureData>();
                    result.put(mappings[i], datas);
                }
                datas.add(data);
            }
        }
        return result;
    }

    public void setFaceCullMode(RenderState.FaceCullMode faceCullMode) {
        this.faceCullMode = faceCullMode;
    }

    private ColorRGBA readDiffuseColor(Structure materialStructure, MaterialHelper.DiffuseShader diffuseShader) {
        int commonMapto = ((Number)materialStructure.getFieldValue("mapto")).intValue();
        float r = ((Number)materialStructure.getFieldValue("r")).floatValue();
        float g = ((Number)materialStructure.getFieldValue("g")).floatValue();
        float b = ((Number)materialStructure.getFieldValue("b")).floatValue();
        float alpha = ((Number)materialStructure.getFieldValue("alpha")).floatValue();
        if ((commonMapto & 1) == 1) {
            return new ColorRGBA(r, g, b, alpha);
        }
        switch (diffuseShader) {
            case FRESNEL: 
            case ORENNAYAR: 
            case TOON: {
                break;
            }
            case MINNAERT: 
            case LAMBERT: {
                float ref = ((Number)materialStructure.getFieldValue("ref")).floatValue();
                r *= ref;
                g *= ref;
                b *= ref;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown diffuse shader type: " + diffuseShader.toString());
            }
        }
        return new ColorRGBA(r, g, b, alpha);
    }

    private ColorRGBA readSpecularColor(Structure materialStructure, MaterialHelper.SpecularShader specularShader) {
        float r = ((Number)materialStructure.getFieldValue("specr")).floatValue();
        float g = ((Number)materialStructure.getFieldValue("specg")).floatValue();
        float b = ((Number)materialStructure.getFieldValue("specb")).floatValue();
        float alpha = ((Number)materialStructure.getFieldValue("alpha")).floatValue();
        switch (specularShader) {
            case BLINN: 
            case COOKTORRENCE: 
            case TOON: 
            case WARDISO: {
                break;
            }
            case PHONG: {
                float spec = ((Number)materialStructure.getFieldValue("spec")).floatValue();
                r *= spec * 0.5f;
                g *= spec * 0.5f;
                b *= spec * 0.5f;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown specular shader type: " + specularShader.toString());
            }
        }
        return new ColorRGBA(r, g, b, alpha);
    }

    private static class TextureData {
        Structure mtex;
        Structure textureStructure;
        int uvCoordinatesType;
        int projectionType;
        String uvCoordinatesName;

        private TextureData() {
        }
    }
}

