/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.meshes;

import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.plugins.blender.AbstractBlenderHelper;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.DynamicArray;
import com.jme3.scene.plugins.blender.file.Pointer;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.materials.MaterialContext;
import com.jme3.scene.plugins.blender.materials.MaterialHelper;
import com.jme3.scene.plugins.blender.meshes.MeshBuilder;
import com.jme3.scene.plugins.blender.meshes.MeshContext;
import com.jme3.scene.plugins.blender.objects.Properties;
import com.jme3.scene.plugins.blender.textures.TextureHelper;
import com.jme3.util.BufferUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MeshHelper
extends AbstractBlenderHelper {
    private static final Logger LOGGER = Logger.getLogger(MeshHelper.class.getName());
    private static final int UV_DATA_LAYER_TYPE_FMESH = 5;
    private static final int UV_DATA_LAYER_TYPE_BMESH = 16;

    public MeshHelper(String blenderVersion, BlenderContext blenderContext) {
        super(blenderVersion, blenderContext);
    }

    public List<Geometry> toMesh(Structure structure, BlenderContext blenderContext) throws BlenderFileException {
        ArrayList<Geometry> geometries = (ArrayList<Geometry>)blenderContext.getLoadedFeature(structure.getOldMemoryAddress(), BlenderContext.LoadedFeatureDataType.LOADED_FEATURE);
        if (geometries != null) {
            ArrayList<Geometry> copiedGeometries = new ArrayList<Geometry>(geometries.size());
            for (Geometry geometry : geometries) {
                copiedGeometries.add(geometry.clone());
            }
            return copiedGeometries;
        }
        String name = structure.getName();
        MeshContext meshContext = new MeshContext();
        MaterialHelper materialHelper = (MaterialHelper)blenderContext.getHelper(MaterialHelper.class);
        MaterialContext[] materials = null;
        if ((blenderContext.getBlenderKey().getFeaturesToLoad() & 3) != 0) {
            materials = materialHelper.getMaterials(structure, blenderContext);
        }
        Vector3f[][] verticesAndNormals = this.getVerticesAndNormals(structure, blenderContext);
        List<byte[]> verticesColors = this.getVerticesColors(structure, blenderContext);
        MeshBuilder meshBuilder = new MeshBuilder(verticesAndNormals, verticesColors, this.areGeneratedTexturesPresent(materials));
        if (this.isBMeshCompatible(structure)) {
            this.readBMesh(meshBuilder, structure, blenderContext);
        } else {
            this.readTraditionalFaces(meshBuilder, structure, blenderContext);
        }
        if (meshBuilder.isEmpty()) {
            geometries = new ArrayList<Geometry>(0);
            blenderContext.addLoadedFeatures(structure.getOldMemoryAddress(), structure.getName(), structure, geometries);
            blenderContext.setMeshContext(structure.getOldMemoryAddress(), meshContext);
            return geometries;
        }
        meshContext.setVertexReferenceMap(meshBuilder.getVertexReferenceMap());
        Structure parent = blenderContext.peekParent();
        Structure defbase = (Structure)parent.getFieldValue("defbase");
        List<Structure> defs = defbase.evaluateListBase(blenderContext);
        String[] verticesGroups = new String[defs.size()];
        int defIndex = 0;
        for (Structure def : defs) {
            verticesGroups[defIndex++] = def.getFieldValue("name").toString();
        }
        geometries = new ArrayList(meshBuilder.getMeshesPartAmount());
        Properties properties = this.loadProperties(structure, blenderContext);
        for (Map.Entry<Integer, List<Integer>> meshEntry : meshBuilder.getMeshesMap().entrySet()) {
            int i;
            Object[] indices;
            int materialIndex = meshEntry.getKey();
            Mesh mesh = new Mesh();
            List<Integer> list = meshEntry.getValue();
            if (meshBuilder.getVerticesAmount(materialIndex) <= Short.MAX_VALUE) {
                indices = new short[list.size()];
                for (i = 0; i < list.size(); ++i) {
                    indices[i] = list.get(i).shortValue();
                }
                mesh.setBuffer(VertexBuffer.Type.Index, 1, (short[])indices);
            } else {
                indices = new int[list.size()];
                for (i = 0; i < list.size(); ++i) {
                    indices[i] = list.get(i);
                }
                mesh.setBuffer(VertexBuffer.Type.Index, 1, (int[])indices);
            }
            VertexBuffer verticesBuffer = new VertexBuffer(VertexBuffer.Type.Position);
            verticesBuffer.setupData(VertexBuffer.Usage.Static, 3, VertexBuffer.Format.Float, BufferUtils.createFloatBuffer(meshBuilder.getVertices(materialIndex)));
            VertexBuffer verticesBind = new VertexBuffer(VertexBuffer.Type.BindPosePosition);
            verticesBind.setupData(VertexBuffer.Usage.CpuOnly, 3, VertexBuffer.Format.Float, BufferUtils.createFloatBuffer(meshBuilder.getVertices(materialIndex)));
            VertexBuffer normalsBuffer = new VertexBuffer(VertexBuffer.Type.Normal);
            normalsBuffer.setupData(VertexBuffer.Usage.Static, 3, VertexBuffer.Format.Float, BufferUtils.createFloatBuffer(meshBuilder.getNormals(materialIndex)));
            VertexBuffer normalsBind = new VertexBuffer(VertexBuffer.Type.BindPoseNormal);
            normalsBind.setupData(VertexBuffer.Usage.CpuOnly, 3, VertexBuffer.Format.Float, BufferUtils.createFloatBuffer(meshBuilder.getNormals(materialIndex)));
            mesh.setBuffer(verticesBuffer);
            meshContext.setBindPoseBuffer(materialIndex, verticesBind);
            if (verticesColors != null) {
                mesh.setBuffer(VertexBuffer.Type.Color, 4, meshBuilder.getVertexColorsBuffer(materialIndex));
                mesh.getBuffer(VertexBuffer.Type.Color).setNormalized(true);
            }
            mesh.setBuffer(normalsBuffer);
            meshContext.setBindNormalBuffer(materialIndex, normalsBind);
            Geometry geometry = new Geometry(name + (geometries.size() + 1), mesh);
            if (properties != null && properties.getValue() != null) {
                this.applyProperties(geometry, properties);
            }
            geometries.add(geometry);
            meshContext.putGeometry(materialIndex, geometry);
        }
        blenderContext.addLoadedFeatures(structure.getOldMemoryAddress(), structure.getName(), structure, geometries);
        blenderContext.setMeshContext(structure.getOldMemoryAddress(), meshContext);
        if (materials != null) {
            for (Geometry geometry : geometries) {
                int materialNumber = meshContext.getMaterialIndex(geometry);
                if (materials[materialNumber] != null) {
                    LinkedHashMap<String, List<Vector2f>> uvCoordinates = meshBuilder.getUVCoordinates(materialNumber);
                    MaterialContext materialContext = materials[materialNumber];
                    materialContext.applyMaterial(geometry, structure.getOldMemoryAddress(), uvCoordinates, blenderContext);
                    continue;
                }
                geometry.setMaterial(blenderContext.getDefaultMaterial());
                LOGGER.warning("The importer came accross mesh that points to a null material. Default material is used to prevent loader from crashing, but the model might look not the way it should. Sometimes blender does not assign materials properly. Enter the edit mode and assign materials once more to your faces.");
            }
        } else {
            LinkedHashMap<String, List<Vector2f>> uvs;
            ArrayList<VertexBuffer> uvCoordsBuffer = null;
            if (meshBuilder.hasUVCoordinates() && (uvs = meshBuilder.getUVCoordinates(0)) != null && uvs.size() > 0) {
                uvCoordsBuffer = new ArrayList<VertexBuffer>(uvs.size());
                int uvIndex = 0;
                for (Map.Entry entry : uvs.entrySet()) {
                    VertexBuffer buffer = new VertexBuffer(TextureHelper.TEXCOORD_TYPES[uvIndex++]);
                    buffer.setupData(VertexBuffer.Usage.Static, 2, VertexBuffer.Format.Float, BufferUtils.createFloatBuffer(((List)entry.getValue()).toArray(new Vector2f[uvs.size()])));
                    uvCoordsBuffer.add(buffer);
                }
            }
            for (Geometry geometry : geometries) {
                geometry.setMaterial(blenderContext.getDefaultMaterial());
                if (uvCoordsBuffer == null) continue;
                for (VertexBuffer vertexBuffer : uvCoordsBuffer) {
                    geometry.getMesh().setBuffer(vertexBuffer);
                }
            }
        }
        return geometries;
    }

    private boolean isBMeshCompatible(Structure meshStructure) {
        Pointer pMLoop = (Pointer)meshStructure.getFieldValue("mloop");
        Pointer pMPoly = (Pointer)meshStructure.getFieldValue("mpoly");
        return pMLoop != null && pMPoly != null && pMLoop.isNotNull() && pMPoly.isNotNull();
    }

    private Map<String, List<Vector2f>> loadUVCoordinates(Structure meshStructure, boolean useBMesh, BlenderContext blenderContext) throws BlenderFileException {
        HashMap<String, List<Vector2f>> result = new HashMap<String, List<Vector2f>>();
        if (useBMesh) {
            Structure loopData = (Structure)meshStructure.getFieldValue("ldata");
            Pointer pLoopDataLayers = (Pointer)loopData.getFieldValue("layers");
            List<Structure> loopDataLayers = pLoopDataLayers.fetchData(blenderContext.getInputStream());
            for (Structure structure : loopDataLayers) {
                Pointer p = (Pointer)structure.getFieldValue("data");
                if (!p.isNotNull() || ((Number)structure.getFieldValue("type")).intValue() != 16) continue;
                String uvSetName = structure.getFieldValue("name").toString();
                List<Structure> uvsStructures = p.fetchData(blenderContext.getInputStream());
                ArrayList<Vector2f> uvs = new ArrayList<Vector2f>(uvsStructures.size());
                for (Structure uvStructure : uvsStructures) {
                    DynamicArray loopUVS = (DynamicArray)uvStructure.getFieldValue("uv");
                    uvs.add(new Vector2f(((Number)loopUVS.get(0)).floatValue(), ((Number)loopUVS.get(1)).floatValue()));
                }
                result.put(uvSetName, uvs);
            }
        } else {
            Structure facesData = (Structure)meshStructure.getFieldValue("fdata");
            Pointer pFacesDataLayers = (Pointer)facesData.getFieldValue("layers");
            List<Structure> facesDataLayers = pFacesDataLayers.fetchData(blenderContext.getInputStream());
            for (Structure structure : facesDataLayers) {
                Pointer p = (Pointer)structure.getFieldValue("data");
                if (!p.isNotNull() || ((Number)structure.getFieldValue("type")).intValue() != 5) continue;
                String uvSetName = structure.getFieldValue("name").toString();
                List<Structure> uvsStructures = p.fetchData(blenderContext.getInputStream());
                ArrayList<Vector2f> uvs = new ArrayList<Vector2f>(uvsStructures.size());
                for (Structure uvStructure : uvsStructures) {
                    DynamicArray mFaceUVs = (DynamicArray)uvStructure.getFieldValue("uv");
                    uvs.add(new Vector2f(((Number)mFaceUVs.get(0)).floatValue(), ((Number)mFaceUVs.get(1)).floatValue()));
                    uvs.add(new Vector2f(((Number)mFaceUVs.get(2)).floatValue(), ((Number)mFaceUVs.get(3)).floatValue()));
                    uvs.add(new Vector2f(((Number)mFaceUVs.get(4)).floatValue(), ((Number)mFaceUVs.get(5)).floatValue()));
                    uvs.add(new Vector2f(((Number)mFaceUVs.get(6)).floatValue(), ((Number)mFaceUVs.get(7)).floatValue()));
                }
                result.put(uvSetName, uvs);
            }
        }
        return result;
    }

    private void readBMesh(MeshBuilder meshBuilder, Structure meshStructure, BlenderContext blenderContext) throws BlenderFileException {
        Pointer pMLoop = (Pointer)meshStructure.getFieldValue("mloop");
        Pointer pMPoly = (Pointer)meshStructure.getFieldValue("mpoly");
        Pointer pMEdge = (Pointer)meshStructure.getFieldValue("medge");
        HashMap<String, Vector2f[]> uvCoordinatesForFace = new HashMap<String, Vector2f[]>();
        if (pMPoly.isNotNull() && pMLoop.isNotNull() && pMEdge.isNotNull()) {
            Map<String, List<Vector2f>> uvs = this.loadUVCoordinates(meshStructure, true, blenderContext);
            int faceIndex = 0;
            List<Structure> polys = pMPoly.fetchData(blenderContext.getInputStream());
            List<Structure> loops = pMLoop.fetchData(blenderContext.getInputStream());
            for (Structure poly : polys) {
                int i;
                int materialNumber = ((Number)poly.getFieldValue("mat_nr")).intValue();
                int loopStart = ((Number)poly.getFieldValue("loopstart")).intValue();
                int totLoop = ((Number)poly.getFieldValue("totloop")).intValue();
                boolean smooth = (((Number)poly.getFieldValue("flag")).byteValue() & 1) != 0;
                int[] vertexIndexes = new int[totLoop];
                for (i = loopStart; i < loopStart + totLoop; ++i) {
                    vertexIndexes[i - loopStart] = ((Number)loops.get(i).getFieldValue("v")).intValue();
                }
                for (i = 0; i < totLoop - 2; ++i) {
                    int v1 = vertexIndexes[0];
                    int v2 = vertexIndexes[i + 1];
                    int v3 = vertexIndexes[i + 2];
                    if (uvs != null) {
                        for (Map.Entry<String, List<Vector2f>> entry : uvs.entrySet()) {
                            Vector2f[] uvCoordsForASingleFace = new Vector2f[]{entry.getValue().get(loopStart), entry.getValue().get(loopStart + i + 1), entry.getValue().get(loopStart + i + 2)};
                            uvCoordinatesForFace.put(entry.getKey(), uvCoordsForASingleFace);
                        }
                    }
                    meshBuilder.appendFace(v1, v2, v3, smooth, materialNumber, uvs == null ? null : uvCoordinatesForFace, false, faceIndex);
                    uvCoordinatesForFace.clear();
                }
                ++faceIndex;
            }
        }
    }

    private void readTraditionalFaces(MeshBuilder meshBuilder, Structure meshStructure, BlenderContext blenderContext) throws BlenderFileException {
        block7: {
            List<Structure> mEdges;
            block6: {
                List<Structure> mFaces;
                Pointer pMFace = (Pointer)meshStructure.getFieldValue("mface");
                List<Structure> list = mFaces = pMFace.isNotNull() ? pMFace.fetchData(blenderContext.getInputStream()) : null;
                if (mFaces == null || mFaces.size() <= 0) break block6;
                Map<String, List<Vector2f>> uvs = this.loadUVCoordinates(meshStructure, false, blenderContext);
                HashMap<String, Vector2f[]> uvCoordinatesForFace = new HashMap<String, Vector2f[]>();
                for (int i = 0; i < mFaces.size(); ++i) {
                    boolean smooth;
                    Structure mFace = mFaces.get(i);
                    int materialNumber = ((Number)mFace.getFieldValue("mat_nr")).intValue();
                    boolean bl = smooth = (((Number)mFace.getFieldValue("flag")).byteValue() & 1) != 0;
                    if (uvs != null) {
                        for (Map.Entry<String, List<Vector2f>> entry : uvs.entrySet()) {
                            Vector2f[] uvCoordsForASingleFace = new Vector2f[]{entry.getValue().get(i * 4), entry.getValue().get(i * 4 + 1), entry.getValue().get(i * 4 + 2)};
                            uvCoordinatesForFace.put(entry.getKey(), uvCoordsForASingleFace);
                        }
                    }
                    int v1 = ((Number)mFace.getFieldValue("v1")).intValue();
                    int v2 = ((Number)mFace.getFieldValue("v2")).intValue();
                    int v3 = ((Number)mFace.getFieldValue("v3")).intValue();
                    int v4 = ((Number)mFace.getFieldValue("v4")).intValue();
                    meshBuilder.appendFace(v1, v2, v3, smooth, materialNumber, uvs == null ? null : uvCoordinatesForFace, false, i);
                    uvCoordinatesForFace.clear();
                    if (v4 <= 0) continue;
                    if (uvs != null) {
                        for (Map.Entry<String, List<Vector2f>> entry : uvs.entrySet()) {
                            Vector2f[] uvCoordsForASingleFace = new Vector2f[]{entry.getValue().get(i * 4), entry.getValue().get(i * 4 + 2), entry.getValue().get(i * 4 + 3)};
                            uvCoordinatesForFace.put(entry.getKey(), uvCoordsForASingleFace);
                        }
                    }
                    meshBuilder.appendFace(v1, v3, v4, smooth, materialNumber, uvs == null ? null : uvCoordinatesForFace, true, i);
                    uvCoordinatesForFace.clear();
                }
                break block7;
            }
            Pointer pMEdge = (Pointer)meshStructure.getFieldValue("medge");
            List<Structure> list = mEdges = pMEdge.isNotNull() ? pMEdge.fetchData(blenderContext.getInputStream()) : null;
            if (mEdges == null || mEdges.size() <= 0) break block7;
            for (int i = 0; i < mEdges.size(); ++i) {
                Structure mEdge = mEdges.get(i);
                boolean smooth = (((Number)mEdge.getFieldValue("flag")).byteValue() & 1) != 0;
                int v1 = ((Number)mEdge.getFieldValue("v1")).intValue();
                int v2 = ((Number)mEdge.getFieldValue("v2")).intValue();
                meshBuilder.appendEdge(v1, v2, smooth);
            }
        }
    }

    private boolean areGeneratedTexturesPresent(MaterialContext[] materials) {
        if (materials != null) {
            for (MaterialContext material : materials) {
                if (material == null || !material.hasGeneratedTextures()) continue;
                return true;
            }
        }
        return false;
    }

    public List<byte[]> getVerticesColors(Structure meshStructure, BlenderContext blenderContext) throws BlenderFileException {
        Pointer pMCol = (Pointer)meshStructure.getFieldValue("mcol");
        ArrayList<byte[]> verticesColors = null;
        List<Structure> mCol = null;
        if (pMCol.isNotNull()) {
            verticesColors = new ArrayList<byte[]>();
            mCol = pMCol.fetchData(blenderContext.getInputStream());
            for (Structure color : mCol) {
                byte r = ((Number)color.getFieldValue("r")).byteValue();
                byte g = ((Number)color.getFieldValue("g")).byteValue();
                byte b = ((Number)color.getFieldValue("b")).byteValue();
                byte a = ((Number)color.getFieldValue("a")).byteValue();
                verticesColors.add(new byte[]{b, g, r, a});
            }
        }
        return verticesColors;
    }

    private Vector3f[][] getVerticesAndNormals(Structure meshStructure, BlenderContext blenderContext) throws BlenderFileException {
        int count = ((Number)meshStructure.getFieldValue("totvert")).intValue();
        Vector3f[][] result = new Vector3f[count][2];
        if (count == 0) {
            return result;
        }
        Pointer pMVert = (Pointer)meshStructure.getFieldValue("mvert");
        List<Structure> mVerts = pMVert.fetchData(blenderContext.getInputStream());
        if (this.fixUpAxis) {
            for (int i = 0; i < count; ++i) {
                DynamicArray coordinates = (DynamicArray)mVerts.get(i).getFieldValue("co");
                result[i][0] = new Vector3f(((Number)coordinates.get(0)).floatValue(), ((Number)coordinates.get(2)).floatValue(), -((Number)coordinates.get(1)).floatValue());
                DynamicArray normals = (DynamicArray)mVerts.get(i).getFieldValue("no");
                result[i][1] = new Vector3f((float)((Number)normals.get(0)).shortValue() / 32767.0f, (float)((Number)normals.get(2)).shortValue() / 32767.0f, (float)(-((Number)normals.get(1)).shortValue()) / 32767.0f);
            }
        } else {
            for (int i = 0; i < count; ++i) {
                DynamicArray coordinates = (DynamicArray)mVerts.get(i).getFieldValue("co");
                result[i][0] = new Vector3f(((Number)coordinates.get(0)).floatValue(), ((Number)coordinates.get(1)).floatValue(), ((Number)coordinates.get(2)).floatValue());
                DynamicArray normals = (DynamicArray)mVerts.get(i).getFieldValue("no");
                result[i][1] = new Vector3f((float)((Number)normals.get(0)).shortValue() / 32767.0f, (float)((Number)normals.get(1)).shortValue() / 32767.0f, (float)((Number)normals.get(2)).shortValue() / 32767.0f);
            }
        }
        return result;
    }

    @Override
    public boolean shouldBeLoaded(Structure structure, BlenderContext blenderContext) {
        return true;
    }
}

