/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.modifiers;

import com.jme3.bounding.BoundingBox;
import com.jme3.bounding.BoundingSphere;
import com.jme3.bounding.BoundingVolume;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.DynamicArray;
import com.jme3.scene.plugins.blender.file.FileBlockHeader;
import com.jme3.scene.plugins.blender.file.Pointer;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.modifiers.Modifier;
import com.jme3.scene.plugins.blender.objects.ObjectHelper;
import com.jme3.scene.shape.Curve;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

class ArrayModifier
extends Modifier {
    private static final Logger LOGGER = Logger.getLogger(ArrayModifier.class.getName());
    private Map<String, Object> modifierData = new HashMap<String, Object>();

    public ArrayModifier(Structure modifierStructure, BlenderContext blenderContext) throws BlenderFileException {
        if (this.validate(modifierStructure, blenderContext)) {
            Pointer pEndCap;
            Pointer pStartCap;
            Pointer pOffsetObject;
            Number fittype = (Number)modifierStructure.getFieldValue("fit_type");
            this.modifierData.put("fittype", fittype);
            switch (fittype.intValue()) {
                case 0: {
                    this.modifierData.put("count", modifierStructure.getFieldValue("count"));
                    break;
                }
                case 1: {
                    this.modifierData.put("length", modifierStructure.getFieldValue("length"));
                    break;
                }
                case 2: {
                    Pointer pCurveOb = (Pointer)modifierStructure.getFieldValue("curve_ob");
                    float length = 0.0f;
                    if (pCurveOb.isNotNull()) {
                        Structure curveStructure = pCurveOb.fetchData(blenderContext.getInputStream()).get(0);
                        ObjectHelper objectHelper = (ObjectHelper)blenderContext.getHelper(ObjectHelper.class);
                        Node curveObject = (Node)objectHelper.toObject(curveStructure, blenderContext);
                        HashSet<Number> referencesToCurveLengths = new HashSet<Number>(curveObject.getChildren().size());
                        for (Spatial spatial : curveObject.getChildren()) {
                            if (!(spatial instanceof Geometry)) continue;
                            Mesh mesh = ((Geometry)spatial).getMesh();
                            if (mesh instanceof Curve) {
                                length += ((Curve)mesh).getLength();
                                continue;
                            }
                            Number curveLength = (Number)spatial.getUserData("curveLength");
                            if (curveLength == null || referencesToCurveLengths.contains(curveLength)) continue;
                            length += curveLength.floatValue();
                            referencesToCurveLengths.add(curveLength);
                        }
                    }
                    this.modifierData.put("length", Float.valueOf(length));
                    this.modifierData.put("fittype", 1);
                    break;
                }
                default: {
                    assert (false) : "Unknown array modifier fit type: " + fittype;
                    break;
                }
            }
            int offsettype = ((Number)modifierStructure.getFieldValue("offset_type")).intValue();
            if ((offsettype & 1) != 0) {
                DynamicArray offsetArray = (DynamicArray)modifierStructure.getFieldValue("offset");
                float[] offset = new float[]{((Number)offsetArray.get(0)).floatValue(), ((Number)offsetArray.get(1)).floatValue(), ((Number)offsetArray.get(2)).floatValue()};
                this.modifierData.put("offset", offset);
            }
            if ((offsettype & 2) != 0) {
                DynamicArray scaleArray = (DynamicArray)modifierStructure.getFieldValue("scale");
                float[] scale = new float[]{((Number)scaleArray.get(0)).floatValue(), ((Number)scaleArray.get(1)).floatValue(), ((Number)scaleArray.get(2)).floatValue()};
                this.modifierData.put("scale", scale);
            }
            if ((offsettype & 4) != 0 && (pOffsetObject = (Pointer)modifierStructure.getFieldValue("offset_ob")).isNotNull()) {
                this.modifierData.put("offsetob", pOffsetObject);
            }
            if ((pStartCap = (Pointer)modifierStructure.getFieldValue("start_cap")).isNotNull()) {
                this.modifierData.put("startcap", pStartCap);
            }
            if ((pEndCap = (Pointer)modifierStructure.getFieldValue("end_cap")).isNotNull()) {
                this.modifierData.put("endcap", pEndCap);
            }
        }
    }

    public Node apply(Node node, BlenderContext blenderContext) {
        float[] scale;
        if (this.invalid) {
            LOGGER.log(Level.WARNING, "Array modifier is invalid! Cannot be applied to: {0}", node.getName());
            return node;
        }
        int fittype = ((Number)this.modifierData.get("fittype")).intValue();
        float[] offset = (float[])this.modifierData.get("offset");
        if (offset == null) {
            offset = new float[]{0.0f, 0.0f, 0.0f};
        }
        if ((scale = (float[])this.modifierData.get("scale")) == null) {
            scale = new float[]{0.0f, 0.0f, 0.0f};
        } else {
            node.updateModelBound();
            BoundingVolume boundingVolume = node.getWorldBound();
            if (boundingVolume instanceof BoundingBox) {
                scale[0] = scale[0] * (((BoundingBox)boundingVolume).getXExtent() * 2.0f);
                scale[1] = scale[1] * (((BoundingBox)boundingVolume).getYExtent() * 2.0f);
                scale[2] = scale[2] * (((BoundingBox)boundingVolume).getZExtent() * 2.0f);
            } else if (boundingVolume instanceof BoundingSphere) {
                float radius = ((BoundingSphere)boundingVolume).getRadius();
                scale[0] = scale[0] * (radius * 2.0f);
                scale[1] = scale[1] * (radius * 2.0f);
                scale[2] = scale[2] * (radius * 2.0f);
            } else {
                throw new IllegalStateException("Unknown bounding volume type: " + boundingVolume.getClass().getName());
            }
        }
        float[] objectOffset = new float[]{0.0f, 0.0f, 0.0f};
        Pointer pOffsetObject = (Pointer)this.modifierData.get("offsetob");
        if (pOffsetObject != null) {
            FileBlockHeader offsetObjectBlock = blenderContext.getFileBlock(pOffsetObject.getOldMemoryAddress());
            ObjectHelper objectHelper = (ObjectHelper)blenderContext.getHelper(ObjectHelper.class);
            try {
                Structure offsetStructure = offsetObjectBlock.getStructure(blenderContext);
                Vector3f translation = objectHelper.getTransformation(offsetStructure, blenderContext).getTranslation();
                objectOffset[0] = translation.x;
                objectOffset[1] = translation.y;
                objectOffset[2] = translation.z;
            }
            catch (BlenderFileException e) {
                LOGGER.log(Level.WARNING, "Problems in blender file structure! Object offset cannot be applied! The problem: {0}", e.getMessage());
            }
        }
        Node[] caps = new Node[]{null, null};
        Pointer[] pCaps = new Pointer[]{(Pointer)this.modifierData.get("startcap"), (Pointer)this.modifierData.get("endcap")};
        for (int i = 0; i < pCaps.length; ++i) {
            if (pCaps[i] == null) continue;
            caps[i] = (Node)blenderContext.getLoadedFeature(pCaps[i].getOldMemoryAddress(), BlenderContext.LoadedFeatureDataType.LOADED_FEATURE);
            if (caps[i] != null) {
                caps[i] = (Node)caps[i].clone();
                continue;
            }
            FileBlockHeader capBlock = blenderContext.getFileBlock(pOffsetObject.getOldMemoryAddress());
            try {
                Structure capStructure = capBlock.getStructure(blenderContext);
                ObjectHelper objectHelper = (ObjectHelper)blenderContext.getHelper(ObjectHelper.class);
                caps[i] = (Node)objectHelper.toObject(capStructure, blenderContext);
                if (caps[i] != null) continue;
                LOGGER.log(Level.WARNING, "Cap object ''{0}'' couldn''t be loaded!", capStructure.getName());
                continue;
            }
            catch (BlenderFileException e) {
                LOGGER.log(Level.WARNING, "Problems in blender file structure! Cap object cannot be applied! The problem: {0}", e.getMessage());
            }
        }
        Vector3f translationVector = new Vector3f(offset[0] + scale[0] + objectOffset[0], offset[1] + scale[1] + objectOffset[1], offset[2] + scale[2] + objectOffset[2]);
        if (blenderContext.getBlenderKey().isFixUpAxis()) {
            float y = translationVector.y;
            translationVector.y = translationVector.z;
            translationVector.z = y == 0.0f ? 0.0f : -y;
        }
        int count = 0;
        if (fittype == 0) {
            count = ((Number)this.modifierData.get("count")).intValue() - 1;
        } else if (fittype == 1) {
            float length = ((Number)this.modifierData.get("length")).floatValue();
            if (translationVector.length() > 0.0f) {
                count = (int)(length / translationVector.length()) - 1;
            }
        } else {
            if (fittype == 2) {
                throw new IllegalStateException("Fit curve should be transformed to Fixed Length array type!");
            }
            throw new IllegalStateException("Unknown fit type: " + fittype);
        }
        if (count > 0) {
            Node[] arrayNodes = new Node[count];
            Vector3f newTranslation = new Vector3f();
            for (int i = 0; i < count; ++i) {
                newTranslation.addLocal(translationVector);
                Node nodeClone = (Node)node.clone();
                nodeClone.setLocalTranslation(newTranslation);
                arrayNodes[i] = nodeClone;
            }
            for (Node nodeClone : arrayNodes) {
                node.attachChild(nodeClone);
            }
            if (caps[0] != null) {
                caps[0].getLocalTranslation().set(node.getLocalTranslation()).subtractLocal(translationVector);
                node.attachChild(caps[0]);
            }
            if (caps[1] != null) {
                caps[1].getLocalTranslation().set(newTranslation).addLocal(translationVector);
                node.attachChild(caps[1]);
            }
        }
        return node;
    }
}

