/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.textures;

import com.jme3.bounding.BoundingBox;
import com.jme3.math.FastMath;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.textures.GeneratedTexture;
import com.jme3.scene.plugins.blender.textures.ImageLoader;
import com.jme3.scene.plugins.blender.textures.TextureHelper;
import com.jme3.scene.plugins.blender.textures.TexturePixel;
import com.jme3.scene.plugins.blender.textures.blending.TextureBlender;
import com.jme3.scene.plugins.blender.textures.io.PixelIOFactory;
import com.jme3.scene.plugins.blender.textures.io.PixelInputOutput;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import com.jme3.util.BufferUtils;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import jme3tools.converters.ImageToAwt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TriangulatedTexture
extends Texture2D {
    private Image.Format format;
    private Collection<TriangleTextureElement> faceTextures;
    private int maxTextureSize;
    private boolean keepIdenticalTextures = false;
    private Texture2D resultTexture;
    private List<Vector2f> resultUVS;

    public TriangulatedTexture(Texture2D texture2d, List<Vector2f> uvs, BlenderContext blenderContext) {
        this.maxTextureSize = blenderContext.getBlenderKey().getMaxTextureSize();
        this.faceTextures = new TreeSet<TriangleTextureElement>(new Comparator<TriangleTextureElement>(){

            @Override
            public int compare(TriangleTextureElement o1, TriangleTextureElement o2) {
                return o1.faceIndex - o2.faceIndex;
            }
        });
        int facesCount = uvs.size() / 3;
        for (int i = 0; i < facesCount; ++i) {
            this.faceTextures.add(new TriangleTextureElement(i, texture2d.getImage(), uvs, true, blenderContext));
        }
        this.format = texture2d.getImage().getFormat();
    }

    public TriangulatedTexture(Collection<TriangleTextureElement> faceTextures, BlenderContext blenderContext) {
        this.maxTextureSize = blenderContext.getBlenderKey().getMaxTextureSize();
        this.faceTextures = faceTextures;
        for (TriangleTextureElement faceTextureElement : faceTextures) {
            if (this.format == null) {
                this.format = faceTextureElement.image.getFormat();
                continue;
            }
            if (this.format == faceTextureElement.image.getFormat()) continue;
            throw new IllegalArgumentException("Face texture element images MUST have the same image format!");
        }
    }

    public void blend(TextureBlender textureBlender, TriangulatedTexture baseTexture, BlenderContext blenderContext) {
        Image.Format newFormat = null;
        for (TriangleTextureElement triangleTextureElement : this.faceTextures) {
            Image baseImage = baseTexture == null ? null : baseTexture.getFaceTextureElement((int)triangleTextureElement.faceIndex).image;
            triangleTextureElement.image = textureBlender.blend(triangleTextureElement.image, baseImage, blenderContext);
            if (newFormat == null) {
                newFormat = triangleTextureElement.image.getFormat();
                continue;
            }
            if (newFormat == triangleTextureElement.image.getFormat()) continue;
            throw new IllegalArgumentException("Face texture element images MUST have the same image format!");
        }
        this.format = newFormat;
    }

    public void castToUVS(TriangulatedTexture targetTexture, BlenderContext blenderContext) {
        int[] sourceSize = new int[2];
        int[] targetSize = new int[2];
        ImageLoader imageLoader = new ImageLoader();
        TextureHelper textureHelper = (TextureHelper)blenderContext.getHelper(TextureHelper.class);
        for (TriangleTextureElement entry : this.faceTextures) {
            Image output;
            TriangleTextureElement targetFaceTextureElement = targetTexture.getFaceTextureElement(entry.faceIndex);
            Vector2f[] dest = targetFaceTextureElement.uv;
            sourceSize[0] = entry.image.getWidth();
            sourceSize[1] = entry.image.getHeight();
            targetSize[0] = targetFaceTextureElement.image.getWidth();
            targetSize[1] = targetFaceTextureElement.image.getHeight();
            AffineTransform affineTransform = textureHelper.createAffineTransform(entry.uv, dest, sourceSize, targetSize);
            BufferedImage sourceImage = ImageToAwt.convert(entry.image, false, true, 0);
            BufferedImage targetImage = new BufferedImage(targetSize[0], targetSize[1], sourceImage.getType());
            Graphics2D g = targetImage.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g.drawImage(sourceImage, affineTransform, null);
            g.dispose();
            entry.image = output = imageLoader.load(targetImage, false);
            entry.uv[0].set(dest[0]);
            entry.uv[1].set(dest[1]);
            entry.uv[2].set(dest[2]);
        }
    }

    public void merge(TriangulatedTexture triangulatedTexture) {
        TexturePixel sourcePixel = new TexturePixel();
        TexturePixel targetPixel = new TexturePixel();
        for (TriangleTextureElement triangleTextureElement : this.faceTextures) {
            Image sourceImage = triangulatedTexture.getFaceTextureElement((int)triangleTextureElement.faceIndex).image;
            Image targetImage = triangleTextureElement.image;
            PixelInputOutput sourceIO = PixelIOFactory.getPixelIO(sourceImage.getFormat());
            PixelInputOutput targetIO = PixelIOFactory.getPixelIO(targetImage.getFormat());
            for (int x = 0; x < sourceImage.getWidth(); ++x) {
                for (int y = 0; y < sourceImage.getHeight(); ++y) {
                    sourceIO.read(sourceImage, 0, sourcePixel, x, y);
                    targetIO.read(targetImage, 0, targetPixel, x, y);
                    targetPixel.merge(sourcePixel);
                    targetIO.write(targetImage, 0, targetPixel, x, y);
                }
            }
        }
    }

    public Texture2D getResultTexture(boolean rebuild) {
        if (this.resultTexture == null || rebuild) {
            ArrayList<TriangleTextureElement> list = new ArrayList<TriangleTextureElement>(this.faceTextures);
            Collections.sort(list, new Comparator<TriangleTextureElement>(){

                @Override
                public int compare(TriangleTextureElement o1, TriangleTextureElement o2) {
                    return o2.image.getHeight() - o1.image.getHeight();
                }
            });
            HashSet<Integer> duplicatedFaceIndexes = new HashSet<Integer>();
            int resultImageHeight = ((TriangleTextureElement)list.get((int)0)).image.getHeight();
            int resultImageWidth = 0;
            int currentXPos = 0;
            int currentYPos = 0;
            HashMap<TriangleTextureElement, Integer[]> imageLayoutData = new HashMap<TriangleTextureElement, Integer[]>(list.size());
            while (list.size() > 0) {
                TriangleTextureElement currentElement = (TriangleTextureElement)list.remove(0);
                if (currentXPos + currentElement.image.getWidth() > this.maxTextureSize) {
                    currentXPos = 0;
                    currentYPos = resultImageHeight;
                    resultImageHeight += currentElement.image.getHeight();
                }
                Integer[] currentPositions = new Integer[]{currentXPos, currentYPos};
                imageLayoutData.put(currentElement, currentPositions);
                if (this.keepIdenticalTextures) {
                    for (int i = 0; i < list.size(); ++i) {
                        if (!currentElement.image.equals(((TriangleTextureElement)list.get((int)i)).image)) continue;
                        duplicatedFaceIndexes.add(((TriangleTextureElement)list.get((int)i)).faceIndex);
                        imageLayoutData.put((TriangleTextureElement)list.remove(i--), currentPositions);
                    }
                }
                resultImageWidth = Math.max(resultImageWidth, currentXPos += currentElement.image.getWidth());
            }
            this.resultUVS = new ArrayList<Vector2f>(imageLayoutData.size() * 3);
            for (int i = 0; i < imageLayoutData.size() * 3; ++i) {
                this.resultUVS.add(null);
            }
            Vector2f[] uvs = new Vector2f[3];
            for (Map.Entry entry : imageLayoutData.entrySet()) {
                Integer[] position = (Integer[])entry.getValue();
                ((TriangleTextureElement)entry.getKey()).computeFinalUVCoordinates(resultImageWidth, resultImageHeight, position[0], position[1], uvs);
                this.resultUVS.set(((TriangleTextureElement)entry.getKey()).faceIndex * 3, uvs[0]);
                this.resultUVS.set(((TriangleTextureElement)entry.getKey()).faceIndex * 3 + 1, uvs[1]);
                this.resultUVS.set(((TriangleTextureElement)entry.getKey()).faceIndex * 3 + 2, uvs[2]);
            }
            Image resultImage = new Image(this.format, resultImageWidth, resultImageHeight, BufferUtils.createByteBuffer(resultImageWidth * resultImageHeight * (this.format.getBitsPerPixel() >> 3)));
            this.resultTexture = new Texture2D(resultImage);
            for (Map.Entry entry : imageLayoutData.entrySet()) {
                if (duplicatedFaceIndexes.contains(((TriangleTextureElement)entry.getKey()).faceIndex)) continue;
                this.draw(resultImage, ((TriangleTextureElement)entry.getKey()).image, ((Integer[])entry.getValue())[0], ((Integer[])entry.getValue())[1]);
            }
            this.resultTexture.setWrap(Texture.WrapAxis.S, this.getWrap(Texture.WrapAxis.S));
            this.resultTexture.setWrap(Texture.WrapAxis.T, this.getWrap(Texture.WrapAxis.T));
            this.resultTexture.setMagFilter(this.getMagFilter());
            this.resultTexture.setMinFilter(this.getMinFilter());
        }
        return this.resultTexture;
    }

    public Texture2D getResultTexture() {
        return this.getResultTexture(false);
    }

    public List<Vector2f> getResultUVS() {
        this.getResultTexture();
        return this.resultUVS;
    }

    public TriangleTextureElement getFaceTextureElement(int faceIndex) {
        for (TriangleTextureElement textureElement : this.faceTextures) {
            if (textureElement.faceIndex != faceIndex) continue;
            return textureElement;
        }
        throw new IllegalStateException("No face texture element found for index: " + faceIndex);
    }

    public int getFaceTextureCount() {
        return this.faceTextures.size();
    }

    public void setKeepIdenticalTextures(boolean keepIdenticalTextures) {
        this.keepIdenticalTextures = keepIdenticalTextures;
    }

    private void draw(Image target, Image source, int targetXPos, int targetYPos) {
        PixelInputOutput sourceIO = PixelIOFactory.getPixelIO(source.getFormat());
        PixelInputOutput targetIO = PixelIOFactory.getPixelIO(target.getFormat());
        TexturePixel pixel = new TexturePixel();
        for (int x = 0; x < source.getWidth(); ++x) {
            for (int y = 0; y < source.getHeight(); ++y) {
                sourceIO.read(source, 0, pixel, x, y);
                targetIO.write(target, 0, pixel, targetXPos + x, targetYPos + y);
            }
        }
    }

    @Override
    public Texture createSimpleClone() {
        return null;
    }

    private static class RectangleEnvelope {
        public final Vector3f min;
        public final Vector3f w;
        public final Vector3f h;
        public final float width;
        public final float height;

        public RectangleEnvelope(Vector3f pointPosition) {
            this.min = pointPosition;
            this.h = this.w = Vector3f.ZERO;
            this.height = 1.0f;
            this.width = 1.0f;
        }

        public RectangleEnvelope(Vector3f min, Vector3f w, Vector3f h) {
            this.min = min;
            this.h = h;
            this.w = w;
            this.width = w.length();
            this.height = h.length();
        }

        public String toString() {
            return "Envelope[min = " + this.min + ", w = " + this.w + ", h = " + this.h + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TriangleTextureElement {
        public Image image;
        public final Vector2f[] uv;
        public final int faceIndex;

        public TriangleTextureElement(int faceIndex, Image sourceImage, List<Vector2f> uvCoordinates, boolean wholeUVList, BlenderContext blenderContext) {
            Vector2f[] vector2fArray;
            TextureHelper textureHelper = (TextureHelper)blenderContext.getHelper(TextureHelper.class);
            this.faceIndex = faceIndex;
            if (wholeUVList) {
                Vector2f[] vector2fArray2 = new Vector2f[3];
                vector2fArray2[0] = uvCoordinates.get(faceIndex * 3).clone();
                vector2fArray2[1] = uvCoordinates.get(faceIndex * 3 + 1).clone();
                vector2fArray = vector2fArray2;
                vector2fArray2[2] = uvCoordinates.get(faceIndex * 3 + 2).clone();
            } else {
                Vector2f[] vector2fArray3 = new Vector2f[3];
                vector2fArray3[0] = uvCoordinates.get(0).clone();
                vector2fArray3[1] = uvCoordinates.get(1).clone();
                vector2fArray = vector2fArray3;
                vector2fArray3[2] = uvCoordinates.get(2).clone();
            }
            this.uv = vector2fArray;
            int[][] texturePosition = new int[3][2];
            for (int i = 0; i < texturePosition.length; ++i) {
                texturePosition[i][0] = textureHelper.getPixelPosition(this.uv[i].x, sourceImage.getWidth());
                texturePosition[i][1] = textureHelper.getPixelPosition(this.uv[i].y, sourceImage.getHeight());
            }
            int minX = Integer.MAX_VALUE;
            int minY = Integer.MAX_VALUE;
            int maxX = Integer.MIN_VALUE;
            int maxY = Integer.MIN_VALUE;
            float minUVX = Float.MAX_VALUE;
            float minUVY = Float.MAX_VALUE;
            float maxUVX = Float.MIN_VALUE;
            float maxUVY = Float.MIN_VALUE;
            for (int i = 0; i < texturePosition.length; ++i) {
                minX = Math.min(texturePosition[i][0], minX);
                minY = Math.min(texturePosition[i][1], minY);
                maxX = Math.max(texturePosition[i][0], maxX);
                maxY = Math.max(texturePosition[i][1], maxY);
                minUVX = Math.min(this.uv[i].x, minUVX);
                minUVY = Math.min(this.uv[i].y, minUVY);
                maxUVX = Math.max(this.uv[i].x, maxUVX);
                maxUVY = Math.max(this.uv[i].y, maxUVY);
            }
            int width = maxX - minX;
            int height = maxY - minY;
            if (width == 0) {
                width = 1;
            }
            if (height == 0) {
                height = 1;
            }
            PixelInputOutput pixelReader = PixelIOFactory.getPixelIO(sourceImage.getFormat());
            TexturePixel pixel = new TexturePixel();
            ByteBuffer data = BufferUtils.createByteBuffer(width * height * 4);
            for (int y = minY; y < maxY; ++y) {
                for (int x = minX; x < maxX; ++x) {
                    int xPos = x >= sourceImage.getWidth() ? x - sourceImage.getWidth() : x;
                    int yPos = y >= sourceImage.getHeight() ? y - sourceImage.getHeight() : y;
                    pixelReader.read(sourceImage, 0, pixel, xPos, yPos);
                    data.put(pixel.getR8());
                    data.put(pixel.getG8());
                    data.put(pixel.getB8());
                    data.put(pixel.getA8());
                }
            }
            this.image = new Image(Image.Format.RGBA8, width, height, data);
            float heightUV = maxUVY - minUVY;
            float widthUV = maxUVX - minUVX;
            for (int i = 0; i < this.uv.length; ++i) {
                this.uv[i].x -= minUVX;
                this.uv[i].y -= minUVY;
                this.uv[i].x /= widthUV;
                this.uv[i].y /= heightUV;
            }
        }

        public TriangleTextureElement(int faceIndex, BoundingBox boundingBox, GeneratedTexture texture, Vector3f[] uv, int[] uvIndices, BlenderContext blenderContext) {
            int imageHeight;
            this.faceIndex = faceIndex;
            float width = boundingBox.getXExtent() * 2.0f;
            float height = boundingBox.getYExtent() * 2.0f;
            float depth = boundingBox.getZExtent() * 2.0f;
            Vector3f min = boundingBox.getMin(null);
            Vector3f v1 = min.add(uv[uvIndices[0]].x * width, uv[uvIndices[0]].y * height, uv[uvIndices[0]].z * depth);
            Vector3f v2 = min.add(uv[uvIndices[1]].x * width, uv[uvIndices[1]].y * height, uv[uvIndices[1]].z * depth);
            Vector3f v3 = min.add(uv[uvIndices[2]].x * width, uv[uvIndices[2]].y * height, uv[uvIndices[2]].z * depth);
            RectangleEnvelope envelope = this.getTriangleEnvelope(v1, v2, v3);
            Image.Format imageFormat = texture.getImage().getFormat();
            int imageWidth = (int)(envelope.width * (float)blenderContext.getBlenderKey().getGeneratedTexturePPU());
            if (imageWidth == 0) {
                imageWidth = 1;
            }
            if ((imageHeight = (int)(envelope.height * (float)blenderContext.getBlenderKey().getGeneratedTexturePPU())) == 0) {
                imageHeight = 1;
            }
            ByteBuffer data = BufferUtils.createByteBuffer(imageWidth * imageHeight * (imageFormat.getBitsPerPixel() >> 3));
            this.image = new Image(texture.getImage().getFormat(), imageWidth, imageHeight, data);
            PixelInputOutput pixelWriter = PixelIOFactory.getPixelIO(imageFormat);
            TexturePixel pixel = new TexturePixel();
            float[] uvs = new float[3];
            Vector3f point = new Vector3f(envelope.min);
            Vector3f vecY = new Vector3f();
            Vector3f wDelta = new Vector3f(envelope.w).multLocal(1.0f / (float)imageWidth);
            Vector3f hDelta = new Vector3f(envelope.h).multLocal(1.0f / (float)imageHeight);
            for (int x = 0; x < imageWidth; ++x) {
                for (int y = 0; y < imageHeight; ++y) {
                    this.toTextureUV(boundingBox, point, uvs);
                    texture.getPixel(pixel, uvs[0], uvs[1], uvs[2]);
                    pixelWriter.write(this.image, 0, pixel, x, y);
                    point.addLocal(hDelta);
                }
                vecY.addLocal(wDelta);
                point.set(envelope.min).addLocal(vecY);
            }
            this.uv = new Vector2f[3];
            this.uv[0] = new Vector2f(FastMath.clamp(v1.subtract(envelope.min).length(), 0.0f, Float.MAX_VALUE) / envelope.height, 0.0f);
            Vector3f heightDropPoint = v2.subtract(envelope.w);
            this.uv[1] = new Vector2f(1.0f, heightDropPoint.subtractLocal(envelope.min).length() / envelope.height);
            this.uv[2] = new Vector2f(0.0f, 1.0f);
        }

        public void computeFinalUVCoordinates(int totalImageWidth, int totalImageHeight, int xPos, int yPos, Vector2f[] result) {
            for (int i = 0; i < 3; ++i) {
                result[i] = new Vector2f();
                result[i].x = (float)xPos / (float)totalImageWidth + this.uv[i].x * ((float)this.image.getWidth() / (float)totalImageWidth);
                result[i].y = (float)yPos / (float)totalImageHeight + this.uv[i].y * ((float)this.image.getHeight() / (float)totalImageHeight);
            }
        }

        private void toTextureUV(BoundingBox boundingBox, Vector3f point, float[] uvs) {
            uvs[0] = (point.x - boundingBox.getCenter().x) / (boundingBox.getXExtent() == 0.0f ? 1.0f : boundingBox.getXExtent());
            uvs[1] = (point.y - boundingBox.getCenter().y) / (boundingBox.getYExtent() == 0.0f ? 1.0f : boundingBox.getYExtent());
            uvs[2] = (point.z - boundingBox.getCenter().z) / (boundingBox.getZExtent() == 0.0f ? 1.0f : boundingBox.getZExtent());
            for (int i = 0; i < 3; ++i) {
                uvs[i] = FastMath.clamp(uvs[i], 0.0f, 1.0f);
            }
        }

        private RectangleEnvelope getTriangleEnvelope(Vector3f v1, Vector3f v2, Vector3f v3) {
            Vector3f min;
            Vector3f temp;
            Vector3f h = v3.subtract(v1);
            float field = 0.5f * h.cross(temp = v2.subtract(v1)).length();
            if (field <= 0.0f) {
                return new RectangleEnvelope(v1);
            }
            float cosAlpha = h.dot(temp) / (h.length() * temp.length());
            float triangleHeight = 2.0f * field / h.length();
            float x = Math.abs((float)Math.sqrt(FastMath.clamp(temp.lengthSquared() - triangleHeight * triangleHeight, 0.0f, Float.MAX_VALUE))) * Math.signum(cosAlpha);
            Vector3f xPoint = v1.add(h.normalize().multLocal(x));
            Vector3f vector3f = min = x < 0.0f ? xPoint : v1;
            if (x < 0.0f) {
                h = v3.subtract(min);
            } else if (x > h.length()) {
                h = xPoint.subtract(min);
            }
            Vector3f envelopeWidth = v2.subtract(xPoint);
            return new RectangleEnvelope(min, envelopeWidth, h);
        }
    }
}

