/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.textures.generating;

import com.jme3.math.FastMath;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.textures.TexturePixel;
import com.jme3.scene.plugins.blender.textures.generating.NoiseGenerator;
import com.jme3.scene.plugins.blender.textures.generating.TextureGenerator;
import com.jme3.texture.Image;

public class TextureGeneratorMagic
extends TextureGenerator {
    private static NoiseDepthFunction[] noiseDepthFunctions = new NoiseDepthFunction[10];
    protected int noisedepth;
    protected float turbul;
    protected float[] xyz = new float[3];

    public TextureGeneratorMagic(NoiseGenerator noiseGenerator) {
        super(noiseGenerator, Image.Format.RGBA8);
    }

    public void readData(Structure tex, BlenderContext blenderContext) {
        super.readData(tex, blenderContext);
        this.noisedepth = ((Number)tex.getFieldValue("noisedepth")).intValue();
        this.turbul = ((Number)tex.getFieldValue("turbul")).floatValue() / 5.0f;
    }

    public void getPixel(TexturePixel pixel, float x, float y, float z) {
        float turb = this.turbul;
        this.xyz[0] = (float)Math.sin((x + y + z) * 5.0f);
        this.xyz[1] = (float)Math.cos((-x + y - z) * 5.0f);
        this.xyz[2] = -((float)Math.cos((-x - y + z) * 5.0f));
        if (this.colorBand != null) {
            pixel.intensity = FastMath.clamp(0.3333f * (this.xyz[0] + this.xyz[1] + this.xyz[2]), 0.0f, 1.0f);
            int colorbandIndex = (int)(pixel.intensity * 1000.0f);
            pixel.red = this.colorBand[colorbandIndex][0];
            pixel.green = this.colorBand[colorbandIndex][1];
            pixel.blue = this.colorBand[colorbandIndex][2];
            pixel.alpha = this.colorBand[colorbandIndex][3];
        } else {
            if (this.noisedepth > 0) {
                this.xyz[0] = this.xyz[0] * turb;
                this.xyz[1] = this.xyz[1] * turb;
                this.xyz[2] = this.xyz[2] * turb;
                for (int m = 0; m < this.noisedepth; ++m) {
                    noiseDepthFunctions[m].compute(this.xyz, turb);
                }
            }
            if (turb != 0.0f) {
                this.xyz[0] = this.xyz[0] / (turb *= 2.0f);
                this.xyz[1] = this.xyz[1] / turb;
                this.xyz[2] = this.xyz[2] / turb;
            }
            pixel.red = 0.5f - this.xyz[0];
            pixel.green = 0.5f - this.xyz[1];
            pixel.blue = 0.5f - this.xyz[2];
            pixel.alpha = 1.0f;
        }
        this.applyBrightnessAndContrast(this.bacd, pixel);
    }

    static {
        TextureGeneratorMagic.noiseDepthFunctions[0] = new NoiseDepthFunction(){

            public void compute(float[] xyz, float turbulence) {
                xyz[1] = -((float)Math.cos(xyz[0] - xyz[1] + xyz[2])) * turbulence;
            }
        };
        TextureGeneratorMagic.noiseDepthFunctions[1] = new NoiseDepthFunction(){

            public void compute(float[] xyz, float turbulence) {
                xyz[0] = (float)Math.cos(xyz[0] - xyz[1] - xyz[2]) * turbulence;
            }
        };
        TextureGeneratorMagic.noiseDepthFunctions[2] = new NoiseDepthFunction(){

            public void compute(float[] xyz, float turbulence) {
                xyz[2] = (float)Math.sin(-xyz[0] - xyz[1] - xyz[2]) * turbulence;
            }
        };
        TextureGeneratorMagic.noiseDepthFunctions[3] = new NoiseDepthFunction(){

            public void compute(float[] xyz, float turbulence) {
                xyz[0] = -((float)Math.cos(-xyz[0] + xyz[1] - xyz[2])) * turbulence;
            }
        };
        TextureGeneratorMagic.noiseDepthFunctions[4] = new NoiseDepthFunction(){

            public void compute(float[] xyz, float turbulence) {
                xyz[1] = -((float)Math.sin(-xyz[0] + xyz[1] + xyz[2])) * turbulence;
            }
        };
        TextureGeneratorMagic.noiseDepthFunctions[5] = new NoiseDepthFunction(){

            public void compute(float[] xyz, float turbulence) {
                xyz[1] = -((float)Math.cos(-xyz[0] + xyz[1] + xyz[2])) * turbulence;
            }
        };
        TextureGeneratorMagic.noiseDepthFunctions[6] = new NoiseDepthFunction(){

            public void compute(float[] xyz, float turbulence) {
                xyz[0] = (float)Math.cos(xyz[0] + xyz[1] + xyz[2]) * turbulence;
            }
        };
        TextureGeneratorMagic.noiseDepthFunctions[7] = new NoiseDepthFunction(){

            public void compute(float[] xyz, float turbulence) {
                xyz[2] = (float)Math.sin(xyz[0] + xyz[1] - xyz[2]) * turbulence;
            }
        };
        TextureGeneratorMagic.noiseDepthFunctions[8] = new NoiseDepthFunction(){

            public void compute(float[] xyz, float turbulence) {
                xyz[0] = -((float)Math.cos(-xyz[0] - xyz[1] + xyz[2])) * turbulence;
            }
        };
        TextureGeneratorMagic.noiseDepthFunctions[9] = new NoiseDepthFunction(){

            public void compute(float[] xyz, float turbulence) {
                xyz[1] = -((float)Math.sin(xyz[0] - xyz[1] + xyz[2])) * turbulence;
            }
        };
    }

    private static interface NoiseDepthFunction {
        public void compute(float[] var1, float var2);
    }
}

