/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.textures.generating;

import com.jme3.math.FastMath;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.textures.TexturePixel;
import com.jme3.scene.plugins.blender.textures.generating.NoiseGenerator;
import com.jme3.scene.plugins.blender.textures.generating.TextureGenerator;
import com.jme3.texture.Image;

public class TextureGeneratorVoronoi
extends TextureGenerator {
    protected float noisesize;
    protected float outscale;
    protected float mexp;
    protected int distanceType;
    protected int voronoiColorType;
    protected float[] da = new float[4];
    protected float[] pa = new float[12];
    protected float[] hashPoint;
    protected float[] voronoiWeights;
    protected float weightSum;

    public TextureGeneratorVoronoi(NoiseGenerator noiseGenerator) {
        super(noiseGenerator, Image.Format.Luminance8);
    }

    public void readData(Structure tex, BlenderContext blenderContext) {
        super.readData(tex, blenderContext);
        this.voronoiWeights = new float[4];
        this.voronoiWeights[0] = ((Number)tex.getFieldValue("vn_w1")).floatValue();
        this.voronoiWeights[1] = ((Number)tex.getFieldValue("vn_w2")).floatValue();
        this.voronoiWeights[2] = ((Number)tex.getFieldValue("vn_w3")).floatValue();
        this.voronoiWeights[3] = ((Number)tex.getFieldValue("vn_w4")).floatValue();
        this.noisesize = ((Number)tex.getFieldValue("noisesize")).floatValue();
        this.outscale = ((Number)tex.getFieldValue("ns_outscale")).floatValue();
        this.mexp = ((Number)tex.getFieldValue("vn_mexp")).floatValue();
        this.distanceType = ((Number)tex.getFieldValue("vn_distm")).intValue();
        this.voronoiColorType = ((Number)tex.getFieldValue("vn_coltype")).intValue();
        this.hashPoint = this.voronoiColorType != 0 ? new float[3] : null;
        this.weightSum = this.voronoiWeights[0] + this.voronoiWeights[1] + this.voronoiWeights[2] + this.voronoiWeights[3];
        if (this.weightSum != 0.0f) {
            this.weightSum = this.outscale / this.weightSum;
        }
        if (this.voronoiColorType != 0 || this.colorBand != null) {
            this.imageFormat = Image.Format.RGBA8;
        }
    }

    public void getPixel(TexturePixel pixel, float x, float y, float z) {
        NoiseGenerator.NoiseFunctions.voronoi(x * 4.0f, y * 4.0f, z * 4.0f, this.da, this.pa, this.mexp, this.distanceType);
        pixel.intensity = this.weightSum * FastMath.abs(this.voronoiWeights[0] * this.da[0] + this.voronoiWeights[1] * this.da[1] + this.voronoiWeights[2] * this.da[2] + this.voronoiWeights[3] * this.da[3]);
        if (pixel.intensity > 1.0f) {
            pixel.intensity = 1.0f;
        } else if (pixel.intensity < 0.0f) {
            pixel.intensity = 0.0f;
        }
        if (this.colorBand != null) {
            int colorbandIndex = (int)(pixel.intensity * 1000.0f);
            pixel.red = this.colorBand[colorbandIndex][0];
            pixel.green = this.colorBand[colorbandIndex][1];
            pixel.blue = this.colorBand[colorbandIndex][2];
            pixel.alpha = this.colorBand[colorbandIndex][3];
        } else if (this.voronoiColorType != 0) {
            pixel.blue = 0.0f;
            pixel.green = 0.0f;
            pixel.red = 0.0f;
            pixel.alpha = 1.0f;
            for (int m = 0; m < 12; m += 3) {
                float weight = this.voronoiWeights[m / 3];
                NoiseGenerator.NoiseMath.hash((int)this.pa[m], (int)this.pa[m + 1], (int)this.pa[m + 2], this.hashPoint);
                pixel.red += weight * this.hashPoint[0];
                pixel.green += weight * this.hashPoint[1];
                pixel.blue += weight * this.hashPoint[2];
            }
            if (this.voronoiColorType >= 2) {
                float t1 = (this.da[1] - this.da[0]) * 10.0f;
                if (t1 > 1.0f) {
                    t1 = 1.0f;
                }
                t1 = this.voronoiColorType == 3 ? (t1 *= pixel.intensity) : (t1 *= this.weightSum);
                pixel.red *= t1;
                pixel.green *= t1;
                pixel.blue *= t1;
            } else {
                pixel.red *= this.weightSum;
                pixel.green *= this.weightSum;
                pixel.blue *= this.weightSum;
            }
        }
        if (this.voronoiColorType != 0 || this.colorBand != null) {
            this.applyBrightnessAndContrast(this.bacd, pixel);
        } else {
            this.applyBrightnessAndContrast(pixel, this.bacd.contrast, this.bacd.brightness);
        }
    }
}

