/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.shader;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.shader.Shader;
import com.jme3.shader.ShaderNodeVariable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShaderNodeDefinition
implements Savable {
    private String name;
    private Shader.ShaderType type;
    private List<String> shadersLanguage = new ArrayList<String>();
    private List<String> shadersPath = new ArrayList<String>();
    private String documentation;
    private List<ShaderNodeVariable> inputs = new ArrayList<ShaderNodeVariable>();
    private List<ShaderNodeVariable> outputs = new ArrayList<ShaderNodeVariable>();
    private String path = null;

    public ShaderNodeDefinition(String name, Shader.ShaderType type, String shaderPath, String shaderLanguage) {
        this.name = name;
        this.type = type;
        this.shadersLanguage.add(shaderLanguage);
        this.shadersPath.add(shaderPath);
    }

    public ShaderNodeDefinition() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Shader.ShaderType getType() {
        return this.type;
    }

    public void setType(Shader.ShaderType type) {
        this.type = type;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }

    public List<ShaderNodeVariable> getInputs() {
        return this.inputs;
    }

    public void setInputs(List<ShaderNodeVariable> inputs) {
        this.inputs = inputs;
    }

    public List<ShaderNodeVariable> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(List<ShaderNodeVariable> outputs) {
        this.outputs = outputs;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.name, "name", "");
        String[] str = new String[this.shadersLanguage.size()];
        oc.write(this.shadersLanguage.toArray(str), "shadersLanguage", null);
        oc.write(this.shadersPath.toArray(str), "shadersPath", null);
        oc.write(this.type, "type", null);
        oc.writeSavableArrayList((ArrayList)this.inputs, "inputs", new ArrayList());
        oc.writeSavableArrayList((ArrayList)this.outputs, "inputs", new ArrayList());
    }

    public List<String> getShadersLanguage() {
        return this.shadersLanguage;
    }

    public List<String> getShadersPath() {
        return this.shadersPath;
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        InputCapsule ic = im.getCapsule(this);
        this.name = ic.readString("name", "");
        String[] str = ic.readStringArray("shadersLanguage", null);
        this.shadersLanguage = str != null ? Arrays.asList(str) : new ArrayList<String>();
        str = ic.readStringArray("shadersPath", null);
        this.shadersPath = str != null ? Arrays.asList(str) : new ArrayList<String>();
        this.type = ic.readEnum("type", Shader.ShaderType.class, null);
        this.inputs = ic.readSavableArrayList("inputs", new ArrayList());
        this.outputs = ic.readSavableArrayList("outputs", new ArrayList());
    }

    public String toString() {
        return "\nShaderNodeDefinition{\nname=" + this.name + "\ntype=" + (Object)((Object)this.type) + "\nshaderPath=" + this.shadersPath + "\nshaderLanguage=" + this.shadersLanguage + "\ndocumentation=" + this.documentation + "\ninputs=" + this.inputs + ",\noutputs=" + this.outputs + '}';
    }
}

