/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.shader.plugins;

import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetKey;
import com.jme3.asset.AssetLoadException;
import com.jme3.asset.AssetLoader;
import com.jme3.asset.AssetManager;
import com.jme3.asset.cache.AssetCache;
import com.jme3.shader.plugins.ShaderDependencyNode;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GLSLLoader
implements AssetLoader {
    private AssetManager assetManager;
    private Map<String, ShaderDependencyNode> dependCache = new HashMap<String, ShaderDependencyNode>();

    private ShaderDependencyNode loadNode(Reader reader, String nodeName) {
        ShaderDependencyNode node = new ShaderDependencyNode(nodeName);
        StringBuilder sb = new StringBuilder();
        BufferedReader bufReader = new BufferedReader(reader);
        try {
            String ln;
            while ((ln = bufReader.readLine()) != null) {
                if (ln.trim().startsWith("#import ")) {
                    if (!(ln = ln.trim().substring(8).trim()).startsWith("\"") || !ln.endsWith("\"") || ln.length() <= 3) continue;
                    if ((ln = ln.substring(1, ln.length() - 1)).equals(nodeName)) {
                        throw new IOException("Node depends on itself.");
                    }
                    ShaderDependencyNode dependNode = this.dependCache.get(ln);
                    if (dependNode == null) {
                        Reader dependNodeReader = this.assetManager.loadAsset(new ShaderDependencyKey(ln));
                        dependNode = this.loadNode(dependNodeReader, ln);
                    }
                    node.addDependency(sb.length(), dependNode);
                    continue;
                }
                sb.append(ln).append('\n');
            }
        }
        catch (IOException ex) {
            if (bufReader != null) {
                try {
                    bufReader.close();
                }
                catch (IOException ex1) {
                    // empty catch block
                }
            }
            throw new AssetLoadException("Failed to load shader node: " + nodeName, ex);
        }
        node.setSource(sb.toString());
        this.dependCache.put(nodeName, node);
        return node;
    }

    private ShaderDependencyNode nextIndependentNode() throws IOException {
        Collection<ShaderDependencyNode> allNodes = this.dependCache.values();
        if (allNodes == null || allNodes.isEmpty()) {
            return null;
        }
        for (ShaderDependencyNode node : allNodes) {
            if (!node.getDependOnMe().isEmpty()) continue;
            return node;
        }
        for (ShaderDependencyNode node : allNodes) {
            System.out.println(node.getName());
        }
        throw new IOException("Circular dependency.");
    }

    private String resolveDependencies(ShaderDependencyNode node, Set<ShaderDependencyNode> alreadyInjectedSet) {
        if (alreadyInjectedSet.contains(node)) {
            return "// " + node.getName() + " was already injected at the top.\n";
        }
        alreadyInjectedSet.add(node);
        if (node.getDependencies().isEmpty()) {
            return node.getSource();
        }
        StringBuilder sb = new StringBuilder(node.getSource());
        ArrayList<String> resolvedShaderNodes = new ArrayList<String>();
        for (ShaderDependencyNode dependencyNode : node.getDependencies()) {
            resolvedShaderNodes.add(this.resolveDependencies(dependencyNode, alreadyInjectedSet));
        }
        List<Integer> injectIndices = node.getDependencyInjectIndices();
        for (int i = resolvedShaderNodes.size() - 1; i >= 0; --i) {
            sb.insert((int)injectIndices.get(i), (String)resolvedShaderNodes.get(i));
        }
        return sb.toString();
    }

    @Override
    public Object load(AssetInfo info) throws IOException {
        this.assetManager = info.getManager();
        InputStreamReader reader = new InputStreamReader(info.openStream());
        if (info.getKey().getExtension().equals("glsllib")) {
            return reader;
        }
        ShaderDependencyNode rootNode = this.loadNode(reader, "[main]");
        String code = this.resolveDependencies(rootNode, new HashSet<ShaderDependencyNode>());
        this.dependCache.clear();
        return code;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ShaderDependencyKey
    extends AssetKey<Reader> {
        public ShaderDependencyKey(String name) {
            super(name);
        }

        @Override
        public Class<? extends AssetCache> getCacheType() {
            return null;
        }
    }
}

