/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.system;

import com.jme3.system.JmeContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AppSettings
extends HashMap<String, Object> {
    private static final AppSettings defaults = new AppSettings(false);
    public static final String LWJGL_OPENGL1 = "LWJGL-OPENGL1";
    public static final String LWJGL_OPENGL2 = "LWJGL-OpenGL2";
    public static final String LWJGL_OPENGL3 = "LWJGL-OpenGL3";
    public static final String LWJGL_OPENGL_ANY = "LWJGL-OpenGL-Any";
    public static final String LWJGL_OPENAL = "LWJGL";
    public static final String ANDROID_MEDIAPLAYER = "MediaPlayer";
    public static final String ANDROID_OPENAL_SOFT = "OpenAL_SOFT";

    public AppSettings(boolean loadDefaults) {
        if (loadDefaults) {
            this.putAll(defaults);
        }
    }

    public void copyFrom(AppSettings other) {
        this.putAll(other);
    }

    public void mergeFrom(AppSettings other) {
        for (String key : other.keySet()) {
            if (this.get(key) != null) continue;
            this.put(key, other.get(key));
        }
    }

    public void load(InputStream in) throws IOException {
        Properties props = new Properties();
        props.load(in);
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = (String)entry.getKey();
            String val = (String)entry.getValue();
            if (val != null) {
                val = val.trim();
            }
            if (key.endsWith("(int)")) {
                key = key.substring(0, key.length() - 5);
                int iVal = Integer.parseInt(val);
                this.putInteger(key, iVal);
                continue;
            }
            if (key.endsWith("(string)")) {
                this.putString(key.substring(0, key.length() - 8), val);
                continue;
            }
            if (key.endsWith("(bool)")) {
                boolean bVal = Boolean.parseBoolean(val);
                this.putBoolean(key.substring(0, key.length() - 6), bVal);
                continue;
            }
            if (key.endsWith("(float)")) {
                float fVal = Float.parseFloat(val);
                this.putFloat(key.substring(0, key.length() - 7), fVal);
                continue;
            }
            throw new IOException("Cannot parse key: " + key);
        }
    }

    public void save(OutputStream out) throws IOException {
        Properties props = new Properties();
        for (Map.Entry entry : this.entrySet()) {
            String type;
            Object val = entry.getValue();
            if (val instanceof Integer) {
                type = "(int)";
            } else if (val instanceof String) {
                type = "(string)";
            } else if (val instanceof Boolean) {
                type = "(bool)";
            } else {
                if (!(val instanceof Float)) continue;
                type = "(float)";
            }
            props.setProperty((String)entry.getKey() + type, val.toString());
        }
        props.store(out, "jME3 AppSettings");
    }

    public void load(String preferencesKey) throws BackingStoreException {
        Preferences prefs = Preferences.userRoot().node(preferencesKey);
        String[] keys = prefs.keys();
        if (keys != null) {
            block6: for (String key : keys) {
                if (key.charAt(1) == '_') {
                    switch (key.charAt(0)) {
                        case 'I': {
                            this.put(key.substring(2), prefs.getInt(key, 0));
                            continue block6;
                        }
                        case 'F': {
                            this.put(key.substring(2), Float.valueOf(prefs.getFloat(key, Float.valueOf(0.0f).floatValue())));
                            continue block6;
                        }
                        case 'S': {
                            this.put(key.substring(2), prefs.get(key, null));
                            continue block6;
                        }
                        case 'B': {
                            this.put(key.substring(2), prefs.getBoolean(key, false));
                            continue block6;
                        }
                        default: {
                            throw new UnsupportedOperationException("Undefined setting type: " + key.charAt(0));
                        }
                    }
                }
                Object defaultValue = defaults.get(key);
                if (defaultValue instanceof Integer) {
                    this.put(key, prefs.getInt(key, (Integer)defaultValue));
                    continue;
                }
                if (defaultValue instanceof String) {
                    this.put(key, prefs.get(key, (String)defaultValue));
                    continue;
                }
                if (!(defaultValue instanceof Boolean)) continue;
                this.put(key, prefs.getBoolean(key, (Boolean)defaultValue));
            }
        }
    }

    public void save(String preferencesKey) throws BackingStoreException {
        Preferences prefs = Preferences.userRoot().node(preferencesKey);
        prefs.clear();
        for (String key : this.keySet()) {
            Object val = this.get(key);
            if (val instanceof Integer) {
                prefs.putInt("I_" + key, (Integer)val);
                continue;
            }
            if (val instanceof Float) {
                prefs.putFloat("F_" + key, ((Float)val).floatValue());
                continue;
            }
            if (val instanceof String) {
                prefs.put("S_" + key, (String)val);
                continue;
            }
            if (!(val instanceof Boolean)) continue;
            prefs.putBoolean("B_" + key, (Boolean)val);
        }
        prefs.sync();
    }

    public int getInteger(String key) {
        Integer i = (Integer)this.get(key);
        if (i == null) {
            return 0;
        }
        return i;
    }

    public boolean getBoolean(String key) {
        Boolean b = (Boolean)this.get(key);
        if (b == null) {
            return false;
        }
        return b;
    }

    public String getString(String key) {
        String s = (String)this.get(key);
        if (s == null) {
            return null;
        }
        return s;
    }

    public float getFloat(String key) {
        Float f = (Float)this.get(key);
        if (f == null) {
            return 0.0f;
        }
        return f.floatValue();
    }

    public void putInteger(String key, int value) {
        this.put(key, value);
    }

    public void putBoolean(String key, boolean value) {
        this.put(key, value);
    }

    public void putString(String key, String value) {
        this.put(key, value);
    }

    public void putFloat(String key, float value) {
        this.put(key, Float.valueOf(value));
    }

    public void setEmulateMouse(boolean emulateMouse) {
        this.putBoolean("TouchEmulateMouse", emulateMouse);
    }

    public boolean isEmulateMouse() {
        return this.getBoolean("TouchEmulateMouse");
    }

    public void setEmulateMouseFlipAxis(boolean flipX, boolean flipY) {
        this.putBoolean("TouchEmulateMouseFlipX", flipX);
        this.putBoolean("TouchEmulateMouseFlipY", flipY);
    }

    public boolean isEmulateMouseFlipX() {
        return this.getBoolean("TouchEmulateMouseFlipX");
    }

    public boolean isEmulateMouseFlipY() {
        return this.getBoolean("TouchEmulateMouseFlipY");
    }

    public void setFrameRate(int frameRate) {
        this.putInteger("FrameRate", frameRate);
    }

    public void setUseInput(boolean use) {
        this.putBoolean("UseInput", use);
    }

    public void setUseJoysticks(boolean use) {
        this.putBoolean("DisableJoysticks", !use);
    }

    public void setRenderer(String renderer) {
        this.putString("Renderer", renderer);
    }

    public void setCustomRenderer(Class<? extends JmeContext> clazz) {
        this.put("Renderer", "CUSTOM" + clazz.getName());
    }

    public void setAudioRenderer(String audioRenderer) {
        this.putString("AudioRenderer", audioRenderer);
    }

    public void setWidth(int value) {
        this.putInteger("Width", value);
    }

    public void setHeight(int value) {
        this.putInteger("Height", value);
    }

    public void setResolution(int width, int height) {
        this.setWidth(width);
        this.setHeight(height);
    }

    public void setMinWidth(int value) {
        this.putInteger("MinWidth", value);
    }

    public void setMinHeight(int value) {
        this.putInteger("MinHeight", value);
    }

    public void setMinResolution(int width, int height) {
        this.setMinWidth(width);
        this.setMinHeight(height);
    }

    public void setFrequency(int value) {
        this.putInteger("Frequency", value);
    }

    public void setDepthBits(int value) {
        this.putInteger("DepthBits", value);
    }

    public void setStencilBits(int value) {
        this.putInteger("StencilBits", value);
    }

    public void setBitsPerPixel(int value) {
        this.putInteger("BitsPerPixel", value);
    }

    public void setSamples(int value) {
        this.putInteger("Samples", value);
    }

    public void setTitle(String title) {
        this.putString("Title", title);
    }

    public void setFullscreen(boolean value) {
        this.putBoolean("Fullscreen", value);
    }

    public void setVSync(boolean value) {
        this.putBoolean("VSync", value);
    }

    public void setStereo3D(boolean value) {
        this.putBoolean("Stereo3D", value);
    }

    public void setIcons(Object[] value) {
        this.put("Icons", value);
    }

    public void setSettingsDialogImage(String path) {
        this.putString("SettingsDialogImage", path);
    }

    public int getFrameRate() {
        return this.getInteger("FrameRate");
    }

    public boolean useInput() {
        return this.getBoolean("UseInput");
    }

    public String getRenderer() {
        return this.getString("Renderer");
    }

    public int getWidth() {
        return this.getInteger("Width");
    }

    public int getHeight() {
        return this.getInteger("Height");
    }

    public int getMinWidth() {
        return this.getInteger("MinWidth");
    }

    public int getMinHeight() {
        return this.getInteger("MinHeight");
    }

    public int getBitsPerPixel() {
        return this.getInteger("BitsPerPixel");
    }

    public int getFrequency() {
        return this.getInteger("Frequency");
    }

    public int getDepthBits() {
        return this.getInteger("DepthBits");
    }

    public int getStencilBits() {
        return this.getInteger("StencilBits");
    }

    public int getSamples() {
        return this.getInteger("Samples");
    }

    public String getTitle() {
        return this.getString("Title");
    }

    public boolean isVSync() {
        return this.getBoolean("VSync");
    }

    public boolean isFullscreen() {
        return this.getBoolean("Fullscreen");
    }

    public boolean useJoysticks() {
        return !this.getBoolean("DisableJoysticks");
    }

    public String getAudioRenderer() {
        return this.getString("AudioRenderer");
    }

    public boolean useStereo3D() {
        return this.getBoolean("Stereo3D");
    }

    public Object[] getIcons() {
        return (Object[])this.get("Icons");
    }

    public String getSettingsDialogImage() {
        return this.getString("SettingsDialogImage");
    }

    static {
        defaults.put("Width", 640);
        defaults.put("Height", 480);
        defaults.put("BitsPerPixel", 24);
        defaults.put("Frequency", 60);
        defaults.put("DepthBits", 24);
        defaults.put("StencilBits", 0);
        defaults.put("Samples", 0);
        defaults.put("Fullscreen", false);
        defaults.put("Title", "jMonkey Engine 3.0");
        defaults.put("Renderer", LWJGL_OPENGL2);
        defaults.put("AudioRenderer", LWJGL_OPENAL);
        defaults.put("DisableJoysticks", true);
        defaults.put("UseInput", true);
        defaults.put("VSync", false);
        defaults.put("FrameRate", -1);
        defaults.put("SettingsDialogImage", "/com/jme3/app/Monkey.png");
        defaults.put("MinHeight", 0);
        defaults.put("MinWidth", 0);
    }
}

