/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.terrain.noise.basis;

import com.jme3.terrain.noise.ShaderUtils;
import com.jme3.terrain.noise.basis.Noise;

public final class ImprovedNoise
extends Noise {
    static final int[] p = new int[512];
    static final int[] permutation = new int[]{151, 160, 137, 91, 90, 15, 131, 13, 201, 95, 96, 53, 194, 233, 7, 225, 140, 36, 103, 30, 69, 142, 8, 99, 37, 240, 21, 10, 23, 190, 6, 148, 247, 120, 234, 75, 0, 26, 197, 62, 94, 252, 219, 203, 117, 35, 11, 32, 57, 177, 33, 88, 237, 149, 56, 87, 174, 20, 125, 136, 171, 168, 68, 175, 74, 165, 71, 134, 139, 48, 27, 166, 77, 146, 158, 231, 83, 111, 229, 122, 60, 211, 133, 230, 220, 105, 92, 41, 55, 46, 245, 40, 244, 102, 143, 54, 65, 25, 63, 161, 1, 216, 80, 73, 209, 76, 132, 187, 208, 89, 18, 169, 200, 196, 135, 130, 116, 188, 159, 86, 164, 100, 109, 198, 173, 186, 3, 64, 52, 217, 226, 250, 124, 123, 5, 202, 38, 147, 118, 126, 255, 82, 85, 212, 207, 206, 59, 227, 47, 16, 58, 17, 182, 189, 28, 42, 223, 183, 170, 213, 119, 248, 152, 2, 44, 154, 163, 70, 221, 153, 101, 155, 167, 43, 172, 9, 129, 22, 39, 253, 19, 98, 108, 110, 79, 113, 224, 232, 178, 185, 112, 104, 218, 246, 97, 228, 251, 34, 242, 193, 238, 210, 144, 12, 191, 179, 162, 241, 81, 51, 145, 235, 249, 14, 239, 107, 49, 192, 214, 31, 181, 199, 106, 157, 184, 84, 204, 176, 115, 121, 50, 45, 127, 4, 150, 254, 138, 236, 205, 93, 222, 114, 67, 29, 24, 72, 243, 141, 128, 195, 78, 66, 215, 61, 156, 180};
    private static float[][] GRAD3 = new float[][]{{1.0f, 1.0f, 0.0f}, {-1.0f, 1.0f, 0.0f}, {1.0f, -1.0f, 0.0f}, {-1.0f, -1.0f, 0.0f}, {1.0f, 0.0f, 1.0f}, {-1.0f, 0.0f, 1.0f}, {1.0f, 0.0f, -1.0f}, {-1.0f, 0.0f, -1.0f}, {0.0f, 1.0f, 1.0f}, {0.0f, -1.0f, 1.0f}, {0.0f, 1.0f, -1.0f}, {0.0f, -1.0f, -1.0f}, {1.0f, 0.0f, -1.0f}, {-1.0f, 0.0f, -1.0f}, {0.0f, -1.0f, 1.0f}, {0.0f, 1.0f, 1.0f}};

    public void init() {
    }

    public static float noise(float x, float y, float z) {
        int X = ShaderUtils.floor(x);
        int Y = ShaderUtils.floor(y);
        int Z = ShaderUtils.floor(z);
        x -= (float)X;
        y -= (float)Y;
        z -= (float)Z;
        float u = ImprovedNoise.fade(x);
        float v = ImprovedNoise.fade(y);
        float w = ImprovedNoise.fade(z);
        int A = p[X &= 0xFF] + (Y &= 0xFF);
        int AA = p[A] + (Z &= 0xFF);
        int AB = p[A + 1] + Z;
        int B = p[X + 1] + Y;
        int BA = p[B] + Z;
        int BB = p[B + 1] + Z;
        return ImprovedNoise.lerp(w, ImprovedNoise.lerp(v, ImprovedNoise.lerp(u, ImprovedNoise.grad3(p[AA], x, y, z), ImprovedNoise.grad3(p[BA], x - 1.0f, y, z)), ImprovedNoise.lerp(u, ImprovedNoise.grad3(p[AB], x, y - 1.0f, z), ImprovedNoise.grad3(p[BB], x - 1.0f, y - 1.0f, z))), ImprovedNoise.lerp(v, ImprovedNoise.lerp(u, ImprovedNoise.grad3(p[AA + 1], x, y, z - 1.0f), ImprovedNoise.grad3(p[BA + 1], x - 1.0f, y, z - 1.0f)), ImprovedNoise.lerp(u, ImprovedNoise.grad3(p[AB + 1], x, y - 1.0f, z - 1.0f), ImprovedNoise.grad3(p[BB + 1], x - 1.0f, y - 1.0f, z - 1.0f))));
    }

    static final float fade(float t) {
        return t * t * t * (t * (t * 6.0f - 15.0f) + 10.0f);
    }

    static final float lerp(float t, float a, float b) {
        return a + t * (b - a);
    }

    static float grad(int hash, float x, float y, float z) {
        float u;
        int h = hash & 0xF;
        float f = u = h < 8 ? x : y;
        float v = h < 4 ? y : (h == 12 || h == 14 ? x : z);
        return ((h & 1) == 0 ? u : -u) + ((h & 2) == 0 ? v : -v);
    }

    static final float grad3(int hash, float x, float y, float z) {
        int h = hash & 0xF;
        return x * GRAD3[h][0] + y * GRAD3[h][1] + z * GRAD3[h][2];
    }

    public float value(float x, float y, float z) {
        return ImprovedNoise.noise(this.scale * x, this.scale * y, this.scale * z);
    }

    static {
        for (int i = 0; i < 256; ++i) {
            ImprovedNoise.p[256 + i] = ImprovedNoise.p[i] = permutation[i];
        }
    }
}

