/*
 * Decompiled with CFR 0.152.
 */
package jme3tools.converters.model.strip;

import java.util.HashSet;
import java.util.logging.Logger;
import jme3tools.converters.model.strip.EdgeInfo;
import jme3tools.converters.model.strip.EdgeInfoVec;
import jme3tools.converters.model.strip.FaceInfo;
import jme3tools.converters.model.strip.FaceInfoVec;
import jme3tools.converters.model.strip.IntVec;
import jme3tools.converters.model.strip.StripInfo;
import jme3tools.converters.model.strip.StripInfoVec;
import jme3tools.converters.model.strip.StripStartInfo;
import jme3tools.converters.model.strip.VertexCache;

class Stripifier {
    private static final Logger logger = Logger.getLogger(Stripifier.class.getName());
    public static int CACHE_INEFFICIENCY = 6;
    IntVec indices = new IntVec();
    int cacheSize;
    int minStripLength;
    float meshJump;
    boolean bFirstTimeResetPoint;

    Stripifier() {
    }

    static EdgeInfo findEdgeInfo(EdgeInfoVec edgeInfos, int v0, int v1) {
        EdgeInfo infoIter = edgeInfos.at(v0);
        while (infoIter != null) {
            if (infoIter.m_v0 == v0) {
                if (infoIter.m_v1 == v1) {
                    return infoIter;
                }
                infoIter = infoIter.m_nextV0;
                continue;
            }
            if (infoIter.m_v0 == v1) {
                return infoIter;
            }
            infoIter = infoIter.m_nextV1;
        }
        return null;
    }

    static FaceInfo findOtherFace(EdgeInfoVec edgeInfos, int v0, int v1, FaceInfo faceInfo) {
        EdgeInfo edgeInfo = Stripifier.findEdgeInfo(edgeInfos, v0, v1);
        if (edgeInfo == null || v0 == v1) {
            return null;
        }
        return edgeInfo.m_face0 == faceInfo ? edgeInfo.m_face1 : edgeInfo.m_face0;
    }

    static boolean alreadyExists(FaceInfo faceInfo, FaceInfoVec faceInfos) {
        for (int i = 0; i < faceInfos.size(); ++i) {
            FaceInfo o = faceInfos.at(i);
            if (o.m_v0 != faceInfo.m_v0 || o.m_v1 != faceInfo.m_v1 || o.m_v2 != faceInfo.m_v2) continue;
            return true;
        }
        return false;
    }

    void buildStripifyInfo(FaceInfoVec faceInfos, EdgeInfoVec edgeInfos, int maxIndex) {
        int numIndices = this.indices.size();
        faceInfos.reserve(numIndices / 3);
        for (int i = 0; i < maxIndex + 1; ++i) {
            edgeInfos.add(null);
        }
        int numTriangles = numIndices / 3;
        int index = 0;
        boolean[] bFaceUpdated = new boolean[3];
        for (int i = 0; i < numTriangles; ++i) {
            int v2;
            int v1;
            boolean bMightAlreadyExist = true;
            bFaceUpdated[0] = false;
            bFaceUpdated[1] = false;
            bFaceUpdated[2] = false;
            int v0 = this.indices.get(index++);
            if (Stripifier.isDegenerate(v0, v1 = this.indices.get(index++), v2 = this.indices.get(index++))) continue;
            FaceInfo faceInfo = new FaceInfo(v0, v1, v2);
            EdgeInfo edgeInfo01 = Stripifier.findEdgeInfo(edgeInfos, v0, v1);
            if (edgeInfo01 == null) {
                bMightAlreadyExist = false;
                edgeInfo01 = new EdgeInfo(v0, v1);
                edgeInfo01.m_nextV0 = edgeInfos.at(v0);
                edgeInfo01.m_nextV1 = edgeInfos.at(v1);
                edgeInfos.set(v0, edgeInfo01);
                edgeInfos.set(v1, edgeInfo01);
                edgeInfo01.m_face0 = faceInfo;
            } else if (edgeInfo01.m_face1 != null) {
                logger.fine("BuildStripifyInfo: > 2 triangles on an edge" + v0 + "," + v1 + "... uncertain consequences\n");
            } else {
                edgeInfo01.m_face1 = faceInfo;
                bFaceUpdated[0] = true;
            }
            EdgeInfo edgeInfo12 = Stripifier.findEdgeInfo(edgeInfos, v1, v2);
            if (edgeInfo12 == null) {
                bMightAlreadyExist = false;
                edgeInfo12 = new EdgeInfo(v1, v2);
                edgeInfo12.m_nextV0 = edgeInfos.at(v1);
                edgeInfo12.m_nextV1 = edgeInfos.at(v2);
                edgeInfos.set(v1, edgeInfo12);
                edgeInfos.set(v2, edgeInfo12);
                edgeInfo12.m_face0 = faceInfo;
            } else if (edgeInfo12.m_face1 != null) {
                logger.fine("BuildStripifyInfo: > 2 triangles on an edge" + v1 + "," + v2 + "... uncertain consequences\n");
            } else {
                edgeInfo12.m_face1 = faceInfo;
                bFaceUpdated[1] = true;
            }
            EdgeInfo edgeInfo20 = Stripifier.findEdgeInfo(edgeInfos, v2, v0);
            if (edgeInfo20 == null) {
                bMightAlreadyExist = false;
                edgeInfo20 = new EdgeInfo(v2, v0);
                edgeInfo20.m_nextV0 = edgeInfos.at(v2);
                edgeInfo20.m_nextV1 = edgeInfos.at(v0);
                edgeInfos.set(v2, edgeInfo20);
                edgeInfos.set(v0, edgeInfo20);
                edgeInfo20.m_face0 = faceInfo;
            } else if (edgeInfo20.m_face1 != null) {
                logger.fine("BuildStripifyInfo: > 2 triangles on an edge" + v2 + "," + v0 + "... uncertain consequences\n");
            } else {
                edgeInfo20.m_face1 = faceInfo;
                bFaceUpdated[2] = true;
            }
            if (bMightAlreadyExist) {
                if (!Stripifier.alreadyExists(faceInfo, faceInfos)) {
                    faceInfos.add(faceInfo);
                    continue;
                }
                if (bFaceUpdated[0]) {
                    edgeInfo01.m_face1 = null;
                }
                if (bFaceUpdated[1]) {
                    edgeInfo12.m_face1 = null;
                }
                if (!bFaceUpdated[2]) continue;
                edgeInfo20.m_face1 = null;
                continue;
            }
            faceInfos.add(faceInfo);
        }
    }

    static boolean isDegenerate(FaceInfo face) {
        if (face.m_v0 == face.m_v1) {
            return true;
        }
        if (face.m_v0 == face.m_v2) {
            return true;
        }
        return face.m_v1 == face.m_v2;
    }

    static boolean isDegenerate(int v0, int v1, int v2) {
        if (v0 == v1) {
            return true;
        }
        if (v0 == v2) {
            return true;
        }
        return v1 == v2;
    }

    static int getNextIndex(IntVec indices, FaceInfo face) {
        int numIndices = indices.size();
        int v0 = indices.get(numIndices - 2);
        int v1 = indices.get(numIndices - 1);
        int fv0 = face.m_v0;
        int fv1 = face.m_v1;
        int fv2 = face.m_v2;
        if (fv0 != v0 && fv0 != v1) {
            if (fv1 != v0 && fv1 != v1 || fv2 != v0 && fv2 != v1) {
                logger.fine("GetNextIndex: Triangle doesn't have all of its vertices\n");
                logger.fine("GetNextIndex: Duplicate triangle probably got us derailed\n");
            }
            return fv0;
        }
        if (fv1 != v0 && fv1 != v1) {
            if (fv0 != v0 && fv0 != v1 || fv2 != v0 && fv2 != v1) {
                logger.fine("GetNextIndex: Triangle doesn't have all of its vertices\n");
                logger.fine("GetNextIndex: Duplicate triangle probably got us derailed\n");
            }
            return fv1;
        }
        if (fv2 != v0 && fv2 != v1) {
            if (fv0 != v0 && fv0 != v1 || fv1 != v0 && fv1 != v1) {
                logger.fine("GetNextIndex: Triangle doesn't have all of its vertices\n");
                logger.fine("GetNextIndex: Duplicate triangle probably got us derailed\n");
            }
            return fv2;
        }
        if (fv0 == fv1 || fv0 == fv2) {
            return fv0;
        }
        if (fv1 == fv0 || fv1 == fv2) {
            return fv1;
        }
        if (fv2 == fv0 || fv2 == fv1) {
            return fv2;
        }
        return -1;
    }

    static int findStartPoint(FaceInfoVec faceInfos, EdgeInfoVec edgeInfos) {
        int bestCtr = -1;
        int bestIndex = -1;
        for (int i = 0; i < faceInfos.size(); ++i) {
            int ctr = 0;
            if (Stripifier.findOtherFace(edgeInfos, faceInfos.at((int)i).m_v0, faceInfos.at((int)i).m_v1, faceInfos.at(i)) == null) {
                ++ctr;
            }
            if (Stripifier.findOtherFace(edgeInfos, faceInfos.at((int)i).m_v1, faceInfos.at((int)i).m_v2, faceInfos.at(i)) == null) {
                ++ctr;
            }
            if (Stripifier.findOtherFace(edgeInfos, faceInfos.at((int)i).m_v2, faceInfos.at((int)i).m_v0, faceInfos.at(i)) == null) {
                ++ctr;
            }
            if (ctr <= bestCtr) continue;
            bestCtr = ctr;
            bestIndex = i;
        }
        if (bestCtr == 0) {
            return -1;
        }
        return bestIndex;
    }

    FaceInfo findGoodResetPoint(FaceInfoVec faceInfos, EdgeInfoVec edgeInfos) {
        FaceInfo result = null;
        if (result == null) {
            int startPoint;
            int numFaces = faceInfos.size();
            if (this.bFirstTimeResetPoint) {
                startPoint = Stripifier.findStartPoint(faceInfos, edgeInfos);
                this.bFirstTimeResetPoint = false;
            } else {
                startPoint = (int)(((float)numFaces - 1.0f) * this.meshJump);
            }
            if (startPoint == -1) {
                startPoint = (int)(((float)numFaces - 1.0f) * this.meshJump);
            }
            int i = startPoint;
            do {
                if (faceInfos.at((int)i).m_stripId < 0) {
                    result = faceInfos.at(i);
                    break;
                }
                if (++i < numFaces) continue;
                i = 0;
            } while (i != startPoint);
            this.meshJump += 0.1f;
            if (this.meshJump > 1.0f) {
                this.meshJump = 0.05f;
            }
        }
        return result;
    }

    static int getUniqueVertexInB(FaceInfo faceA, FaceInfo faceB) {
        int facev0 = faceB.m_v0;
        if (facev0 != faceA.m_v0 && facev0 != faceA.m_v1 && facev0 != faceA.m_v2) {
            return facev0;
        }
        int facev1 = faceB.m_v1;
        if (facev1 != faceA.m_v0 && facev1 != faceA.m_v1 && facev1 != faceA.m_v2) {
            return facev1;
        }
        int facev2 = faceB.m_v2;
        if (facev2 != faceA.m_v0 && facev2 != faceA.m_v1 && facev2 != faceA.m_v2) {
            return facev2;
        }
        return -1;
    }

    static void getSharedVertices(FaceInfo faceA, FaceInfo faceB, int[] vertex) {
        int facev2;
        int facev1;
        vertex[0] = -1;
        vertex[1] = -1;
        int facev0 = faceB.m_v0;
        if (facev0 == faceA.m_v0 || facev0 == faceA.m_v1 || facev0 == faceA.m_v2) {
            if (vertex[0] == -1) {
                vertex[0] = facev0;
            } else {
                vertex[1] = facev0;
                return;
            }
        }
        if ((facev1 = faceB.m_v1) == faceA.m_v0 || facev1 == faceA.m_v1 || facev1 == faceA.m_v2) {
            if (vertex[0] == -1) {
                vertex[0] = facev1;
            } else {
                vertex[1] = facev1;
                return;
            }
        }
        if ((facev2 = faceB.m_v2) == faceA.m_v0 || facev2 == faceA.m_v1 || facev2 == faceA.m_v2) {
            if (vertex[0] == -1) {
                vertex[0] = facev2;
            } else {
                vertex[1] = facev2;
                return;
            }
        }
    }

    static void commitStrips(StripInfoVec allStrips, StripInfoVec strips) {
        int numStrips = strips.size();
        for (int i = 0; i < numStrips; ++i) {
            StripInfo strip = strips.at(i);
            strip.m_experimentId = -1;
            allStrips.add(strip);
            FaceInfoVec faces = strips.at((int)i).m_faces;
            int numFaces = faces.size();
            for (int j = 0; j < numFaces; ++j) {
                strip.markTriangle(faces.at(j));
            }
        }
    }

    static boolean nextIsCW(int numIndices) {
        return numIndices % 2 == 0;
    }

    static void updateCacheFace(VertexCache vcache, FaceInfo face) {
        if (!vcache.inCache(face.m_v0)) {
            vcache.addEntry(face.m_v0);
        }
        if (!vcache.inCache(face.m_v1)) {
            vcache.addEntry(face.m_v1);
        }
        if (!vcache.inCache(face.m_v2)) {
            vcache.addEntry(face.m_v2);
        }
    }

    static void updateCacheStrip(VertexCache vcache, StripInfo strip) {
        for (int i = 0; i < strip.m_faces.size(); ++i) {
            if (!vcache.inCache(strip.m_faces.at((int)i).m_v0)) {
                vcache.addEntry(strip.m_faces.at((int)i).m_v0);
            }
            if (!vcache.inCache(strip.m_faces.at((int)i).m_v1)) {
                vcache.addEntry(strip.m_faces.at((int)i).m_v1);
            }
            if (vcache.inCache(strip.m_faces.at((int)i).m_v2)) continue;
            vcache.addEntry(strip.m_faces.at((int)i).m_v2);
        }
    }

    static float calcNumHitsStrip(VertexCache vcache, StripInfo strip) {
        int numHits = 0;
        int numFaces = 0;
        for (int i = 0; i < strip.m_faces.size(); ++i) {
            if (vcache.inCache(strip.m_faces.at((int)i).m_v0)) {
                ++numHits;
            }
            if (vcache.inCache(strip.m_faces.at((int)i).m_v1)) {
                ++numHits;
            }
            if (vcache.inCache(strip.m_faces.at((int)i).m_v2)) {
                ++numHits;
            }
            ++numFaces;
        }
        return (float)numHits / (float)numFaces;
    }

    static float avgStripSize(StripInfoVec strips) {
        int sizeAccum = 0;
        int numStrips = strips.size();
        for (int i = 0; i < numStrips; ++i) {
            StripInfo strip = strips.at(i);
            sizeAccum += strip.m_faces.size();
            sizeAccum -= strip.m_numDegenerates;
        }
        return (float)sizeAccum / (float)numStrips;
    }

    static int calcNumHitsFace(VertexCache vcache, FaceInfo face) {
        int numHits = 0;
        if (vcache.inCache(face.m_v0)) {
            ++numHits;
        }
        if (vcache.inCache(face.m_v1)) {
            ++numHits;
        }
        if (vcache.inCache(face.m_v2)) {
            ++numHits;
        }
        return numHits;
    }

    static int numNeighbors(FaceInfo face, EdgeInfoVec edgeInfoVec) {
        int numNeighbors = 0;
        if (Stripifier.findOtherFace(edgeInfoVec, face.m_v0, face.m_v1, face) != null) {
            ++numNeighbors;
        }
        if (Stripifier.findOtherFace(edgeInfoVec, face.m_v1, face.m_v2, face) != null) {
            ++numNeighbors;
        }
        if (Stripifier.findOtherFace(edgeInfoVec, face.m_v2, face.m_v0, face) != null) {
            ++numNeighbors;
        }
        return numNeighbors;
    }

    static boolean isCW(FaceInfo faceInfo, int v0, int v1) {
        if (faceInfo.m_v0 == v0) {
            return faceInfo.m_v1 == v1;
        }
        if (faceInfo.m_v1 == v0) {
            return faceInfo.m_v2 == v1;
        }
        return faceInfo.m_v0 == v1;
    }

    static boolean faceContainsIndex(FaceInfo face, int index) {
        return face.m_v0 == index || face.m_v1 == index || face.m_v2 == index;
    }

    static boolean findTraversal(FaceInfoVec faceInfos, EdgeInfoVec edgeInfos, StripInfo strip, StripStartInfo startInfo) {
        int v = strip.m_startInfo.m_toV1 ? strip.m_startInfo.m_startEdge.m_v1 : strip.m_startInfo.m_startEdge.m_v0;
        FaceInfo untouchedFace = null;
        EdgeInfo edgeIter = edgeInfos.at(v);
        while (edgeIter != null) {
            FaceInfo face0 = edgeIter.m_face0;
            FaceInfo face1 = edgeIter.m_face1;
            if (face0 != null && !strip.isInStrip(face0) && face1 != null && !strip.isMarked(face1)) {
                untouchedFace = face1;
                break;
            }
            if (face1 != null && !strip.isInStrip(face1) && face0 != null && !strip.isMarked(face0)) {
                untouchedFace = face0;
                break;
            }
            edgeIter = edgeIter.m_v0 == v ? edgeIter.m_nextV0 : edgeIter.m_nextV1;
        }
        startInfo.m_startFace = untouchedFace;
        startInfo.m_startEdge = edgeIter;
        if (edgeIter != null) {
            startInfo.m_toV1 = strip.sharesEdge(startInfo.m_startFace, edgeInfos) ? edgeIter.m_v0 == v : edgeIter.m_v1 == v;
        }
        return startInfo.m_startFace != null;
    }

    void removeSmallStrips(StripInfoVec allStrips, StripInfoVec allBigStrips, FaceInfoVec faceList) {
        faceList.clear();
        allBigStrips.clear();
        FaceInfoVec tempFaceList = new FaceInfoVec();
        for (int i = 0; i < allStrips.size(); ++i) {
            if (allStrips.at((int)i).m_faces.size() < this.minStripLength) {
                for (int j = 0; j < allStrips.at((int)i).m_faces.size(); ++j) {
                    tempFaceList.add(allStrips.at((int)i).m_faces.at(j));
                }
                continue;
            }
            allBigStrips.add(allStrips.at(i));
        }
        boolean[] bVisitedList = new boolean[tempFaceList.size()];
        VertexCache vcache = new VertexCache(this.cacheSize);
        int bestNumHits = -1;
        int bestIndex = -9999;
        while (true) {
            bestNumHits = -1;
            for (int i = 0; i < tempFaceList.size(); ++i) {
                int numHits;
                if (bVisitedList[i] || (numHits = Stripifier.calcNumHitsFace(vcache, tempFaceList.at(i))) <= bestNumHits) continue;
                bestNumHits = numHits;
                bestIndex = i;
            }
            if ((float)bestNumHits == -1.0f) break;
            bVisitedList[bestIndex] = true;
            Stripifier.updateCacheFace(vcache, tempFaceList.at(bestIndex));
            faceList.add(tempFaceList.at(bestIndex));
        }
    }

    int createStrips(StripInfoVec allStrips, IntVec stripIndices, boolean bStitchStrips) {
        int numSeparateStrips = 0;
        FaceInfo tLastFace = new FaceInfo(0, 0, 0);
        int nStripCount = allStrips.size();
        int accountForNegatives = 0;
        for (int i = 0; i < nStripCount; ++i) {
            int nUnique;
            StripInfo strip = allStrips.at(i);
            int nStripFaceCount = strip.m_faces.size();
            FaceInfo tFirstFace = new FaceInfo(strip.m_faces.at((int)0).m_v0, strip.m_faces.at((int)0).m_v1, strip.m_faces.at((int)0).m_v2);
            if (nStripFaceCount > 1) {
                nUnique = Stripifier.getUniqueVertexInB(strip.m_faces.at(1), tFirstFace);
                if (nUnique == tFirstFace.m_v1) {
                    int tmp = tFirstFace.m_v0;
                    tFirstFace.m_v0 = tFirstFace.m_v1;
                    tFirstFace.m_v1 = tmp;
                } else if (nUnique == tFirstFace.m_v2) {
                    int tmp = tFirstFace.m_v0;
                    tFirstFace.m_v0 = tFirstFace.m_v2;
                    tFirstFace.m_v2 = tmp;
                }
                if (nStripFaceCount > 2) {
                    int tmp;
                    if (Stripifier.isDegenerate(strip.m_faces.at(1))) {
                        int pivot = strip.m_faces.at((int)1).m_v1;
                        if (tFirstFace.m_v1 == pivot) {
                            tmp = tFirstFace.m_v1;
                            tFirstFace.m_v1 = tFirstFace.m_v2;
                            tFirstFace.m_v2 = tmp;
                        }
                    } else {
                        int[] nShared = new int[2];
                        Stripifier.getSharedVertices(strip.m_faces.at(2), tFirstFace, nShared);
                        if (nShared[0] == tFirstFace.m_v1 && nShared[1] == -1) {
                            tmp = tFirstFace.m_v1;
                            tFirstFace.m_v1 = tFirstFace.m_v2;
                            tFirstFace.m_v2 = tmp;
                        }
                    }
                }
            }
            if (i == 0 || !bStitchStrips) {
                if (!Stripifier.isCW(strip.m_faces.at(0), tFirstFace.m_v0, tFirstFace.m_v1)) {
                    stripIndices.add(tFirstFace.m_v0);
                }
            } else {
                stripIndices.add(tFirstFace.m_v0);
                if (Stripifier.nextIsCW(stripIndices.size() - accountForNegatives) != Stripifier.isCW(strip.m_faces.at(0), tFirstFace.m_v0, tFirstFace.m_v1)) {
                    stripIndices.add(tFirstFace.m_v0);
                }
            }
            stripIndices.add(tFirstFace.m_v0);
            stripIndices.add(tFirstFace.m_v1);
            stripIndices.add(tFirstFace.m_v2);
            tLastFace.set(tFirstFace);
            for (int j = 1; j < nStripFaceCount; ++j) {
                nUnique = Stripifier.getUniqueVertexInB(tLastFace, strip.m_faces.at(j));
                if (nUnique != -1) {
                    stripIndices.add(nUnique);
                    tLastFace.m_v0 = tLastFace.m_v1;
                    tLastFace.m_v1 = tLastFace.m_v2;
                    tLastFace.m_v2 = nUnique;
                    continue;
                }
                stripIndices.add(strip.m_faces.at((int)j).m_v2);
                tLastFace.m_v0 = strip.m_faces.at((int)j).m_v0;
                tLastFace.m_v1 = strip.m_faces.at((int)j).m_v1;
                tLastFace.m_v2 = strip.m_faces.at((int)j).m_v2;
            }
            if (bStitchStrips) {
                if (i != nStripCount - 1) {
                    stripIndices.add(tLastFace.m_v2);
                }
            } else {
                stripIndices.add(-1);
                ++accountForNegatives;
                ++numSeparateStrips;
            }
            tLastFace.m_v0 = tLastFace.m_v1;
            tLastFace.m_v1 = tLastFace.m_v2;
            tLastFace.m_v2 = tLastFace.m_v2;
        }
        if (bStitchStrips) {
            numSeparateStrips = 1;
        }
        return numSeparateStrips;
    }

    void findAllStrips(StripInfoVec allStrips, FaceInfoVec allFaceInfos, EdgeInfoVec allEdgeInfos, int numSamples) {
        int experimentId = 0;
        int stripId = 0;
        boolean done = false;
        int loopCtr = 0;
        while (!done) {
            ++loopCtr;
            StripInfoVec[] experiments = new StripInfoVec[numSamples * 6];
            for (int i = 0; i < experiments.length; ++i) {
                experiments[i] = new StripInfoVec();
            }
            int experimentIndex = 0;
            HashSet<FaceInfo> resetPoints = new HashSet<FaceInfo>();
            for (int i = 0; i < numSamples; ++i) {
                FaceInfo nextFace = this.findGoodResetPoint(allFaceInfos, allEdgeInfos);
                if (nextFace == null) {
                    done = true;
                    break;
                }
                if (resetPoints.contains(nextFace)) continue;
                resetPoints.add(nextFace);
                EdgeInfo edge01 = Stripifier.findEdgeInfo(allEdgeInfos, nextFace.m_v0, nextFace.m_v1);
                StripInfo strip01 = new StripInfo(new StripStartInfo(nextFace, edge01, true), stripId++, experimentId++);
                experiments[experimentIndex++].add(strip01);
                EdgeInfo edge10 = Stripifier.findEdgeInfo(allEdgeInfos, nextFace.m_v0, nextFace.m_v1);
                StripInfo strip10 = new StripInfo(new StripStartInfo(nextFace, edge10, false), stripId++, experimentId++);
                experiments[experimentIndex++].add(strip10);
                EdgeInfo edge12 = Stripifier.findEdgeInfo(allEdgeInfos, nextFace.m_v1, nextFace.m_v2);
                StripInfo strip12 = new StripInfo(new StripStartInfo(nextFace, edge12, true), stripId++, experimentId++);
                experiments[experimentIndex++].add(strip12);
                EdgeInfo edge21 = Stripifier.findEdgeInfo(allEdgeInfos, nextFace.m_v1, nextFace.m_v2);
                StripInfo strip21 = new StripInfo(new StripStartInfo(nextFace, edge21, false), stripId++, experimentId++);
                experiments[experimentIndex++].add(strip21);
                EdgeInfo edge20 = Stripifier.findEdgeInfo(allEdgeInfos, nextFace.m_v2, nextFace.m_v0);
                StripInfo strip20 = new StripInfo(new StripStartInfo(nextFace, edge20, true), stripId++, experimentId++);
                experiments[experimentIndex++].add(strip20);
                EdgeInfo edge02 = Stripifier.findEdgeInfo(allEdgeInfos, nextFace.m_v2, nextFace.m_v0);
                StripInfo strip02 = new StripInfo(new StripStartInfo(nextFace, edge02, false), stripId++, experimentId++);
                experiments[experimentIndex++].add(strip02);
            }
            int numExperiments = experimentIndex;
            for (int i = 0; i < numExperiments; ++i) {
                experiments[i].at(0).build(allEdgeInfos, allFaceInfos);
                int experimentId2 = experiments[i].at((int)0).m_experimentId;
                StripInfo stripIter = experiments[i].at(0);
                StripStartInfo startInfo = new StripStartInfo(null, null, false);
                while (Stripifier.findTraversal(allFaceInfos, allEdgeInfos, stripIter, startInfo)) {
                    stripIter = new StripInfo(startInfo, stripId++, experimentId2);
                    stripIter.build(allEdgeInfos, allFaceInfos);
                    experiments[i].add(stripIter);
                }
            }
            int bestIndex = 0;
            double bestValue = 0.0;
            for (int i = 0; i < numExperiments; ++i) {
                float numStrips;
                float avgStripSizeWeight = 1.0f;
                float numStripsWeight = 0.0f;
                float avgStripSize = Stripifier.avgStripSize(experiments[i]);
                float value = avgStripSize * avgStripSizeWeight + (numStrips = (float)experiments[i].size()) * numStripsWeight;
                if (!((double)value > bestValue)) continue;
                bestValue = value;
                bestIndex = i;
            }
            Stripifier.commitStrips(allStrips, experiments[bestIndex]);
        }
    }

    void splitUpStripsAndOptimize(StripInfoVec allStrips, StripInfoVec outStrips, EdgeInfoVec edgeInfos, FaceInfoVec outFaceList) {
        int j;
        int threshold = this.cacheSize;
        StripInfoVec tempStrips = new StripInfoVec();
        for (int i = 0; i < allStrips.size(); ++i) {
            StripInfo currentStrip;
            StripStartInfo startInfo = new StripStartInfo(null, null, false);
            int actualStripSize = 0;
            for (j = 0; j < allStrips.at((int)i).m_faces.size(); ++j) {
                if (Stripifier.isDegenerate(allStrips.at((int)i).m_faces.at(j))) continue;
                ++actualStripSize;
            }
            if (actualStripSize > threshold) {
                int numTimes = actualStripSize / threshold;
                int numLeftover = actualStripSize % threshold;
                int degenerateCount = 0;
                for (j = 0; j < numTimes; ++j) {
                    currentStrip = new StripInfo(startInfo, 0, -1);
                    int faceCtr = j * threshold + degenerateCount;
                    boolean bFirstTime = true;
                    while (faceCtr < threshold + j * threshold + degenerateCount) {
                        if (Stripifier.isDegenerate(allStrips.at((int)i).m_faces.at(faceCtr))) {
                            if ((faceCtr + 1 != threshold + j * threshold + ++degenerateCount || j == numTimes - 1 && numLeftover < 4 && numLeftover > 0) && !bFirstTime) {
                                currentStrip.m_faces.add(allStrips.at((int)i).m_faces.at(faceCtr++));
                                continue;
                            }
                            ++faceCtr;
                            continue;
                        }
                        currentStrip.m_faces.add(allStrips.at((int)i).m_faces.at(faceCtr++));
                        bFirstTime = false;
                    }
                    if (j == numTimes - 1 && numLeftover < 4 && numLeftover > 0) {
                        int ctr = 0;
                        while (ctr < numLeftover) {
                            if (!Stripifier.isDegenerate(allStrips.at((int)i).m_faces.at(faceCtr))) {
                                currentStrip.m_faces.add(allStrips.at((int)i).m_faces.at(faceCtr++));
                                ++ctr;
                                continue;
                            }
                            currentStrip.m_faces.add(allStrips.at((int)i).m_faces.at(faceCtr++));
                            ++degenerateCount;
                        }
                        numLeftover = 0;
                    }
                    tempStrips.add(currentStrip);
                }
                int leftOff = j * threshold + degenerateCount;
                if (numLeftover == 0) continue;
                currentStrip = new StripInfo(startInfo, 0, -1);
                int ctr = 0;
                boolean bFirstTime = true;
                while (ctr < numLeftover) {
                    if (!Stripifier.isDegenerate(allStrips.at((int)i).m_faces.at(leftOff))) {
                        ++ctr;
                        bFirstTime = false;
                        currentStrip.m_faces.add(allStrips.at((int)i).m_faces.at(leftOff++));
                        continue;
                    }
                    if (!bFirstTime) {
                        currentStrip.m_faces.add(allStrips.at((int)i).m_faces.at(leftOff++));
                        continue;
                    }
                    ++leftOff;
                }
                tempStrips.add(currentStrip);
                continue;
            }
            currentStrip = new StripInfo(startInfo, 0, -1);
            for (j = 0; j < allStrips.at((int)i).m_faces.size(); ++j) {
                currentStrip.m_faces.add(allStrips.at((int)i).m_faces.at(j));
            }
            tempStrips.add(currentStrip);
        }
        StripInfoVec tempStrips2 = new StripInfoVec();
        this.removeSmallStrips(tempStrips, tempStrips2, outFaceList);
        outStrips.clear();
        if (tempStrips2.size() != 0) {
            VertexCache vcache = new VertexCache(this.cacheSize);
            float bestNumHits = -1.0f;
            int bestIndex = -99999;
            int firstIndex = 0;
            float minCost = 10000.0f;
            for (int i = 0; i < tempStrips2.size(); ++i) {
                int numNeighbors = 0;
                for (j = 0; j < tempStrips2.at((int)i).m_faces.size(); ++j) {
                    numNeighbors += Stripifier.numNeighbors(tempStrips2.at((int)i).m_faces.at(j), edgeInfos);
                }
                float currCost = (float)numNeighbors / (float)tempStrips2.at((int)i).m_faces.size();
                if (!(currCost < minCost)) continue;
                minCost = currCost;
                firstIndex = i;
            }
            Stripifier.updateCacheStrip(vcache, tempStrips2.at(firstIndex));
            outStrips.add(tempStrips2.at(firstIndex));
            tempStrips2.at((int)firstIndex).visited = true;
            boolean bWantsCW = tempStrips2.at((int)firstIndex).m_faces.size() % 2 == 0;
            while (true) {
                bestNumHits = -1.0f;
                for (int i = 0; i < tempStrips2.size(); ++i) {
                    if (tempStrips2.at((int)i).visited) continue;
                    float numHits = Stripifier.calcNumHitsStrip(vcache, tempStrips2.at(i));
                    if (numHits > bestNumHits) {
                        bestNumHits = numHits;
                        bestIndex = i;
                        continue;
                    }
                    if (!(numHits >= bestNumHits)) continue;
                    StripInfo strip = tempStrips2.at(i);
                    int nStripFaceCount = strip.m_faces.size();
                    FaceInfo tFirstFace = new FaceInfo(strip.m_faces.at((int)0).m_v0, strip.m_faces.at((int)0).m_v1, strip.m_faces.at((int)0).m_v2);
                    if (nStripFaceCount > 1) {
                        int nUnique = Stripifier.getUniqueVertexInB(strip.m_faces.at(1), tFirstFace);
                        if (nUnique == tFirstFace.m_v1) {
                            int tmp = tFirstFace.m_v0;
                            tFirstFace.m_v0 = tFirstFace.m_v1;
                            tFirstFace.m_v1 = tmp;
                        } else if (nUnique == tFirstFace.m_v2) {
                            int tmp = tFirstFace.m_v0;
                            tFirstFace.m_v0 = tFirstFace.m_v2;
                            tFirstFace.m_v2 = tmp;
                        }
                        if (nStripFaceCount > 2) {
                            int[] nShared = new int[2];
                            Stripifier.getSharedVertices(strip.m_faces.at(2), tFirstFace, nShared);
                            if (nShared[0] == tFirstFace.m_v1 && nShared[1] == -1) {
                                int tmp = tFirstFace.m_v2;
                                tFirstFace.m_v2 = tFirstFace.m_v1;
                                tFirstFace.m_v1 = tmp;
                            }
                        }
                    }
                    if (bWantsCW != Stripifier.isCW(strip.m_faces.at(0), tFirstFace.m_v0, tFirstFace.m_v1)) continue;
                    bestIndex = i;
                }
                if (bestNumHits == -1.0f) break;
                tempStrips2.at((int)bestIndex).visited = true;
                Stripifier.updateCacheStrip(vcache, tempStrips2.at(bestIndex));
                outStrips.add(tempStrips2.at(bestIndex));
                bWantsCW = tempStrips2.at((int)bestIndex).m_faces.size() % 2 == 0 ? bWantsCW : !bWantsCW;
            }
        }
    }

    void stripify(IntVec in_indices, int in_cacheSize, int in_minStripLength, int maxIndex, StripInfoVec outStrips, FaceInfoVec outFaceList) {
        this.meshJump = 0.0f;
        this.bFirstTimeResetPoint = true;
        int numSamples = 10;
        this.cacheSize = Math.max(1, in_cacheSize - CACHE_INEFFICIENCY);
        this.minStripLength = in_minStripLength;
        this.indices = in_indices;
        FaceInfoVec allFaceInfos = new FaceInfoVec();
        EdgeInfoVec allEdgeInfos = new EdgeInfoVec();
        this.buildStripifyInfo(allFaceInfos, allEdgeInfos, maxIndex);
        StripInfoVec allStrips = new StripInfoVec();
        this.findAllStrips(allStrips, allFaceInfos, allEdgeInfos, numSamples);
        this.splitUpStripsAndOptimize(allStrips, outStrips, allEdgeInfos, outFaceList);
    }
}

