/*
 * Decompiled with CFR 0.152.
 */
package jme3tools.navigation;

import java.awt.Point;
import java.text.DecimalFormat;
import jme3tools.navigation.InvalidPositionException;
import jme3tools.navigation.NavCalculator;
import jme3tools.navigation.Position;

public class MapModel2D {
    private static final double RADIANS_PER_DEGREE = 57.2957;
    private static final double DEGREES_PER_RADIAN = 0.0174532925;
    public static final int DEFAULT_MAP_WIDTH_LONGITUDE = 360;
    private Position centre;
    private int xCentre;
    private int yCentre;
    private int viewportWidth;
    private int viewportHeight;
    private double minutesPerPixel;

    public MapModel2D(int viewportWidth) {
        try {
            this.centre = new Position(0.0, 0.0);
        }
        catch (InvalidPositionException e) {
            e.printStackTrace();
        }
        this.viewportWidth = viewportWidth;
        this.calculateMinutesPerPixel(360.0);
        this.viewportHeight = (int)NavCalculator.computeDMPClarkeSpheroid(0.0, 85.0) / (int)this.minutesPerPixel * 2;
        this.xCentre = viewportWidth / 2;
        this.yCentre = this.viewportHeight / 2;
    }

    public int getViewportPixelHeight() {
        return this.viewportHeight;
    }

    public void calculateMinutesPerPixel(double mapWidthInLongitude) {
        this.minutesPerPixel = mapWidthInLongitude * 60.0 / (double)this.viewportWidth;
    }

    public int getViewportPixelWidth() {
        return this.viewportWidth;
    }

    public void setViewportWidth(int viewportWidth) {
        this.viewportWidth = viewportWidth;
    }

    public void setViewportHeight(int viewportHeight) {
        this.viewportHeight = viewportHeight;
    }

    public void setCentre(Position centre) {
        this.centre = centre;
    }

    public double getMinutesPerPixel() {
        return this.minutesPerPixel;
    }

    public double getMetersPerPixel() {
        return 1853.0 * this.minutesPerPixel;
    }

    public void setMinutesPerPixel(double minutesPerPixel) {
        this.minutesPerPixel = minutesPerPixel;
    }

    public Point toPixel(Position position) {
        double distance = NavCalculator.computeLongDiff(this.centre.getLongitude(), position.getLongitude());
        double distanceInPixels = distance / this.minutesPerPixel;
        double dmp = NavCalculator.computeDMPClarkeSpheroid(this.centre.getLatitude(), position.getLatitude());
        int x = 0;
        int y = 0;
        if (this.centre.getLatitude() == position.getLatitude()) {
            y = this.yCentre;
        }
        if (this.centre.getLongitude() == position.getLongitude()) {
            x = this.xCentre;
        }
        if (this.centre.getLatitude() > 0.0 && position.getLatitude() > this.centre.getLatitude()) {
            y = this.yCentre + (int)(dmp / this.minutesPerPixel);
        } else if (this.centre.getLatitude() > 0.0 && position.getLatitude() < this.centre.getLatitude()) {
            y = this.yCentre - (int)(dmp / this.minutesPerPixel);
        } else if (this.centre.getLatitude() < 0.0 && position.getLatitude() > this.centre.getLatitude()) {
            y = this.yCentre + (int)(dmp / this.minutesPerPixel);
        } else if (this.centre.getLatitude() < 0.0 && position.getLatitude() < this.centre.getLatitude()) {
            y = this.yCentre - (int)(dmp / this.minutesPerPixel);
        } else if (this.centre.getLatitude() == 0.0 && position.getLatitude() > this.centre.getLatitude()) {
            y = this.yCentre + (int)(dmp / this.minutesPerPixel);
        } else if (this.centre.getLatitude() == 0.0 && position.getLatitude() < this.centre.getLatitude()) {
            y = this.yCentre - (int)(dmp / this.minutesPerPixel);
        }
        if (this.centre.getLongitude() < 0.0 && position.getLongitude() < this.centre.getLongitude()) {
            x = this.xCentre - (int)distanceInPixels;
        } else if (this.centre.getLongitude() < 0.0 && position.getLongitude() > this.centre.getLongitude()) {
            x = this.xCentre + (int)distanceInPixels;
        } else if (this.centre.getLongitude() > 0.0 && position.getLongitude() < this.centre.getLongitude()) {
            x = this.xCentre - (int)distanceInPixels;
        } else if (this.centre.getLongitude() > 0.0 && position.getLongitude() > this.centre.getLongitude()) {
            x = this.xCentre + (int)distanceInPixels;
        } else if (this.centre.getLongitude() == 0.0 && position.getLongitude() > this.centre.getLongitude()) {
            x = this.xCentre + (int)distanceInPixels;
        } else if (this.centre.getLongitude() == 0.0 && position.getLongitude() < this.centre.getLongitude()) {
            x = this.xCentre - (int)distanceInPixels;
        }
        return new Point(x, y);
    }

    public Position toPosition(Point p) {
        Position pos = null;
        try {
            double lon;
            double lat;
            Point pixelCentre = this.toPixel(new Position(0.0, 0.0));
            double xDistance = this.distance(this.xCentre, p.getX());
            double yDistance = this.distance(pixelCentre.getY(), p.getY());
            double lonDistanceInDegrees = xDistance * this.minutesPerPixel / 60.0;
            double mp = yDistance * this.minutesPerPixel;
            if (this.getMinutesPerPixel() < 0.05) {
                lat = this.findLat(mp, this.getCentre().getLatitude());
                if (lat == -1000.0) {
                    System.out.println("lat: " + lat);
                }
            } else {
                lat = this.findLat(mp, 0.0, 85.0);
            }
            double d = lon = p.getX() < (double)this.xCentre ? this.centre.getLongitude() - lonDistanceInDegrees : this.centre.getLongitude() + lonDistanceInDegrees;
            if (p.getY() > pixelCentre.getY()) {
                lat = -1.0 * lat;
            }
            if (lat == -1000.0 || lon == -1000.0) {
                return pos;
            }
            pos = new Position(lat, lon);
        }
        catch (InvalidPositionException ipe) {
            ipe.printStackTrace();
        }
        return pos;
    }

    private double distance(double a, double b) {
        return Math.abs(a - b);
    }

    public void setCentre(Point p) {
        try {
            Position newCentre = this.toPosition(p);
            if (newCentre != null) {
                this.centre = newCentre;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setXCentre(int xCentre) {
        this.xCentre = xCentre;
    }

    public void setYCentre(int yCentre) {
        this.yCentre = yCentre;
    }

    public Point getPixelCentre() {
        return new Point(this.xCentre, this.yCentre);
    }

    public Position getCentre() {
        return this.centre;
    }

    private double findLat(double mp, double low, double high) {
        DecimalFormat form = new DecimalFormat("#.####");
        mp = Math.round(mp);
        double midLat = (low + high) / 2.0;
        double guessMP = NavCalculator.computeDMPClarkeSpheroid(0.0, (float)midLat);
        while (low <= high) {
            if (guessMP == mp) {
                return midLat;
            }
            if (guessMP > mp) {
                high = midLat - 1.0E-4;
            } else {
                low = midLat + 1.0E-4;
            }
            midLat = Double.valueOf(form.format((low + high) / 2.0));
            guessMP = NavCalculator.computeDMPClarkeSpheroid(0.0, (float)midLat);
            guessMP = Math.round(guessMP);
        }
        return -1000.0;
    }

    private double findLat(double mp, double previousLat) {
        DecimalFormat form = new DecimalFormat("#.#####");
        mp = Double.parseDouble(form.format(mp));
        for (double lat = previousLat - 0.25; lat < previousLat + 1.0; lat += 1.0E-5) {
            double guessMP = NavCalculator.computeDMPClarkeSpheroid(0.0, lat);
            if ((guessMP = Double.parseDouble(form.format(guessMP))) != mp && !(Math.abs(guessMP - mp) < 0.001)) continue;
            return lat;
        }
        return -1000.0;
    }
}

