/*
 * Decompiled with CFR 0.152.
 */
package jme3tools.optimize;

import com.jme3.bounding.BoundingSphere;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LodGenerator {
    private static final Logger logger = Logger.getLogger(LodGenerator.class.getName());
    private static final float NEVER_COLLAPSE_COST = Float.MAX_VALUE;
    private static final float UNINITIALIZED_COLLAPSE_COST = Float.POSITIVE_INFINITY;
    private Vector3f tmpV1 = new Vector3f();
    private Vector3f tmpV2 = new Vector3f();
    private boolean bestQuality = true;
    private int indexCount = 0;
    private List<Vertex> collapseCostSet = new ArrayList<Vertex>();
    private float collapseCostLimit;
    private List<Triangle> triangleList;
    private List<Vertex> vertexList = new ArrayList<Vertex>();
    private float meshBoundingSphereRadius;
    private Mesh mesh;
    private Comparator collapseComparator = new Comparator<Vertex>(){

        @Override
        public int compare(Vertex o1, Vertex o2) {
            if (Float.compare(o1.collapseCost, o2.collapseCost) == 0) {
                return 0;
            }
            if (o1.collapseCost < o2.collapseCost) {
                return -1;
            }
            return 1;
        }
    };
    int nbCollapsedTri = 0;

    public LodGenerator(Geometry geom) {
        this.mesh = geom.getMesh();
        this.build();
    }

    private void build() {
        BoundingSphere bs = new BoundingSphere();
        bs.computeFromPoints(this.mesh.getFloatBuffer(VertexBuffer.Type.Position));
        this.meshBoundingSphereRadius = bs.getRadius();
        ArrayList<Vertex> vertexLookup = new ArrayList<Vertex>();
        this.initialize();
        this.gatherVertexData(this.mesh, vertexLookup);
        this.gatherIndexData(this.mesh, vertexLookup);
        this.computeCosts();
    }

    private void gatherVertexData(Mesh mesh, List<Vertex> vertexLookup) {
        VertexBuffer position = mesh.getBuffer(VertexBuffer.Type.BindPosePosition);
        if (position == null) {
            position = mesh.getBuffer(VertexBuffer.Type.Position);
        }
        FloatBuffer pos = (FloatBuffer)position.getDataReadOnly();
        pos.rewind();
        while (pos.remaining() != 0) {
            Vertex v = new Vertex();
            v.position.setX(pos.get());
            v.position.setY(pos.get());
            v.position.setZ(pos.get());
            v.isSeam = false;
            Vertex existingV = this.findSimilar(v);
            if (existingV != null) {
                existingV.isSeam = true;
                v.isSeam = true;
            } else {
                this.vertexList.add(v);
            }
            vertexLookup.add(v);
        }
        pos.rewind();
    }

    private Vertex findSimilar(Vertex v) {
        for (Vertex vertex : this.vertexList) {
            if (!vertex.position.equals(v.position)) continue;
            return vertex;
        }
        return null;
    }

    private void gatherIndexData(Mesh mesh, List<Vertex> vertexLookup) {
        VertexBuffer indexBuffer = mesh.getBuffer(VertexBuffer.Type.Index);
        this.indexCount = indexBuffer.getNumElements() * 3;
        Buffer b = indexBuffer.getDataReadOnly();
        b.rewind();
        while (b.remaining() != 0) {
            Triangle tri = new Triangle();
            tri.isRemoved = false;
            this.triangleList.add(tri);
            for (int i = 0; i < 3; ++i) {
                tri.vertexId[i] = b instanceof IntBuffer ? ((IntBuffer)b).get() : (int)((ShortBuffer)b).get();
                tri.vertex[i] = vertexLookup.get(tri.vertexId[i]);
                tri.vertex[i].index = tri.vertexId[i];
            }
            if (tri.isMalformed()) {
                if (tri.isRemoved) continue;
                logger.log(Level.FINE, "malformed triangle found with ID:{0}\n{1} It will be excluded from Lod level calculations.", new Object[]{this.triangleList.indexOf(tri), tri.toString()});
                tri.isRemoved = true;
                this.indexCount -= 3;
                continue;
            }
            tri.computeNormal();
            this.addTriangleToEdges(tri);
        }
        b.rewind();
    }

    private void computeCosts() {
        this.collapseCostSet.clear();
        for (Vertex vertex : this.vertexList) {
            if (!vertex.edges.isEmpty()) {
                this.computeVertexCollapseCost(vertex);
                continue;
            }
            logger.log(Level.FINE, "Found isolated vertex {0} It will be excluded from Lod level calculations.", vertex);
        }
    }

    private boolean checkCosts() {
        for (Vertex vertex : this.vertexList) {
            boolean test = this.find(this.collapseCostSet, vertex);
            if (test) continue;
            System.out.println("vertex " + vertex.index + " not present in collapse costs");
            return false;
        }
        return true;
    }

    private void computeVertexCollapseCost(Vertex vertex) {
        vertex.collapseCost = Float.POSITIVE_INFINITY;
        for (Edge edge : vertex.edges) {
            edge.collapseCost = this.computeEdgeCollapseCost(vertex, edge);
            if (!(vertex.collapseCost > edge.collapseCost)) continue;
            vertex.collapseCost = edge.collapseCost;
            vertex.collapseTo = edge.destination;
        }
        this.collapseCostSet.add(vertex);
    }

    float computeEdgeCollapseCost(Vertex src, Edge dstEdge) {
        float cost;
        Vertex dest = dstEdge.destination;
        if (src.triangles.size() == 1 && dest.triangles.size() == 1) {
            return Float.MAX_VALUE;
        }
        for (Triangle triangle : src.triangles) {
            if (triangle.hasVertex(dest)) continue;
            Vertex pv0 = triangle.vertex[0] == src ? dest : triangle.vertex[0];
            Vertex pv1 = triangle.vertex[1] == src ? dest : triangle.vertex[1];
            Vertex pv2 = triangle.vertex[2] == src ? dest : triangle.vertex[2];
            this.tmpV1.set(pv1.position).subtractLocal(pv0.position);
            this.tmpV2.set(pv2.position).subtractLocal(pv1.position);
            Vector3f newNormal = this.tmpV1.crossLocal(this.tmpV2);
            newNormal.normalizeLocal();
            if (!(newNormal.dot(triangle.normal) < 0.0f)) continue;
            return Float.MAX_VALUE;
        }
        if (this.isBorderVertex(src)) {
            if (dstEdge.refCount > 1) {
                cost = 1.0f;
            } else {
                cost = 0.0f;
                Vector3f collapseEdge = this.tmpV1.set(src.position).subtractLocal(dest.position);
                collapseEdge.normalizeLocal();
                for (Edge edge : src.edges) {
                    Vertex neighbor = edge.destination;
                    if (neighbor == dest || edge.refCount != 1) continue;
                    Vector3f otherBorderEdge = this.tmpV2.set(src.position).subtractLocal(neighbor.position);
                    otherBorderEdge.normalizeLocal();
                    float kinkiness = (otherBorderEdge.dot(collapseEdge) + 1.002f) * 0.5f;
                    cost = Math.max(cost, kinkiness);
                }
            }
        } else {
            cost = 0.001f;
            for (Triangle triangle : src.triangles) {
                float mincurv = 1.0f;
                for (Triangle triangle2 : src.triangles) {
                    if (!triangle2.hasVertex(dest)) continue;
                    float dotprod = triangle.normal.dot(triangle2.normal);
                    mincurv = Math.min(mincurv, (1.002f - dotprod) * 0.5f);
                }
                cost = Math.max(cost, mincurv);
            }
        }
        if (src.isSeam) {
            cost = !dest.isSeam ? (cost += this.meshBoundingSphereRadius) : (float)((double)cost + (double)this.meshBoundingSphereRadius * 0.5);
        }
        return cost * src.position.distanceSquared(dest.position);
    }

    public VertexBuffer[] computeLods(TriangleReductionMethod reductionMethod, float ... reductionValues) {
        int tricount;
        int lastBakeVertexCount = tricount = this.triangleList.size();
        int lodCount = reductionValues.length;
        VertexBuffer[] lods = new VertexBuffer[lodCount + 1];
        int numBakedLods = 1;
        lods[0] = this.mesh.getBuffer(VertexBuffer.Type.Index);
        for (int curLod = 0; curLod < lodCount; ++curLod) {
            boolean outSkipped;
            int neededTriCount = this.calcLodTriCount(reductionMethod, reductionValues[curLod]);
            while (neededTriCount < tricount) {
                Iterator<Vertex> it2;
                Collections.sort(this.collapseCostSet, this.collapseComparator);
                Iterator<Vertex> it = this.collapseCostSet.iterator();
                if (!it.hasNext()) break;
                Vertex v = it.next();
                if (!(v.collapseCost < this.collapseCostLimit)) break;
                if (!this.collapse(v)) {
                    logger.log(Level.FINE, "Couldn''t collapse vertex{0}", v.index);
                }
                if ((it2 = this.collapseCostSet.iterator()).hasNext()) {
                    it2.next();
                    it2.remove();
                }
                tricount = this.triangleList.size() - this.nbCollapsedTri;
            }
            logger.log(Level.FINE, "collapsed {0} tris", this.nbCollapsedTri);
            boolean bl = outSkipped = lastBakeVertexCount == tricount;
            if (outSkipped) continue;
            lastBakeVertexCount = tricount;
            lods[curLod + 1] = this.makeLod(this.mesh);
            ++numBakedLods;
        }
        if (numBakedLods <= lodCount) {
            VertexBuffer[] bakedLods = new VertexBuffer[numBakedLods];
            System.arraycopy(lods, 0, bakedLods, 0, numBakedLods);
            return bakedLods;
        }
        return lods;
    }

    public void bakeLods(TriangleReductionMethod reductionMethod, float ... reductionValues) {
        this.mesh.setLodLevels(this.computeLods(reductionMethod, reductionValues));
    }

    private VertexBuffer makeLod(Mesh mesh) {
        int bufsize;
        VertexBuffer indexBuffer = mesh.getBuffer(VertexBuffer.Type.Index);
        boolean isShortBuffer = indexBuffer.getFormat() == VertexBuffer.Format.UnsignedShort;
        VertexBuffer lodBuffer = new VertexBuffer(VertexBuffer.Type.Index);
        int n = bufsize = this.indexCount == 0 ? 3 : this.indexCount;
        if (isShortBuffer) {
            lodBuffer.setupData(VertexBuffer.Usage.Static, 3, VertexBuffer.Format.UnsignedShort, BufferUtils.createShortBuffer(bufsize));
        } else {
            lodBuffer.setupData(VertexBuffer.Usage.Static, 3, VertexBuffer.Format.UnsignedInt, BufferUtils.createIntBuffer(bufsize));
        }
        lodBuffer.getData().rewind();
        if (this.indexCount == 0) {
            int m;
            if (isShortBuffer) {
                for (m = 0; m < 3; ++m) {
                    ((ShortBuffer)lodBuffer.getData()).put((short)0);
                }
            } else {
                for (m = 0; m < 3; ++m) {
                    ((IntBuffer)lodBuffer.getData()).put(0);
                }
            }
        }
        Buffer buf = lodBuffer.getData();
        buf.rewind();
        for (Triangle triangle : this.triangleList) {
            int m;
            if (triangle.isRemoved) continue;
            if (isShortBuffer) {
                for (m = 0; m < 3; ++m) {
                    ((ShortBuffer)buf).put((short)triangle.vertexId[m]);
                }
                continue;
            }
            for (m = 0; m < 3; ++m) {
                ((IntBuffer)buf).put(triangle.vertexId[m]);
            }
        }
        buf.clear();
        lodBuffer.updateData(buf);
        return lodBuffer;
    }

    private int calcLodTriCount(TriangleReductionMethod reductionMethod, float reductionValue) {
        int nbTris = this.mesh.getTriangleCount();
        switch (reductionMethod) {
            case PROPORTIONAL: {
                this.collapseCostLimit = Float.MAX_VALUE;
                return (int)((float)nbTris - (float)nbTris * reductionValue);
            }
            case CONSTANT: {
                this.collapseCostLimit = Float.MAX_VALUE;
                if (reductionValue < (float)nbTris) {
                    return nbTris - (int)reductionValue;
                }
                return 0;
            }
            case COLLAPSE_COST: {
                this.collapseCostLimit = reductionValue;
                return 0;
            }
        }
        return nbTris;
    }

    private int findDstID(int srcId, List<CollapsedEdge> tmpCollapsedEdges) {
        int i = 0;
        for (CollapsedEdge collapsedEdge : tmpCollapsedEdges) {
            if (collapsedEdge.srcID == srcId) {
                return i;
            }
            ++i;
        }
        return Integer.MAX_VALUE;
    }

    private void removeTriangleFromEdges(Triangle triangle, Vertex skip) {
        int i;
        for (i = 0; i < 3; ++i) {
            if (triangle.vertex[i] == skip) continue;
            triangle.vertex[i].triangles.remove(triangle);
        }
        for (i = 0; i < 3; ++i) {
            for (int n = 0; n < 3; ++n) {
                if (i == n) continue;
                this.removeEdge(triangle.vertex[i], new Edge(triangle.vertex[n]));
            }
        }
    }

    private void removeEdge(Vertex v, Edge edge) {
        Edge ed = null;
        for (Edge edge1 : v.edges) {
            if (!edge1.equals(edge)) continue;
            ed = edge1;
            break;
        }
        if (ed.refCount == 1) {
            v.edges.remove(ed);
        } else {
            --ed.refCount;
        }
    }

    boolean isBorderVertex(Vertex vertex) {
        for (Edge edge : vertex.edges) {
            if (edge.refCount != 1) continue;
            return true;
        }
        return false;
    }

    private void addTriangleToEdges(Triangle tri) {
        int i;
        Triangle duplicate;
        if (this.bestQuality && (duplicate = this.getDuplicate(tri)) != null && !tri.isRemoved) {
            tri.isRemoved = true;
            this.indexCount -= 3;
            logger.log(Level.FINE, "duplicate triangle found{0}{1} It will be excluded from Lod level calculations.", new Object[]{tri, duplicate});
        }
        for (i = 0; i < 3; ++i) {
            tri.vertex[i].triangles.add(tri);
        }
        for (i = 0; i < 3; ++i) {
            for (int n = 0; n < 3; ++n) {
                if (i == n) continue;
                this.addEdge(tri.vertex[i], new Edge(tri.vertex[n]));
            }
        }
    }

    private void addEdge(Vertex v, Edge edge) {
        for (Edge ed : v.edges) {
            if (!ed.equals(edge)) continue;
            ++ed.refCount;
            return;
        }
        v.edges.add(edge);
        edge.refCount = 1;
    }

    private void initialize() {
        this.triangleList = new ArrayList<Triangle>();
    }

    private Triangle getDuplicate(Triangle triangle) {
        for (Triangle tri : triangle.vertex[0].triangles) {
            if (!this.isDuplicateTriangle(triangle, tri)) continue;
            return tri;
        }
        return null;
    }

    private boolean isDuplicateTriangle(Triangle triangle, Triangle triangle2) {
        for (int i = 0; i < 3; ++i) {
            if (triangle.vertex[i] == triangle2.vertex[0] && triangle.vertex[i] == triangle2.vertex[1] && triangle.vertex[i] == triangle2.vertex[2]) continue;
            return false;
        }
        return true;
    }

    private void replaceVertexID(Triangle triangle, int oldID, int newID, Vertex dst) {
        dst.triangles.add(triangle);
        for (int i = 0; i < 3; ++i) {
            if (triangle.vertexId[i] != oldID) continue;
            for (int n = 0; n < 3; ++n) {
                if (i == n) continue;
                this.removeEdge(triangle.vertex[n], new Edge(triangle.vertex[i]));
                this.addEdge(triangle.vertex[n], new Edge(dst));
                this.addEdge(dst, new Edge(triangle.vertex[n]));
            }
            triangle.vertex[i] = dst;
            triangle.vertexId[i] = newID;
            return;
        }
    }

    private void updateVertexCollapseCost(Vertex vertex) {
        float collapseCost = Float.POSITIVE_INFINITY;
        Vertex collapseTo = null;
        for (Edge edge : vertex.edges) {
            edge.collapseCost = this.computeEdgeCollapseCost(vertex, edge);
            if (!(collapseCost > edge.collapseCost)) continue;
            collapseCost = edge.collapseCost;
            collapseTo = edge.destination;
        }
        if (collapseCost != vertex.collapseCost || vertex.collapseTo != collapseTo) {
            this.collapseCostSet.remove(vertex);
            if (collapseCost != Float.POSITIVE_INFINITY) {
                vertex.collapseCost = collapseCost;
                vertex.collapseTo = collapseTo;
                this.collapseCostSet.add(vertex);
            }
        }
    }

    private boolean hasSrcID(int srcID, List<CollapsedEdge> cEdges) {
        for (CollapsedEdge collapsedEdge : cEdges) {
            if (collapsedEdge.srcID != srcID) continue;
            return true;
        }
        return false;
    }

    private boolean collapse(Vertex src) {
        int srcID;
        Triangle triangle;
        Vertex dest = src.collapseTo;
        if (src.edges.isEmpty()) {
            return false;
        }
        ArrayList<CollapsedEdge> tmpCollapsedEdges = new ArrayList<CollapsedEdge>();
        Iterator<Triangle> it = src.triangles.iterator();
        while (it.hasNext()) {
            triangle = it.next();
            if (!triangle.hasVertex(dest)) continue;
            srcID = triangle.getVertexIndex(src);
            if (!this.hasSrcID(srcID, tmpCollapsedEdges)) {
                CollapsedEdge cEdge = new CollapsedEdge();
                cEdge.srcID = srcID;
                cEdge.dstID = triangle.getVertexIndex(dest);
                tmpCollapsedEdges.add(cEdge);
            }
            this.indexCount -= 3;
            triangle.isRemoved = true;
            ++this.nbCollapsedTri;
            this.removeTriangleFromEdges(triangle, src);
            it.remove();
        }
        it = src.triangles.iterator();
        while (it.hasNext()) {
            triangle = it.next();
            if (triangle.hasVertex(dest)) continue;
            srcID = triangle.getVertexIndex(src);
            int id = this.findDstID(srcID, tmpCollapsedEdges);
            if (id == Integer.MAX_VALUE) {
                triangle.isRemoved = true;
                this.indexCount -= 3;
                this.removeTriangleFromEdges(triangle, src);
                it.remove();
                ++this.nbCollapsedTri;
                continue;
            }
            int dstID = ((CollapsedEdge)tmpCollapsedEdges.get((int)id)).dstID;
            this.replaceVertexID(triangle, srcID, dstID, dest);
            if (!this.bestQuality) continue;
            triangle.computeNormal();
        }
        if (this.bestQuality) {
            for (Edge edge : src.edges) {
                this.updateVertexCollapseCost(edge.destination);
            }
            this.updateVertexCollapseCost(dest);
            for (Edge edge : dest.edges) {
                this.updateVertexCollapseCost(edge.destination);
            }
        } else {
            TreeSet<Vertex> updatable = new TreeSet<Vertex>(this.collapseComparator);
            for (Edge edge : src.edges) {
                updatable.add(edge.destination);
                for (Edge edge1 : edge.destination.edges) {
                    updatable.add(edge1.destination);
                }
            }
            for (Vertex vertex : updatable) {
                this.updateVertexCollapseCost(vertex);
            }
        }
        return true;
    }

    private boolean assertValidMesh() {
        for (Vertex vertex : this.collapseCostSet) {
            this.assertValidVertex(vertex);
        }
        return true;
    }

    private boolean assertValidVertex(Vertex v) {
        for (Triangle t : v.triangles) {
            for (int i = 0; i < 3; ++i) {
                assert (this.find(this.collapseCostSet, t.vertex[i]));
                assert (t.vertex[i].edges.contains(new Edge(t.vertex[i].collapseTo)));
                for (int n = 0; n < 3; ++n) {
                    if (i != n) {
                        int id = t.vertex[i].edges.indexOf(new Edge(t.vertex[n]));
                        Edge ed = t.vertex[i].edges.get(id);
                        continue;
                    }
                    assert (!t.vertex[i].edges.contains(new Edge(t.vertex[n])));
                }
            }
        }
        return true;
    }

    private boolean find(List<Vertex> set, Vertex v) {
        for (Vertex vertex : set) {
            if (v != vertex) continue;
            return true;
        }
        return false;
    }

    private class CollapsedEdge {
        int srcID;
        int dstID;

        private CollapsedEdge() {
        }
    }

    private class Triangle {
        Vertex[] vertex = new Vertex[3];
        Vector3f normal;
        boolean isRemoved;
        int[] vertexId = new int[3];

        private Triangle() {
        }

        void computeNormal() {
            LodGenerator.this.tmpV1.set(this.vertex[1].position).subtractLocal(this.vertex[0].position);
            LodGenerator.this.tmpV2.set(this.vertex[2].position).subtractLocal(this.vertex[1].position);
            this.normal = LodGenerator.this.tmpV1.cross(LodGenerator.this.tmpV2);
            this.normal.normalizeLocal();
        }

        boolean hasVertex(Vertex v) {
            return v == this.vertex[0] || v == this.vertex[1] || v == this.vertex[2];
        }

        int getVertexIndex(Vertex v) {
            for (int i = 0; i < 3; ++i) {
                if (this.vertex[i] != v) continue;
                return this.vertexId[i];
            }
            throw new IllegalArgumentException("Vertex " + v + "is not part of triangle" + this);
        }

        boolean isMalformed() {
            return this.vertex[0] == this.vertex[1] || this.vertex[0] == this.vertex[2] || this.vertex[1] == this.vertex[2];
        }

        public String toString() {
            String out = "Triangle{\n";
            for (int i = 0; i < 3; ++i) {
                out = out + this.vertexId[i] + " : " + this.vertex[i].toString() + "\n";
            }
            out = out + '}';
            return out;
        }
    }

    private class Vertex {
        Vector3f position = new Vector3f();
        float collapseCost = Float.POSITIVE_INFINITY;
        List<Edge> edges = new ArrayList<Edge>();
        Set<Triangle> triangles = new HashSet<Triangle>();
        Vertex collapseTo;
        boolean isSeam;
        int index;

        private Vertex() {
        }

        public String toString() {
            return this.index + " : " + this.position.toString();
        }
    }

    private class Edge {
        Vertex destination;
        float collapseCost = Float.POSITIVE_INFINITY;
        int refCount;

        public Edge(Vertex destination) {
            this.destination = destination;
        }

        public void set(Edge other) {
            this.destination = other.destination;
            this.collapseCost = other.collapseCost;
            this.refCount = other.refCount;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Edge)) {
                return false;
            }
            return this.destination == ((Edge)obj).destination;
        }

        public int hashCode() {
            return this.destination.hashCode();
        }

        public String toString() {
            return "Edge{collapsTo " + this.destination.index + '}';
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TriangleReductionMethod {
        PROPORTIONAL,
        CONSTANT,
        COLLAPSE_COST;

    }
}

