/*
 * Decompiled with CFR 0.152.
 */
package jme3tools.shadercheck;

import com.jme3.shader.Shader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3tools.shadercheck.Validator;

public class CgcValidator
implements Validator {
    private static final Logger logger = Logger.getLogger(CgcValidator.class.getName());
    private static String version;

    private static String checkCgCompilerVersion() {
        try {
            ProcessBuilder pb = new ProcessBuilder("cgc", "--version");
            Process p = pb.start();
            Scanner scan = new Scanner(p.getErrorStream());
            String ln = scan.nextLine();
            scan.close();
            p.waitFor();
            String versionNumber = ln.split("\\s")[2];
            return versionNumber.substring(0, versionNumber.length() - 1);
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "IOEx", ex);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return null;
    }

    public String getName() {
        return "NVIDIA Cg Toolkit";
    }

    public boolean isInstalled() {
        return this.getInstalledVersion() != null;
    }

    public String getInstalledVersion() {
        if (version == null) {
            version = CgcValidator.checkCgCompilerVersion();
        }
        return version;
    }

    private static void executeCg(String sourceCode, String language, String defines, String profile, StringBuilder output) {
        try {
            ProcessBuilder pb = new ProcessBuilder("cgc", "-oglsl", "-nocode", "-strict", "-glslWerror", "-profile", profile, "-po", "NumTemps=32", "-po", "MaxLocalParams=32");
            Process p = pb.start();
            String glslVer = language.substring(4);
            OutputStreamWriter writer = new OutputStreamWriter(p.getOutputStream());
            writer.append("#version ").append(glslVer).append('\n');
            writer.append("#extension all : warn").append('\n');
            writer.append(defines).append('\n');
            writer.write(sourceCode);
            writer.close();
            Scanner scan = new Scanner(p.getErrorStream());
            String ln = scan.nextLine();
            if (ln.contains("0 errors")) {
                output.append(" - Success!").append('\n');
            } else {
                output.append(" - Failure!").append('\n');
                output.append(ln).append('\n');
                while (scan.hasNextLine()) {
                    output.append(scan.nextLine()).append('\n');
                }
            }
            scan.close();
            p.waitFor();
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "IOEx", ex);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
    }

    public void validate(Shader shader, StringBuilder results) {
        for (Shader.ShaderSource source : shader.getSources()) {
            results.append("Checking: ").append(source.getName());
            switch (source.getType()) {
                case Fragment: {
                    CgcValidator.executeCg(source.getSource(), source.getLanguage(), source.getDefines(), "arbfp1", results);
                    break;
                }
                case Vertex: {
                    CgcValidator.executeCg(source.getSource(), source.getLanguage(), source.getDefines(), "arbvp1", results);
                }
            }
        }
    }
}

