/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.model.test;

import com.jme3.system.AppSettings;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileFilter;
import org.friendularity.model.test.ModelViewer;

public class ModelPathDialog
extends JDialog {
    static File lastDir;
    private JFileChooser jFileChooser1;
    private JLabel jLabel1;
    private JPanel jPanel1;

    public ModelPathDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        if (lastDir != null) {
            this.jFileChooser1.setCurrentDirectory(lastDir);
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jFileChooser1 = new JFileChooser();
        this.setDefaultCloseOperation(2);
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel1.setFont(new Font("Tahoma", 0, 30));
        this.jLabel1.setText("Select the mesh.xml file of the model you wish to test:");
        this.jFileChooser1.setAcceptAllFileFilterUsed(false);
        this.jFileChooser1.setCurrentDirectory(new File("C:\\"));
        this.jFileChooser1.setFileFilter(new MeshXmlFilter());
        this.jFileChooser1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModelPathDialog.this.jFileChooser1ActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jFileChooser1, -2, 721, -2).addGap(0, 0, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.jLabel1).addGap(18, 18, 18).addComponent(this.jFileChooser1, -2, -1, -2)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -2, -1, -2));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -2, -1, -2));
        this.pack();
    }

    private void jFileChooser1ActionPerformed(ActionEvent evt) {
        String command = evt.getActionCommand();
        if (command.equals("ApproveSelection")) {
            File desiredFile;
            lastDir = desiredFile = this.jFileChooser1.getSelectedFile();
            final ModelViewer app = new ModelViewer(desiredFile);
            app.setShowSettings(false);
            AppSettings settings = new AppSettings(true);
            settings.setResolution(800, 600);
            settings.setBitsPerPixel(32);
            app.setSettings(settings);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    app.start();
                }
            }).start();
            this.dispose();
        } else if (command.equals("CancelSelection")) {
            System.exit(0);
        }
    }

    public static void start(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(ModelPathDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(ModelPathDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(ModelPathDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(ModelPathDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ModelPathDialog dialog = new ModelPathDialog((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    static class MeshXmlFilter
    extends FileFilter {
        static final String MESH_XML_SUFFIX = "mesh.xml";
        static final String DESCRIPTION = "mesh.xml files";

        MeshXmlFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || f.getName().endsWith(MESH_XML_SUFFIX);
        }

        @Override
        public String getDescription() {
            return DESCRIPTION;
        }
    }
}

