/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.model.test;

import com.jme3.app.SimpleApplication;
import com.jme3.asset.plugins.FileLocator;
import com.jme3.font.BitmapText;
import com.jme3.light.DirectionalLight;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.Spatial;
import java.io.File;
import org.friendularity.model.test.ModelPathDialog;

public class ModelViewer
extends SimpleApplication {
    private static final String HUD_MESSAGE = "Use Mouse and W, A, S, D to move camera.\nPress Esc to exit and load new model.";
    private String modelPath;
    private File modelFile;

    ModelViewer(File file) {
        this.modelFile = file;
    }

    @Override
    public void simpleInitApp() {
        this.setDisplayFps(false);
        this.flyCam.setMoveSpeed(50.0f);
        this.cam.setLocation(new Vector3f(0.0f, 30.0f, 60.0f));
        this.cam.lookAtDirection(new Vector3f(0.0f, -0.17f, -1.0f), Vector3f.UNIT_Y);
        this.viewPort.setBackgroundColor(ColorRGBA.LightGray);
        this.assetManager.registerLocator(this.modelFile.getParent(), FileLocator.class);
        Spatial testModel = this.assetManager.loadModel(this.modelFile.getName());
        this.rootNode.attachChild(testModel);
        DirectionalLight sun = new DirectionalLight();
        sun.setDirection(new Vector3f(0.0f, -0.7f, -1.0f));
        this.rootNode.addLight(sun);
        DirectionalLight sun2 = new DirectionalLight();
        sun2.setDirection(new Vector3f(0.0f, -0.7f, 1.0f));
        this.rootNode.addLight(sun2);
        DirectionalLight sun3 = new DirectionalLight();
        sun3.setDirection(new Vector3f(1.0f, -0.7f, 0.0f));
        this.rootNode.addLight(sun3);
        DirectionalLight sun4 = new DirectionalLight();
        sun4.setDirection(new Vector3f(-1.0f, -0.7f, 0.0f));
        this.rootNode.addLight(sun4);
        BitmapText infoText = new BitmapText(this.guiFont);
        infoText.setSize(20.0f);
        infoText.setColor(ColorRGBA.Black);
        infoText.setText(HUD_MESSAGE);
        infoText.setLocalTranslation(425.0f, infoText.getLineHeight() * 2.0f, 0.0f);
        this.guiNode.attachChild(infoText);
    }

    @Override
    public void destroy() {
        super.destroy();
        ModelPathDialog.start(null);
    }
}

