/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.test.audio.r50;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import org.apache.avro.generic.IndexedRecord;
import org.jflux.impl.messaging.rk.JMSAvroRecordSender;
import org.jflux.impl.messaging.rk.JMSBytesMessageSender;
import org.jflux.impl.messaging.rk.utils.ConnectionManager;
import org.jflux.impl.messaging.rk.utils.ConnectionUtils;
import org.mechio.impl.audio.config.WavPlayerConfigRecord;

public class WavDemo {
    private static Connection theConnection;
    private static Session theSession;
    private static Destination theDestination;

    public static void main(String[] args) {
        String wavPath = "/path/to/wav/on/robot.wav";
        String ipAddress = "127.0.0.1";
        WavPlayerConfigRecord config = WavDemo.configureStart(wavPath);
        WavDemo.connect(ipAddress);
        JMSAvroRecordSender<WavPlayerConfigRecord> sender = WavDemo.makeSender();
        sender.sendRecord((IndexedRecord)config);
        WavDemo.disconnect();
    }

    private static WavPlayerConfigRecord configureStart(String wavPath) {
        WavPlayerConfigRecord.Builder builder = WavPlayerConfigRecord.newBuilder();
        builder.setWavLocation(wavPath);
        builder.setWavPlayerId("testPlayer_start");
        builder.setStartDelayMillisec(0L);
        builder.setStartTimeMicrosec(0L);
        builder.setStopTimeMicrosec(0L);
        return builder.build();
    }

    private static WavPlayerConfigRecord configureStop(String wavPath) {
        WavPlayerConfigRecord.Builder builder = WavPlayerConfigRecord.newBuilder();
        builder.setWavLocation(wavPath);
        builder.setWavPlayerId("testPlayer_stop");
        builder.setStartDelayMillisec(0L);
        builder.setStartTimeMicrosec(0L);
        builder.setStopTimeMicrosec(0L);
        return builder.build();
    }

    private static void connect(String ipAddress) {
        String destString = "wavPlayerEvent; {create: always, node: {type: topic}}";
        try {
            theConnection = ConnectionManager.createConnection((String)ConnectionUtils.getUsername(), (String)ConnectionUtils.getPassword(), (String)"client1", (String)"test", (String)("tcp://" + ipAddress + ":5672"));
            theDestination = ConnectionManager.createDestination((String)destString);
            try {
                theSession = theConnection.createSession(false, 2);
                theConnection.start();
            }
            catch (JMSException ex) {
                System.out.println("Unable to create Session: " + ex.getMessage());
            }
        }
        catch (Exception e) {
            System.out.println("Connection error: " + e.getMessage());
            WavDemo.disconnect();
        }
    }

    private static void disconnect() {
        if (theSession != null) {
            try {
                theSession.close();
            }
            catch (JMSException ex) {
                // empty catch block
            }
        }
        if (theConnection != null) {
            try {
                theConnection.close();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
        theConnection = null;
        theDestination = null;
        theSession = null;
    }

    private static JMSAvroRecordSender<WavPlayerConfigRecord> makeSender() {
        JMSBytesMessageSender msgSender = new JMSBytesMessageSender();
        msgSender.setSession(theSession);
        msgSender.setDestination(theDestination);
        msgSender.openProducer();
        return new JMSAvroRecordSender(msgSender);
    }
}

