/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.test.sensors.r50;

import org.jflux.api.core.Listener;
import org.robokind.api.sensor.AccelerometerConfigEvent;
import org.robokind.api.sensor.CompassConfigEvent;
import org.robokind.api.sensor.DeviceBoolEvent;
import org.robokind.api.sensor.DeviceReadPeriodEvent;
import org.robokind.api.sensor.FilteredVector3Event;
import org.robokind.api.sensor.GyroConfigEvent;
import org.robokind.api.sensor.SensorEventHeader;
import org.robokind.api.sensor.Vector3Event;
import org.robokind.api.sensor.gpio.RemoteGpioServiceClient;
import org.robokind.api.sensor.imu.RemoteAccelerometerServiceClient;
import org.robokind.api.sensor.imu.RemoteCompassServiceClient;
import org.robokind.api.sensor.imu.RemoteGyroscopeServiceClient;
import org.robokind.client.basic.Robokind;
import org.robokind.client.basic.UserSettings;
import org.robokind.impl.sensor.AccelerometerConfigRecord;
import org.robokind.impl.sensor.CompassConfigRecord;
import org.robokind.impl.sensor.DeviceReadPeriodRecord;
import org.robokind.impl.sensor.GyroConfigRecord;
import org.robokind.impl.sensor.HeaderRecord;

public class App {
    public static void main(String[] args) {
        UserSettings.setRobotId((String)"myRobot");
        RemoteGpioServiceClient sensors = Robokind.connectSensors();
        DeviceReadPeriodRecord readPeriod = new DeviceReadPeriodRecord();
        HeaderRecord header = new HeaderRecord();
        System.out.println("Adding pin direction.");
        sensors.setPinDirection(2, true);
        sensors.setPinDirection(4, true);
        System.out.println("Adding read period.");
        header.setFrameId(Integer.valueOf(0));
        header.setSequenceId(Integer.valueOf(0));
        header.setTimestamp(Long.valueOf(0L));
        readPeriod.setHeader((SensorEventHeader)header);
        readPeriod.setPeriod(Double.valueOf(100.0));
        sensors.setReadPeriod((DeviceReadPeriodEvent)readPeriod);
        System.out.println("Adding listener.");
        sensors.addListener((Listener)new TestGpioListener());
        System.out.println("Adding IMU.");
        RemoteAccelerometerServiceClient accel = Robokind.connectAccelerometer();
        RemoteGyroscopeServiceClient gyro = Robokind.connectGyroscope();
        RemoteCompassServiceClient compass = Robokind.connectCompass();
        readPeriod.setPeriod(Double.valueOf(1000.0));
        accel.setReadPeriod((DeviceReadPeriodEvent)readPeriod);
        gyro.setReadPeriod((DeviceReadPeriodEvent)readPeriod);
        compass.setReadPeriod((DeviceReadPeriodEvent)readPeriod);
        AccelerometerConfigRecord accelConfig = new AccelerometerConfigRecord();
        GyroConfigRecord gyroConfig = new GyroConfigRecord();
        CompassConfigRecord compassConfig = new CompassConfigRecord();
        accelConfig.setHeader(header);
        gyroConfig.setHeader(header);
        compassConfig.setHeader(header);
        accelConfig.setRegisterAddress(Integer.valueOf(45));
        accelConfig.setRegisterValue(Integer.valueOf(8));
        gyroConfig.setCtl1(Integer.valueOf(15));
        gyroConfig.setCtl2(Integer.valueOf(-1));
        gyroConfig.setCtl3(Integer.valueOf(-1));
        gyroConfig.setCtl4(Integer.valueOf(-1));
        gyroConfig.setCtl5(Integer.valueOf(-1));
        compassConfig.setAverage(Integer.valueOf(3));
        compassConfig.setBias(Integer.valueOf(0));
        compassConfig.setGain(Integer.valueOf(7));
        compassConfig.setRate(Integer.valueOf(2));
        accel.sendConfig((AccelerometerConfigEvent)accelConfig);
        gyro.sendConfig((GyroConfigEvent)gyroConfig);
        compass.sendConfig((CompassConfigEvent)compassConfig);
        accel.addListener((Listener)new TestAccelListener());
        gyro.addListener((Listener)new TestGyroListener());
        compass.addListener((Listener)new TestCompassListener());
    }

    private static class TestCompassListener
    implements Listener<FilteredVector3Event> {
        private TestCompassListener() {
        }

        public void handleEvent(FilteredVector3Event t) {
            Vector3Event v = t.getFilteredVector();
            Vector3Event r = t.getRawVector();
            System.out.println("Compass (f): " + v.getX() + ", " + v.getY() + ", " + v.getZ());
            System.out.println("Compass (r): " + r.getX() + ", " + r.getY() + ", " + r.getZ());
        }
    }

    private static class TestGyroListener
    implements Listener<FilteredVector3Event> {
        private TestGyroListener() {
        }

        public void handleEvent(FilteredVector3Event t) {
            Vector3Event v = t.getFilteredVector();
            Vector3Event r = t.getRawVector();
            System.out.println("Gyroscope (f): " + v.getX() + ", " + v.getY() + ", " + v.getZ());
            System.out.println("Gyroscope (r): " + r.getX() + ", " + r.getY() + ", " + r.getZ());
        }
    }

    private static class TestAccelListener
    implements Listener<FilteredVector3Event> {
        private TestAccelListener() {
        }

        public void handleEvent(FilteredVector3Event t) {
            Vector3Event v = t.getFilteredVector();
            Vector3Event r = t.getRawVector();
            System.out.println("Accelerometer (f): " + v.getX() + ", " + v.getY() + ", " + v.getZ());
            System.out.println("Accelerometer (r): " + r.getX() + ", " + r.getY() + ", " + r.getZ());
        }
    }

    private static class TestGpioListener
    implements Listener<DeviceBoolEvent> {
        private TestGpioListener() {
        }

        public void handleEvent(DeviceBoolEvent t) {
            System.out.println(t.getChannelId() + ": " + (t.getBoolValue() != false ? "on" : "off"));
        }
    }
}

