<?xml version="1.0" encoding="UTF-8"?>
<!--
  #%L
  TeiLinguisticsFa
  %%
  Copyright (C) 2018 Fryske Akademy
  %%
  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at
  
       http://www.apache.org/licenses/LICENSE-2.0
  
  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
  #L%
  -->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" 
    xmlns:tei="http://www.tei-c.org/ns/1.0" version="1.0">

    <xsl:output indent="no" method="text" />

    <xsl:template match="/">
package org.fa.tei.jaxb.v2_0.docs;

<![CDATA[
    // GENERATED FILE!!!: USE FOR EXAMPLE "xsltproc OddToDocJava.xsl ../linguistic_attributes.odd > LinguisticDocs.java"
]]>
/**
  * @see org.fa.tei.jaxb.v2_0.Join
  */
public class LinguisticDocs {

    private LinguisticDocs() {}

    /**
      * @see org.fa.tei.jaxb.v2_0.Join
      */
    public static String getDocumentation(Enum linguistics) {
        String ling = linguistics.getDeclaringClass().getSimpleName()+"."+linguistics;
        switch(ling.toLowerCase()) {
        <xsl:for-each select="//tei:classSpec//tei:valItem">
            case "<xsl:value-of select="../../@ident"/>.<xsl:value-of select="@ident"/>":
                return "<xsl:value-of select="normalize-space(tei:desc/text())"/>";
</xsl:for-each>
            default:
                return "undocumented";
        }
    }
    
    /**
      * @see org.fa.tei.jaxb.v2_0.Join
      */
    public static String getCategoryDocumentation(Class linguistics) {
        String ling = linguistics.getSimpleName().toLowerCase();
        switch(ling) {
        <xsl:for-each select="//tei:classSpec//tei:attDef">
            case "<xsl:value-of select="@ident"/>":
                return "<xsl:value-of select="normalize-space(tei:desc/text())"/>";
</xsl:for-each>
            default:
                return "undocumented";
        }
    }
    
    /** @param ling use category.value (class.getSimpleName().enum.name())
      * @see org.fa.tei.jaxb.v2_0.Join
      */
    public static String getDocumentation(String ling) {
        switch(ling.toLowerCase()) {
        <xsl:for-each select="//tei:classSpec//tei:valItem">
            case "<xsl:value-of select="../../@ident"/>.<xsl:value-of select="@ident"/>":
                return "<xsl:value-of select="normalize-space(tei:desc/text())"/>";
        </xsl:for-each>
            default:
                return "undocumented";
        }
    }
    
    /** @param ling use category (class.getSimpleName())
      * @see org.fa.tei.jaxb.v2_0.Join
      */
    public static String getCategoryDocumentation(String ling) {
        switch(ling.toLowerCase()) {
<xsl:for-each select="//tei:classSpec//tei:attDef">
            case "<xsl:value-of select="@ident"/>":
                return "<xsl:value-of select="normalize-space(tei:desc/text())"/>";
</xsl:for-each>
            default:
                return "undocumented";
        }
    }
}            
    </xsl:template>

</xsl:stylesheet>
