<?xml version="1.0" encoding="UTF-8"?>
<!--
  #%L
  TeiLinguisticsFa
  %%
  Copyright (C) 2018 Fryske Akademy
  %%
  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at
  
       http://www.apache.org/licenses/LICENSE-2.0
  
  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
  #L%
  -->


<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:tei="http://www.tei-c.org/ns/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" version="1.0">

    <xsl:output method="text"/>

    <xsl:template match="/">

        <xsl:value-of select="'# GENERATED (xsltproc OddToBlacklabProperties.xsl ../linguistic_attributes.odd > fa-tei.blf.yml), ADAPT AS NEEDED'"/>
        <xsl:text><![CDATA[
namespaces:

  tei: "http://www.tei-c.org/ns/1.0"
  fa: "http://www.fryske-akademy.org/linguistics/2.0"

documentPath: /tei:TEI

annotatedFields:

  contents:
            
    containerPath: tei:text

    wordPath: .//tei:w
            
    punctPath: ".//text()[preceding-sibling::tei:w]|//tei:pc | //tei:lb"
    
    inlineTags:
    - path: .//tei:s
    - path: .//tei:p

    annotations:

    - name: word
      description: word forms in the text
      valuePath: "normalize-space(concat(text()[1],text()[2],text()[3]))"

    - name: lemma
      description: lemma (of word forms) in the text
      captureValuePaths:
      - "@xml:id"
      valuePath: "@lemma | following-sibling::tei:join[contains(concat(@target,' '),'#$1 ')]/@lemma"
      
        ]]>
</xsl:text>


      <xsl:for-each select="//tei:classSpec[@ident='att.features']//tei:attDef">
            <xsl:value-of select="'    - name: '"/>
            <xsl:value-of select="@ident"/>
        <xsl:text>
</xsl:text>
            <xsl:value-of select="'      captureValuePaths: '"/>
        <xsl:text>
</xsl:text>
            <xsl:value-of select="'      - &quot;@xml:id&quot;'"/>
        <xsl:text>
</xsl:text>
            <xsl:value-of select="'      valuePath: '"/>
            <xsl:value-of select="'&quot;@fa:'"/>
            <xsl:value-of select="@ident"/>
            <xsl:text><![CDATA[ | following-sibling::tei:join[contains(concat(@target,' '),'#$1 ')]/@fa:]]></xsl:text>
            <xsl:value-of select="@ident"/>
            <xsl:value-of select="'&quot;'"/><xsl:text>
</xsl:text>
            <xsl:value-of select="'      description: '"/>
            <xsl:value-of select="'&quot;'"/>
            <xsl:value-of select="normalize-space(tei:desc/text())"/>
            <xsl:value-of select="'&quot;'"/>
        <xsl:text>
</xsl:text>
            <xsl:value-of select="'      uiType: select'"/>
        <xsl:text>

</xsl:text>
            
        </xsl:for-each>
      <xsl:for-each select="//tei:classSpec[@ident='att.linguistic']//tei:attDef">
        <xsl:value-of select="'    - name: '"/>
        <xsl:value-of select="@ident"/>
        <xsl:text>
</xsl:text>
        <xsl:value-of select="'      captureValuePaths: '"/>
        <xsl:text>
</xsl:text>
        <xsl:value-of select="'      - &quot;@xml:id&quot;'"/>
        <xsl:text>
</xsl:text>
        <xsl:value-of select="'      valuePath: '"/>
        <xsl:value-of select="'&quot;@'"/>
        <xsl:value-of select="@ident"/>
        <xsl:text><![CDATA[ | following-sibling::tei:join[contains(concat(@target,' '),'#$1 ')]/@]]></xsl:text>
        <xsl:value-of select="@ident"/>
        <xsl:value-of select="'&quot;'"/><xsl:text>
</xsl:text>
        <xsl:value-of select="'      description: '"/>
        <xsl:value-of select="'&quot;'"/>
        <xsl:value-of select="normalize-space(tei:desc/text())"/>
        <xsl:value-of select="'&quot;'"/>
        <xsl:text>
</xsl:text>
        <xsl:value-of select="'      uiType: select'"/>
        <xsl:text>

</xsl:text>
        
      </xsl:for-each>
      <xsl:text><![CDATA[
metadata:

  containerPath: tei:teiHeader

  fields:

  - name: title
    valuePath: "tei:fileDesc/tei:titleStmt/tei:title"

  - name: author
    valuePath: "concat(tei:fileDesc/tei:titleStmt/tei:author//text(), ', (', tei:fileDesc/tei:titleStmt/tei:author/@key,')')"

  - name: year
    valuePath: "//tei:date[parent::tei:bibl or parent::tei:publicationStmt][1]/text()"
    uiType: range

  - name: state
    valuePath: "concat('tokenized: ', boolean(//tei:w[1]), ', lemmatized ', boolean(//tei:w[@lemma][1]), ', pos tagged: ', boolean(//tei:w[@fa:pos][1]) )"
    displayName: Document state

  - name: divisions
    valuePath: "concat('paragraphs: ', boolean(//tei:p[1]), ', sentences ', boolean(//tei:s[1]))"
    displayName: Divisions present

  - name: "language_variant"
    valuePath: "tei:profileDesc/tei:langUsage/tei:language/text()"
    displayName: Language Variant

# remove this for internal use where all material may be viewed, then generate new index!

  - name: contentViewable
    valuePath: string(//tei:availability[1]/@status='free')
    displayName: free material
    
corpusConfig:

  displayName: Frisian corpora

  description: annotated frisian texts, detail level of annotation varies, midfrysk is most complete and detailed

# optIn, set this to true for internal use

  contentViewable: false

  specialFields:
    dateField: year

  annotationGroups:
    contents:
    - name: Generic aspects
      annotations:
      - word
      - lemma
      - pos
    - name: Verb linguistics
      annotations:
      - tense
      - person
      - verbform
      - mood
      - aux
      - voice
      - valency
    - name: Noun linguistics
      annotations:
      - case
      - number
      - gender
      - degree
      - diminutive
    - name: Other linguistics
      addRemainingAnnotations: true

  metadataFieldGroups:
    - name: Main filters
      fields:
      - year
      - author
      - language_variant
      - state
    - name: Other filters
      addRemainingFields: true

]]>
</xsl:text>
    </xsl:template>

</xsl:stylesheet>
