/*
 * Decompiled with CFR 0.152.
 */
package org.fa.tei.jaxb.v2_0;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ValidationHelper {
    public static final String CLASSPATH_URI_LINGUISTICS_XSD = "classpath:/xsd/linguisticGroups.xsd";
    private static final Logger LOGGER = Logger.getLogger(ValidationHelper.class.getName());
    private static JAXBContext JAXBCONTEXT = null;
    private static Schema schema = null;
    public static final String TEINS = "http://www.tei-c.org/ns/1.0";

    public static <T> T fromXML(Reader xml, Class<T> clazz) throws JAXBException {
        Unmarshaller um = JAXBCONTEXT.createUnmarshaller();
        um.setSchema(schema);
        Object o = um.unmarshal(xml);
        if (o instanceof JAXBElement) {
            return (T)((JAXBElement)o).getValue();
        }
        return clazz.cast(o);
    }

    public static String toXML(Object teiObject) throws JAXBException {
        StringWriter w = new StringWriter();
        ValidationHelper.toXML(teiObject, w);
        return ((Object)w).toString();
    }

    public static void toXML(Object teiObject, Writer w) throws JAXBException {
        Marshaller m = JAXBCONTEXT.createMarshaller();
        m.setSchema(schema);
        Class<?> c = teiObject.getClass();
        if (c.isAnnotationPresent(XmlRootElement.class)) {
            m.marshal(teiObject, w);
        } else {
            JAXBElement jb = new JAXBElement(new QName(TEINS, c.getSimpleName()), c, teiObject);
            m.marshal((Object)jb, w);
        }
    }

    public static JAXBContext getJAXBCONTEXT() {
        return JAXBCONTEXT;
    }

    public static Schema getSchema() {
        return schema;
    }

    public static void validateXml(InputStream xml) throws SAXException, IOException {
        schema.newValidator().validate(new SAXSource(new InputSource(xml)));
    }

    public static void validateXml(Reader xml) throws SAXException, IOException {
        schema.newValidator().validate(new SAXSource(new InputSource(xml)));
    }

    public static void validateXml(URL xml) throws SAXException, IOException {
        ValidationHelper.validateXml(xml.openStream());
    }

    public static void validateXml(String xml) throws SAXException, IOException {
        ValidationHelper.validateXml(new StringReader(xml));
    }

    public static void main(String[] args) throws IOException, SAXException {
        if (args != null && args.length > 0) {
            ValidationHelper.validateXml(new URL(args[0]));
        }
    }

    static {
        try {
            SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            schema = sf.newSchema(new Source[]{new SAXSource(new InputSource(ValidationHelper.class.getResourceAsStream(XSD.XML_XSD.getPathInJar()))), new SAXSource(new InputSource(ValidationHelper.class.getResourceAsStream(XSD.DCR_XSD.getPathInJar()))), new SAXSource(new InputSource(ValidationHelper.class.getResourceAsStream(XSD.LINGUISTICS_XSD.getPathInJar()))), new SAXSource(new InputSource(ValidationHelper.class.getResourceAsStream(XSD.DOC_XSD.getPathInJar())))});
            JAXBCONTEXT = JAXBContext.newInstance((String)"org.fa.tei.jaxb.v2_0");
        }
        catch (JAXBException ex) {
            LOGGER.log(Level.SEVERE, "failed to load jaxb context", ex);
        }
        catch (SAXException ex) {
            LOGGER.log(Level.SEVERE, "failed to load schema", ex);
        }
    }

    public static enum XSD {
        DOC_XSD("/customization/v2_0/xsd/corpora_linguistics.xsd"),
        DCR_XSD("/customization/v2_0/xsd/dcr.tmp"),
        XML_XSD("/customization/v2_0/xsd/xml.tmp"),
        LINGUISTICS_XSD("/customization/v2_0/xsd/l.tmp");

        private final String xsd;
        private String content;

        private XSD(String xsd) {
            this.xsd = xsd;
        }

        public String getPathInJar() {
            return this.xsd;
        }

        public String getContent() throws IOException {
            if (this.content == null) {
                ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
                InputStream in = ValidationHelper.class.getResourceAsStream(this.xsd);
                int i = -1;
                while ((i = in.read()) != -1) {
                    out.write(i);
                }
                this.content = out.toString();
            }
            return this.content;
        }
    }
}

