/*
 * Decompiled with CFR 0.152.
 */
package org.fa.tei.xslt;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class XslTransformer {
    private static final TransformerFactory FACTORY = TransformerFactory.newInstance();
    private final Map<String, String> params = new HashMap<String, String>();
    private final Transformer transformer;
    private static final Map<String, Templates> TEMPLATES = new HashMap<String, Templates>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Templates getTemplates(String id, Source sheet) {
        Map<String, Templates> map = TEMPLATES;
        synchronized (map) {
            if (!TEMPLATES.containsKey(id)) {
                try {
                    TEMPLATES.put(id, FACTORY.newTemplates(sheet));
                }
                catch (TransformerConfigurationException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
        return TEMPLATES.get(id);
    }

    public static Transformer get(String id) throws TransformerConfigurationException {
        return TEMPLATES.get(id).newTransformer();
    }

    public static boolean clear(String id) {
        return TEMPLATES.remove(id) != null;
    }

    public XslTransformer(File stylesheet) throws TransformerConfigurationException, FileNotFoundException {
        this.transformer = TEMPLATES.containsKey(stylesheet.getPath()) ? XslTransformer.get(stylesheet.getPath()) : this.getTemplates(stylesheet.getPath(), new StreamSource(new FileReader(stylesheet))).newTransformer();
    }

    public XslTransformer(InputStream stylesheet) throws TransformerConfigurationException {
        this.transformer = FACTORY.newTransformer(new StreamSource(stylesheet));
    }

    public XslTransformer(Reader stylesheet) throws TransformerConfigurationException {
        this.transformer = FACTORY.newTransformer(new StreamSource(stylesheet));
    }

    public XslTransformer(String stylesheet) throws TransformerConfigurationException {
        StreamSource streamSource = new StreamSource(stylesheet);
        this.transformer = TEMPLATES.containsKey(stylesheet) ? XslTransformer.get(stylesheet) : this.getTemplates(stylesheet, streamSource).newTransformer();
    }

    public XslTransformer(String stylesheet, Reader sheet) throws TransformerConfigurationException {
        this.transformer = TEMPLATES.containsKey(stylesheet) ? XslTransformer.get(stylesheet) : this.getTemplates(stylesheet, new StreamSource(sheet)).newTransformer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String transform(String source) throws TransformerException {
        StreamSource ssSource = new StreamSource(new StringReader(source));
        StringWriter result = new StringWriter();
        StreamResult streamResult = new StreamResult(result);
        Transformer transformer = this.transformer;
        synchronized (transformer) {
            for (Map.Entry<String, String> e : this.params.entrySet()) {
                this.transformer.setParameter(e.getKey(), e.getValue());
            }
            this.transformer.transform(ssSource, streamResult);
            this.transformer.reset();
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <W extends Writer> W streamTransform(Reader source, W result) throws TransformerException {
        StreamSource ssSource = new StreamSource(source);
        StreamResult streamResult = new StreamResult(result);
        Transformer transformer = this.transformer;
        synchronized (transformer) {
            for (Map.Entry<String, String> e : this.params.entrySet()) {
                this.transformer.setParameter(e.getKey(), e.getValue());
            }
            this.transformer.transform(ssSource, streamResult);
            this.transformer.reset();
        }
        return result;
    }

    public void addParameter(String key, String value) {
        this.params.put(key, value);
    }

    public void clearParameters() {
        this.params.clear();
    }
}

