
package org.fa.tei.jaxb.v2_0.docs;


    // GENERATED FILE!!!: USE FOR EXAMPLE "xsltproc OddToDocJava.xsl ../corpora_linguistics.odd > LinguisticDocs.java"

/**
  * @see org.fa.tei.jaxb.v2_0.Join
  */
public class LinguisticDocs {

    private LinguisticDocs() {}

    /**
      * @see org.fa.tei.jaxb.v2_0.Join
      */
    public static String getDocumentation(Enum linguistics) {
        String ling = linguistics.getDeclaringClass().getSimpleName()+"."+linguistics;
        switch(ling.toLowerCase()) {
        
            case "islemma.yes":
                return "";

            case "abbr.yes":
                return "";

            case "poss.yes":
                return "";

            case "reflex.yes":
                return "";

            case "prefix.yes":
                return "";

            case "suffix.yes":
                return "";

            case "prontype.prs":
                return "personal pronoun or determiner";

            case "prontype.rcp":
                return "reciprocal pronoun";

            case "prontype.art":
                return "Article is a special case of determiner that bears the feature of definiteness";

            case "prontype.int":
                return "interrogative pronoun, determiner, numeral or adverb";

            case "prontype.rel":
                return "relative pronoun, determiner, numeral or adverb";

            case "prontype.ind":
                return "indefinite pronoun, determiner, numeral or adverb";

            case "prontype.emp":
                return "Emphatic pro-adjectives (determiners) emphasize the nominal they depend on.";

            case "prontype.exc":
                return "exclamative determiner";

            case "prontype.dem":
                return "Demonstrative pronouns are often parallel to interrogatives.";

            case "case.nom":
                return "nominative";

            case "case.acc":
                return "accusative";

            case "case.dat":
                return "dative";

            case "case.gen":
                return "genitive";

            case "case.ins":
                return "instrumental / instructive";

            case "case.par":
                return "partitive";

            case "tense.past":
                return "past tense";

            case "tense.pres":
                return "present tense";

            case "tense.fut":
                return "future tense";

            case "voice.act":
                return "The subject of the verb is the doer of the action (agent).";

            case "voice.pass":
                return "The subject of the verb is affected by the action (patient).";

            case "number.sing":
                return "A singular noun denotes one person, animal or thing.";

            case "number.plur":
                return "A plural noun denotes several persons, animals or things.";

            case "number.ptan":
                return "Plurale tantum, some nouns appear only in the plural form even though they denote one thing.";

            case "number.coll":
                return "Collective or mass or singulare tantum applies to words that use grammatical singular to describe sets of objects.";

            case "person.first":
                return "The first person refers just to the speaker / author and in plural one or more additional persons.";

            case "person.second":
                return "The second person refers to the addressee(s).";

            case "person.third":
                return "The third person refers to one or more persons that are neither speakers nor addressees.";

            case "verbtype.mod":
                return "Verbs that take infinitive of another verb as argument and add various modes of possibility, necessity etc.";

            case "verbtype.tense":
                return "Verb used to create periphrastic verb forms (tenses, passives etc.).";

            case "verbform.inf":
                return "Infinitive is the citation form of verbs in many languages.";

            case "verbform.part":
                return "Participle is a non-finite verb form that shares properties of verbs and adjectives.";

            case "verbform.ger":
                return "Gerund is a non-finite verb form that shares properties of verbs and nouns.";

            case "verbform.conv":
                return "The converb, also called adverbial participle or transgressive, is a non-finite verb form that shares properties of verbs and adverbs.";

            case "polite.infm":
                return "usually meant for communication with family members and close friends.";

            case "polite.form":
                return "usually meant for communication with strangers and people of higher social status.";

            case "numtype.ord":
                return "ordinal number (first, second,..)";

            case "numtype.card":
                return "cardinal number (one, two, many,....)";

            case "degree.cmp":
                return "comparative, second degree";

            case "degree.sup":
                return "superlative, third degree";

            case "mood.imp":
                return "The speaker uses imperative to order or ask the addressee to do the action of the verb.";

            case "mood.sub":
                return "The subjunctive mood is used under certain circumstances in subordinate clauses, typically for actions that are subjective or otherwise uncertain.";

            case "mood.ind":
                return "A verb in indicative merely states that something happens, has happened or will happen.";

            case "gender.masc":
                return "masculine gender";

            case "gender.fem":
                return "feminine gender";

            case "gender.neut":
                return "neuter gender";

            case "gender.com":
                return "Some languages do not distinguish masculine/feminine but they do distinguish neuter vs. non-neuter. The non-neuter is called common gender.";

            case "pronoun.drop":
                return "Not in universaldependencies. pronoun drop, omission of pronouns because they can be infered";

            case "pronoun.clitic":
                return "Not in universaldependencies. pronoun clitic, most personal pronouns have a clitic form, which is the result of either vowel deletion, vowel reduction, monophthongization or schwa deletion, while there are also cases of suppletion.";

            case "diminutive.dim":
                return "Not in universaldependencies. diminutive";

            case "inflection.infl":
                return "Not in universaldependencies. inflected";

            case "inflection.uninf":
                return "Not in universaldependencies. uninflected";

            case "valency.mtran":
                return "Not in universaldependencies. a monotransitive verb takes two arguments (of which one object)";

            case "valency.tran":
                return "Not in universaldependencies. a transitive verb requires one or more objects";

            case "valency.intran":
                return "Not in universaldependencies. an intransitive verb takes one argument (no object)";

            case "valency.ditran":
                return "Not in universaldependencies. a ditransitive verb takes three arguments (of which a direct and an indirect object)";

            case "construction.attr":
                return "Not in universaldependencies. attributive";

            case "convertedfrom.adj":
                return "Not in universaldependencies. adjective used as another category";

            case "convertedfrom.adv":
                return "Not in universaldependencies. adverb used as another category";

            case "convertedfrom.ver":
                return "Not in universaldependencies. verb used as another category";

            case "convertedfrom.num":
                return "Not in universaldependencies. numeral used as another category";

            case "convertedfrom.pro":
                return "Not in universaldependencies. pronomen used as another category";

            case "convertedfrom.part":
                return "Not in universaldependencies. verbform part used as another category";

            case "predicate.pred":
                return "Not in universaldependencies. statement about the subject";

            case "pos.adj":
                return "Adjectives are words that typically modify nouns and specify their properties or attributes.";

            case "pos.adp":
                return "Adposition is a cover term for prepositions and postpositions.";

            case "pos.adv":
                return "Adverbs are words that typically modify verbs for such categories as time, place, direction or manner.";

            case "pos.aux":
                return "An auxiliary is a function word that accompanies the lexical verb of a verb phrase and expresses grammatical distinctions not carried by the lexical verb, such as person, number, tense, mood, aspect, voice or evidentiality.";

            case "pos.cconj":
                return "A coordinating conjunction is a word that links words or larger constituents without syntactically subordinating one to the other and expresses a semantic relationship between them.";

            case "pos.det":
                return "Determiners are words that modify nouns or noun phrases and express the reference of the noun phrase in context.";

            case "pos.intj":
                return "An interjection is a word that is used most often as an exclamation or part of an exclamation.";

            case "pos.noun":
                return "Nouns are a part of speech typically denoting a person, place, thing, animal or idea.";

            case "pos.num":
                return "A numeral is a word, functioning most typically as a determiner, adjective or pronoun, that expresses a number and a relation to the number, such as quantity, sequence, frequency or fraction.";

            case "pos.part":
                return "Particles are function words that must be associated with another word or phrase to impart meaning and that do not satisfy definitions of other universal parts of speech.";

            case "pos.pron":
                return "Pronouns are words that substitute for nouns or noun phrases, whose meaning is recoverable from the linguistic or extralinguistic context.";

            case "pos.propn":
                return "A proper noun is a noun (or nominal content word) that is the name (or part of the name) of a specific individual, place, or object.";

            case "pos.punct":
                return "Punctuation marks are non-alphabetical characters and character groups used in many languages to delimit linguistic units in printed text.";

            case "pos.sconj":
                return "A subordinating conjunction is a conjunction that links constructions by making one of them a constituent of the other.";

            case "pos.sym":
                return "A symbol is a word-like entity that differs from ordinary words by form, function, or both.";

            case "pos.verb":
                return "A verb is a member of the syntactic class of words that typically signal events and actions.";

            case "pos.x":
                return "The tag X is used for words that for some reason cannot be assigned a real part-of-speech category.";

            default:
                return "undocumented";
        }
    }
    
    /**
      * @see org.fa.tei.jaxb.v2_0.Join
      */
    public static String getCategoryDocumentation(Class linguistics) {
        String ling = linguistics.getSimpleName().toLowerCase();
        switch(ling) {
        
            case "islemma":
                return "https://universaldependencies.org/u/overview/morphology.html Boolean, is this a base form";

            case "abbr":
                return "http://universaldependencies.org/u/feat/Abbr.html Boolean feature. Is this an abbreviation?";

            case "poss":
                return "http://universaldependencies.org/u/feat/Poss.html Boolean feature. Is this word possessive?";

            case "reflex":
                return "http://universaldependencies.org/u/feat/Reflex.html Boolean feature, typically of pronouns or determiners. It tells whether the word is reflexive, i.e. refers to the subject of its clause.?";

            case "prefix":
                return "https://universaldependencies.org/u/feat/Prefix.html Boolean feature, Is this a prefix word in a compound, that usually cannot stand on its own?";

            case "suffix":
                return "not in universaldependencies Boolean feature, Is this a suffix word in a compound, that usually cannot stand on its own?";

            case "prontype":
                return "http://universaldependencies.org/u/feat/PronType.html This feature typically applies to pronouns, pronominal adjectives (determiners), pronominal numerals (quantifiers) and pronominal adverbs.";

            case "case":
                return "http://universaldependencies.org/u/feat/Case.html Case is usually an inflectional feature of nouns.";

            case "tense":
                return "http://universaldependencies.org/u/feat/Tense.html Tense is typically a feature of verbs.";

            case "voice":
                return "http://universaldependencies.org/u/feat/Voice.html Voice is typically a feature of verbs.";

            case "number":
                return "http://universaldependencies.org/u/feat/Number.html Number is usually an inflectional feature of nouns.";

            case "person":
                return "http://universaldependencies.org/u/feat/Person.html Person is typically feature of personal and possessive pronouns / determiners, and of verbs.";

            case "verbtype":
                return "http://universaldependencies.org/u/feat/VerbType.html distinctions on top of verb and aux.";

            case "verbform":
                return "http://universaldependencies.org/u/feat/VerbForm.html form of verb or deverbative.";

            case "polite":
                return "https://universaldependencies.org/u/feat/Polite.html Various languages have various means to express politeness or respect.";

            case "numtype":
                return "http://universaldependencies.org/u/feat/NumType.html numeral type.";

            case "degree":
                return "http://universaldependencies.org/u/feat/Degree.html Degree of comparison is typically an inflectional feature of some adjectives and adverbs.";

            case "mood":
                return "http://universaldependencies.org/u/feat/Mood.html Mood is a feature that expresses modality and subclassifies finite verb forms.";

            case "gender":
                return "http://universaldependencies.org/u/feat/Gender.html gender.";

            case "pronoun":
                return "Not in universaldependencies. pronoun drop or clitic";

            case "diminutive":
                return "Not in universaldependencies. Diminutive.";

            case "inflection":
                return "Not in universaldependencies. The modification of a word to express different grammatical categories such as tense, case, voice, aspect, person.";

            case "valency":
                return "Not in universaldependencies. Verb valency or valence is the number of arguments controlled by a verbal predicate.";

            case "construction":
                return "Not in universaldependencies. Construction.";

            case "convertedfrom":
                return "Not in universaldependencies. words belonging to one part of speach category used as another category.";

            case "predicate":
                return "Not in universaldependencies. Predicate.";

            case "pos":
                return "http://universaldependencies.org/u/pos/index.html These tags mark the core part-of-speech categories.";

            default:
                return "undocumented";
        }
    }
    
    /** @param ling use category.value (class.getSimpleName().enum.name())
      * @see org.fa.tei.jaxb.v2_0.Join
      */
    public static String getDocumentation(String ling) {
        switch(ling.toLowerCase()) {
        
            case "islemma.yes":
                return "";
        
            case "abbr.yes":
                return "";
        
            case "poss.yes":
                return "";
        
            case "reflex.yes":
                return "";
        
            case "prefix.yes":
                return "";
        
            case "suffix.yes":
                return "";
        
            case "prontype.prs":
                return "personal pronoun or determiner";
        
            case "prontype.rcp":
                return "reciprocal pronoun";
        
            case "prontype.art":
                return "Article is a special case of determiner that bears the feature of definiteness";
        
            case "prontype.int":
                return "interrogative pronoun, determiner, numeral or adverb";
        
            case "prontype.rel":
                return "relative pronoun, determiner, numeral or adverb";
        
            case "prontype.ind":
                return "indefinite pronoun, determiner, numeral or adverb";
        
            case "prontype.emp":
                return "Emphatic pro-adjectives (determiners) emphasize the nominal they depend on.";
        
            case "prontype.exc":
                return "exclamative determiner";
        
            case "prontype.dem":
                return "Demonstrative pronouns are often parallel to interrogatives.";
        
            case "case.nom":
                return "nominative";
        
            case "case.acc":
                return "accusative";
        
            case "case.dat":
                return "dative";
        
            case "case.gen":
                return "genitive";
        
            case "case.ins":
                return "instrumental / instructive";
        
            case "case.par":
                return "partitive";
        
            case "tense.past":
                return "past tense";
        
            case "tense.pres":
                return "present tense";
        
            case "tense.fut":
                return "future tense";
        
            case "voice.act":
                return "The subject of the verb is the doer of the action (agent).";
        
            case "voice.pass":
                return "The subject of the verb is affected by the action (patient).";
        
            case "number.sing":
                return "A singular noun denotes one person, animal or thing.";
        
            case "number.plur":
                return "A plural noun denotes several persons, animals or things.";
        
            case "number.ptan":
                return "Plurale tantum, some nouns appear only in the plural form even though they denote one thing.";
        
            case "number.coll":
                return "Collective or mass or singulare tantum applies to words that use grammatical singular to describe sets of objects.";
        
            case "person.first":
                return "The first person refers just to the speaker / author and in plural one or more additional persons.";
        
            case "person.second":
                return "The second person refers to the addressee(s).";
        
            case "person.third":
                return "The third person refers to one or more persons that are neither speakers nor addressees.";
        
            case "verbtype.mod":
                return "Verbs that take infinitive of another verb as argument and add various modes of possibility, necessity etc.";
        
            case "verbtype.tense":
                return "Verb used to create periphrastic verb forms (tenses, passives etc.).";
        
            case "verbform.inf":
                return "Infinitive is the citation form of verbs in many languages.";
        
            case "verbform.part":
                return "Participle is a non-finite verb form that shares properties of verbs and adjectives.";
        
            case "verbform.ger":
                return "Gerund is a non-finite verb form that shares properties of verbs and nouns.";
        
            case "verbform.conv":
                return "The converb, also called adverbial participle or transgressive, is a non-finite verb form that shares properties of verbs and adverbs.";
        
            case "polite.infm":
                return "usually meant for communication with family members and close friends.";
        
            case "polite.form":
                return "usually meant for communication with strangers and people of higher social status.";
        
            case "numtype.ord":
                return "ordinal number (first, second,..)";
        
            case "numtype.card":
                return "cardinal number (one, two, many,....)";
        
            case "degree.cmp":
                return "comparative, second degree";
        
            case "degree.sup":
                return "superlative, third degree";
        
            case "mood.imp":
                return "The speaker uses imperative to order or ask the addressee to do the action of the verb.";
        
            case "mood.sub":
                return "The subjunctive mood is used under certain circumstances in subordinate clauses, typically for actions that are subjective or otherwise uncertain.";
        
            case "mood.ind":
                return "A verb in indicative merely states that something happens, has happened or will happen.";
        
            case "gender.masc":
                return "masculine gender";
        
            case "gender.fem":
                return "feminine gender";
        
            case "gender.neut":
                return "neuter gender";
        
            case "gender.com":
                return "Some languages do not distinguish masculine/feminine but they do distinguish neuter vs. non-neuter. The non-neuter is called common gender.";
        
            case "pronoun.drop":
                return "Not in universaldependencies. pronoun drop, omission of pronouns because they can be infered";
        
            case "pronoun.clitic":
                return "Not in universaldependencies. pronoun clitic, most personal pronouns have a clitic form, which is the result of either vowel deletion, vowel reduction, monophthongization or schwa deletion, while there are also cases of suppletion.";
        
            case "diminutive.dim":
                return "Not in universaldependencies. diminutive";
        
            case "inflection.infl":
                return "Not in universaldependencies. inflected";
        
            case "inflection.uninf":
                return "Not in universaldependencies. uninflected";
        
            case "valency.mtran":
                return "Not in universaldependencies. a monotransitive verb takes two arguments (of which one object)";
        
            case "valency.tran":
                return "Not in universaldependencies. a transitive verb requires one or more objects";
        
            case "valency.intran":
                return "Not in universaldependencies. an intransitive verb takes one argument (no object)";
        
            case "valency.ditran":
                return "Not in universaldependencies. a ditransitive verb takes three arguments (of which a direct and an indirect object)";
        
            case "construction.attr":
                return "Not in universaldependencies. attributive";
        
            case "convertedfrom.adj":
                return "Not in universaldependencies. adjective used as another category";
        
            case "convertedfrom.adv":
                return "Not in universaldependencies. adverb used as another category";
        
            case "convertedfrom.ver":
                return "Not in universaldependencies. verb used as another category";
        
            case "convertedfrom.num":
                return "Not in universaldependencies. numeral used as another category";
        
            case "convertedfrom.pro":
                return "Not in universaldependencies. pronomen used as another category";
        
            case "convertedfrom.part":
                return "Not in universaldependencies. verbform part used as another category";
        
            case "predicate.pred":
                return "Not in universaldependencies. statement about the subject";
        
            case "pos.adj":
                return "Adjectives are words that typically modify nouns and specify their properties or attributes.";
        
            case "pos.adp":
                return "Adposition is a cover term for prepositions and postpositions.";
        
            case "pos.adv":
                return "Adverbs are words that typically modify verbs for such categories as time, place, direction or manner.";
        
            case "pos.aux":
                return "An auxiliary is a function word that accompanies the lexical verb of a verb phrase and expresses grammatical distinctions not carried by the lexical verb, such as person, number, tense, mood, aspect, voice or evidentiality.";
        
            case "pos.cconj":
                return "A coordinating conjunction is a word that links words or larger constituents without syntactically subordinating one to the other and expresses a semantic relationship between them.";
        
            case "pos.det":
                return "Determiners are words that modify nouns or noun phrases and express the reference of the noun phrase in context.";
        
            case "pos.intj":
                return "An interjection is a word that is used most often as an exclamation or part of an exclamation.";
        
            case "pos.noun":
                return "Nouns are a part of speech typically denoting a person, place, thing, animal or idea.";
        
            case "pos.num":
                return "A numeral is a word, functioning most typically as a determiner, adjective or pronoun, that expresses a number and a relation to the number, such as quantity, sequence, frequency or fraction.";
        
            case "pos.part":
                return "Particles are function words that must be associated with another word or phrase to impart meaning and that do not satisfy definitions of other universal parts of speech.";
        
            case "pos.pron":
                return "Pronouns are words that substitute for nouns or noun phrases, whose meaning is recoverable from the linguistic or extralinguistic context.";
        
            case "pos.propn":
                return "A proper noun is a noun (or nominal content word) that is the name (or part of the name) of a specific individual, place, or object.";
        
            case "pos.punct":
                return "Punctuation marks are non-alphabetical characters and character groups used in many languages to delimit linguistic units in printed text.";
        
            case "pos.sconj":
                return "A subordinating conjunction is a conjunction that links constructions by making one of them a constituent of the other.";
        
            case "pos.sym":
                return "A symbol is a word-like entity that differs from ordinary words by form, function, or both.";
        
            case "pos.verb":
                return "A verb is a member of the syntactic class of words that typically signal events and actions.";
        
            case "pos.x":
                return "The tag X is used for words that for some reason cannot be assigned a real part-of-speech category.";
        
            default:
                return "undocumented";
        }
    }
    
    /** @param ling use category (class.getSimpleName())
      * @see org.fa.tei.jaxb.v2_0.Join
      */
    public static String getCategoryDocumentation(String ling) {
        switch(ling.toLowerCase()) {

            case "islemma":
                return "https://universaldependencies.org/u/overview/morphology.html Boolean, is this a base form";

            case "abbr":
                return "http://universaldependencies.org/u/feat/Abbr.html Boolean feature. Is this an abbreviation?";

            case "poss":
                return "http://universaldependencies.org/u/feat/Poss.html Boolean feature. Is this word possessive?";

            case "reflex":
                return "http://universaldependencies.org/u/feat/Reflex.html Boolean feature, typically of pronouns or determiners. It tells whether the word is reflexive, i.e. refers to the subject of its clause.?";

            case "prefix":
                return "https://universaldependencies.org/u/feat/Prefix.html Boolean feature, Is this a prefix word in a compound, that usually cannot stand on its own?";

            case "suffix":
                return "not in universaldependencies Boolean feature, Is this a suffix word in a compound, that usually cannot stand on its own?";

            case "prontype":
                return "http://universaldependencies.org/u/feat/PronType.html This feature typically applies to pronouns, pronominal adjectives (determiners), pronominal numerals (quantifiers) and pronominal adverbs.";

            case "case":
                return "http://universaldependencies.org/u/feat/Case.html Case is usually an inflectional feature of nouns.";

            case "tense":
                return "http://universaldependencies.org/u/feat/Tense.html Tense is typically a feature of verbs.";

            case "voice":
                return "http://universaldependencies.org/u/feat/Voice.html Voice is typically a feature of verbs.";

            case "number":
                return "http://universaldependencies.org/u/feat/Number.html Number is usually an inflectional feature of nouns.";

            case "person":
                return "http://universaldependencies.org/u/feat/Person.html Person is typically feature of personal and possessive pronouns / determiners, and of verbs.";

            case "verbtype":
                return "http://universaldependencies.org/u/feat/VerbType.html distinctions on top of verb and aux.";

            case "verbform":
                return "http://universaldependencies.org/u/feat/VerbForm.html form of verb or deverbative.";

            case "polite":
                return "https://universaldependencies.org/u/feat/Polite.html Various languages have various means to express politeness or respect.";

            case "numtype":
                return "http://universaldependencies.org/u/feat/NumType.html numeral type.";

            case "degree":
                return "http://universaldependencies.org/u/feat/Degree.html Degree of comparison is typically an inflectional feature of some adjectives and adverbs.";

            case "mood":
                return "http://universaldependencies.org/u/feat/Mood.html Mood is a feature that expresses modality and subclassifies finite verb forms.";

            case "gender":
                return "http://universaldependencies.org/u/feat/Gender.html gender.";

            case "pronoun":
                return "Not in universaldependencies. pronoun drop or clitic";

            case "diminutive":
                return "Not in universaldependencies. Diminutive.";

            case "inflection":
                return "Not in universaldependencies. The modification of a word to express different grammatical categories such as tense, case, voice, aspect, person.";

            case "valency":
                return "Not in universaldependencies. Verb valency or valence is the number of arguments controlled by a verbal predicate.";

            case "construction":
                return "Not in universaldependencies. Construction.";

            case "convertedfrom":
                return "Not in universaldependencies. words belonging to one part of speach category used as another category.";

            case "predicate":
                return "Not in universaldependencies. Predicate.";

            case "pos":
                return "http://universaldependencies.org/u/pos/index.html These tags mark the core part-of-speech categories.";

            default:
                return "undocumented";
        }
    }
}            
    