<?xml version="1.0" encoding="UTF-8"?>
<!--
  #%L
  TeiLinguisticsFa
  %%
  Copyright (C) 2018 Fryske Akademy
  %%
  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at
  
       http://www.apache.org/licenses/LICENSE-2.0
  
  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
  #L%
  -->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema"
    xmlns:tei="http://www.tei-c.org/ns/1.0" version="1.0">
    
    <xsl:output indent="yes" method="xml" />

    <xsl:template match="/">
        <xs:schema xmlns:xs="http://www.w3.org/2001/XMLSchema" elementFormDefault="qualified" targetNamespace="http://www.fryske-akademy.org/linguistics/2.1"
            xmlns="http://www.fryske-akademy.org/linguistics/2.1" xmlns:tei="http://www.tei-c.org/ns/1.0" version="1.0">

            <xsl:comment><![CDATA[
                GENERATED FILE!!!: USE FOR EXAMPLE "xsltproc OddToElements.xsl ../corpora_linguistics.odd > linguistic_elements.xsd"
            ]]></xsl:comment>

            <xs:group name="linguistics.values">
                <xs:annotation>
                    <xs:documentation>select at most one linguistic value from each category</xs:documentation>
                </xs:annotation>
                <xs:all>
                    <xsl:for-each select="//tei:classSpec//tei:attDef">
                        <xs:element name="{@ident}" type="{@ident}" minOccurs="0"/>
                    </xsl:for-each>
                </xs:all>
            </xs:group>

            <xs:complexType name="linguisticValues">
                <xs:group ref="linguistics.values"/>
            </xs:complexType>

            <xs:group name="linguistics.value">
                <xs:annotation>
                    <xs:documentation>select at most one linguistic value from one category</xs:documentation>
                </xs:annotation>
                <xs:choice>
                    <xsl:for-each select="//tei:classSpec//tei:attDef">
                        <xs:element name="{@ident}" type="{@ident}"/>
                    </xsl:for-each>
                </xs:choice>
            </xs:group>

            <xs:complexType name="linguisticValue">
                <xs:group ref="linguistics.value"/>
            </xs:complexType>

            <xsl:for-each select="//tei:classSpec//tei:attDef">
                <xs:simpleType name="{@ident}">
                    <xs:annotation>
                        <xs:documentation>
                            <xsl:value-of select="normalize-space(tei:desc/text())"/>
                        </xs:documentation>
                    </xs:annotation>
                    <xs:restriction base="xs:token">
                        <xsl:for-each select=".//tei:valItem">

                            <xs:enumeration value="{@ident}">
                                <xs:annotation>
                                    <xs:documentation>
                                        <xsl:value-of select="normalize-space(tei:desc/text())"/>
                                    </xs:documentation>
                                </xs:annotation>
                            </xs:enumeration>
                        </xsl:for-each>
                    </xs:restriction>

                </xs:simpleType>
            </xsl:for-each>
        </xs:schema>
    </xsl:template>

</xsl:stylesheet>
