-- GENERATED (xsltproc OddToSql.xsl ../customization/v2.0/corpora_linguistics.odd > linguistics.sql), ADAPT AS NEEDED

create table linguistic_category (id INT(10) NOT NULL auto_increment, version INT(10) NOT NULL, category varchar(16) not null, description varchar(256) not null,
    primary key(id),
    unique index category_unique (category));
create table linguistic_value (id INT(10) NOT NULL auto_increment, version INT(10) NOT NULL, category_id INT(10) NOT NULL, value varchar(16) not null, description varchar(256) not null,
    primary key(id),
    unique index value_category_unique (category_id, value),
    constraint group_link foreign key (category_id) references linguistic_category (id));
insert into linguistic_category (id, version, category, description) values(1,0, 'islemma', 'Boolean, is this a base form');
  insert into linguistic_value (id, version, category_id, value, description) values(2,0, 1, 'yes', '');
insert into linguistic_category (id, version, category, description) values(2,0, 'abbr', 'Boolean feature. Is this an abbreviation?');
  insert into linguistic_value (id, version, category_id, value, description) values(3,0, 2, 'yes', '');
insert into linguistic_category (id, version, category, description) values(3,0, 'poss', 'Boolean feature. Is this word possessive?');
  insert into linguistic_value (id, version, category_id, value, description) values(4,0, 3, 'yes', '');
insert into linguistic_category (id, version, category, description) values(4,0, 'reflex', 'Boolean feature, typically of pronouns or determiners. It tells whether the word is reflexive, i.e. refers to the subject of its clause.?');
  insert into linguistic_value (id, version, category_id, value, description) values(5,0, 4, 'yes', '');
insert into linguistic_category (id, version, category, description) values(5,0, 'prefix', 'Boolean feature, Is this a prefix word in a compound, that usually cannot stand on its own?');
  insert into linguistic_value (id, version, category_id, value, description) values(6,0, 5, 'yes', '');
insert into linguistic_category (id, version, category, description) values(6,0, 'prontype', 'This feature typically applies to pronouns, pronominal adjectives (determiners), pronominal numerals (quantifiers) and pronominal adverbs.');
  insert into linguistic_value (id, version, category_id, value, description) values(7,0, 6, 'prs', 'personal pronoun or determiner');
  insert into linguistic_value (id, version, category_id, value, description) values(8,0, 6, 'rcp', 'reciprocal pronoun');
  insert into linguistic_value (id, version, category_id, value, description) values(9,0, 6, 'art', 'Article is a special case of determiner that bears the feature of definiteness');
  insert into linguistic_value (id, version, category_id, value, description) values(10,0, 6, 'int', 'interrogative pronoun, determiner, numeral or adverb');
  insert into linguistic_value (id, version, category_id, value, description) values(11,0, 6, 'rel', 'relative pronoun, determiner, numeral or adverb');
  insert into linguistic_value (id, version, category_id, value, description) values(12,0, 6, 'ind', 'indefinite pronoun, determiner, numeral or adverb');
  insert into linguistic_value (id, version, category_id, value, description) values(13,0, 6, 'emp', 'Emphatic pro-adjectives (determiners) emphasize the nominal they depend on.');
  insert into linguistic_value (id, version, category_id, value, description) values(14,0, 6, 'exc', 'exclamative determiner');
  insert into linguistic_value (id, version, category_id, value, description) values(15,0, 6, 'dem', 'Demonstrative pronouns are often parallel to interrogatives.');
insert into linguistic_category (id, version, category, description) values(7,0, 'case', 'Case is usually an inflectional feature of nouns.');
  insert into linguistic_value (id, version, category_id, value, description) values(16,0, 7, 'nom', 'nominative');
  insert into linguistic_value (id, version, category_id, value, description) values(17,0, 7, 'acc', 'accusative');
  insert into linguistic_value (id, version, category_id, value, description) values(18,0, 7, 'dat', 'dative');
  insert into linguistic_value (id, version, category_id, value, description) values(19,0, 7, 'gen', 'genitive');
  insert into linguistic_value (id, version, category_id, value, description) values(20,0, 7, 'ins', 'instrumental / instructive');
  insert into linguistic_value (id, version, category_id, value, description) values(21,0, 7, 'par', 'partitive');
insert into linguistic_category (id, version, category, description) values(8,0, 'tense', 'Tense is typically a feature of verbs.');
  insert into linguistic_value (id, version, category_id, value, description) values(22,0, 8, 'past', 'past tense');
  insert into linguistic_value (id, version, category_id, value, description) values(23,0, 8, 'pres', 'present tense');
  insert into linguistic_value (id, version, category_id, value, description) values(24,0, 8, 'fut', 'future tense');
insert into linguistic_category (id, version, category, description) values(9,0, 'voice', 'Voice is typically a feature of verbs.');
  insert into linguistic_value (id, version, category_id, value, description) values(25,0, 9, 'act', 'The subject of the verb is the doer of the action (agent).');
  insert into linguistic_value (id, version, category_id, value, description) values(26,0, 9, 'pass', 'The subject of the verb is affected by the action (patient).');
insert into linguistic_category (id, version, category, description) values(10,0, 'number', 'Number is usually an inflectional feature of nouns.');
  insert into linguistic_value (id, version, category_id, value, description) values(27,0, 10, 'sing', 'A singular noun denotes one person, animal or thing.');
  insert into linguistic_value (id, version, category_id, value, description) values(28,0, 10, 'plur', 'A plural noun denotes several persons, animals or things.');
  insert into linguistic_value (id, version, category_id, value, description) values(29,0, 10, 'ptan', 'Plurale tantum, some nouns appear only in the plural form even though they denote one thing.');
  insert into linguistic_value (id, version, category_id, value, description) values(30,0, 10, 'coll', 'Collective or mass or singulare tantum applies to words that use grammatical singular to describe sets of objects.');
insert into linguistic_category (id, version, category, description) values(11,0, 'person', 'Person is typically feature of personal and possessive pronouns / determiners, and of verbs.');
  insert into linguistic_value (id, version, category_id, value, description) values(31,0, 11, '1', 'The first person refers just to the speaker / author and in plural one or more additional persons.');
  insert into linguistic_value (id, version, category_id, value, description) values(32,0, 11, '2', 'The second person refers to the addressee(s).');
  insert into linguistic_value (id, version, category_id, value, description) values(33,0, 11, '3', 'The third person refers to one or more persons that are neither speakers nor addressees.');
insert into linguistic_category (id, version, category, description) values(12,0, 'verbtype', 'distinctions on top of verb and aux.');
  insert into linguistic_value (id, version, category_id, value, description) values(34,0, 12, 'mod', 'Verbs that take infinitive of another verb as argument and add various modes of possibility, necessity etc.');
  insert into linguistic_value (id, version, category_id, value, description) values(35,0, 12, 'tense', 'Verb used to create periphrastic verb forms (tenses, passives etc.).');
insert into linguistic_category (id, version, category, description) values(13,0, 'verbform', 'form of verb or deverbative.');
  insert into linguistic_value (id, version, category_id, value, description) values(36,0, 13, 'inf', 'Infinitive is the citation form of verbs in many languages.');
  insert into linguistic_value (id, version, category_id, value, description) values(37,0, 13, 'part', 'Participle is a non-finite verb form that shares properties of verbs and adjectives.');
  insert into linguistic_value (id, version, category_id, value, description) values(38,0, 13, 'ger', 'Gerund is a non-finite verb form that shares properties of verbs and nouns.');
  insert into linguistic_value (id, version, category_id, value, description) values(39,0, 13, 'conv', 'The converb, also called adverbial participle or transgressive, is a non-finite verb form that shares properties of verbs and adverbs.');
insert into linguistic_category (id, version, category, description) values(14,0, 'polite', 'Various languages have various means to express politeness or respect.');
  insert into linguistic_value (id, version, category_id, value, description) values(40,0, 14, 'infm', 'usually meant for communication with family members and close friends.');
  insert into linguistic_value (id, version, category_id, value, description) values(41,0, 14, 'form', 'usually meant for communication with strangers and people of higher social status.');
insert into linguistic_category (id, version, category, description) values(15,0, 'numtype', 'numeral type.');
  insert into linguistic_value (id, version, category_id, value, description) values(42,0, 15, 'ord', 'ordinal number (first, second,..)');
  insert into linguistic_value (id, version, category_id, value, description) values(43,0, 15, 'card', 'cardinal number (one, two, many,....)');
insert into linguistic_category (id, version, category, description) values(16,0, 'degree', 'Degree of comparison is typically an inflectional feature of some adjectives and adverbs.');
  insert into linguistic_value (id, version, category_id, value, description) values(44,0, 16, 'cmp', 'comparative, second degree');
  insert into linguistic_value (id, version, category_id, value, description) values(45,0, 16, 'sup', 'superlative, third degree');
  insert into linguistic_value (id, version, category_id, value, description) values(46,0, 16, 'dim', 'Added to features in universaldependencies. Diminutive.');
insert into linguistic_category (id, version, category, description) values(17,0, 'mood', 'Mood is a feature that expresses modality and subclassifies finite verb forms.');
  insert into linguistic_value (id, version, category_id, value, description) values(47,0, 17, 'imp', 'The speaker uses imperative to order or ask the addressee to do the action of the verb.');
  insert into linguistic_value (id, version, category_id, value, description) values(48,0, 17, 'sub', 'The subjunctive mood is used under certain circumstances in subordinate clauses, typically for actions that are subjective or otherwise uncertain.');
  insert into linguistic_value (id, version, category_id, value, description) values(49,0, 17, 'ind', 'A verb in indicative merely states that something happens, has happened or will happen.');
insert into linguistic_category (id, version, category, description) values(18,0, 'gender', 'gender.');
  insert into linguistic_value (id, version, category_id, value, description) values(50,0, 18, 'masc', 'masculine gender');
  insert into linguistic_value (id, version, category_id, value, description) values(51,0, 18, 'fem', 'feminine gender');
  insert into linguistic_value (id, version, category_id, value, description) values(52,0, 18, 'neut', 'neuter gender');
  insert into linguistic_value (id, version, category_id, value, description) values(53,0, 18, 'com', 'Some languages do not distinguish masculine/feminine but they do distinguish neuter vs. non-neuter. The non-neuter is called common gender.');
insert into linguistic_category (id, version, category, description) values(19,0, 'hyph', 'Is this part of a hyphenated compound? Depending on tokenization, the compound may be one token or be split to several tokens; then the tokens need tags.');
  insert into linguistic_value (id, version, category_id, value, description) values(54,0, 19, 'yes', '');
insert into linguistic_category (id, version, category, description) values(20,0, 'prodrop', 'Added for Frisian to MISC in universaldependencies. pronoun drop, omission of pronouns because they can be inferred');
  insert into linguistic_value (id, version, category_id, value, description) values(55,0, 20, 'yes', '');
insert into linguistic_category (id, version, category, description) values(21,0, 'clitic', 'Added for Frisian to features in universaldependencies. Most personal pronouns have a clitic form, which is the result of either vowel deletion, vowel reduction, monophthongization or schwa deletion, while there are also cases of suppletion.');
  insert into linguistic_value (id, version, category_id, value, description) values(56,0, 21, 'yes', '');
insert into linguistic_category (id, version, category, description) values(22,0, 'inflection', 'Not in universaldependencies. The modification of a word to express different grammatical categories such as tense, case, voice, aspect, person.');
  insert into linguistic_value (id, version, category_id, value, description) values(57,0, 22, 'infl', 'Not in universaldependencies. inflected');
  insert into linguistic_value (id, version, category_id, value, description) values(58,0, 22, 'uninf', 'Not in universaldependencies. uninflected');
insert into linguistic_category (id, version, category, description) values(23,0, 'suffix', 'Not in universaldependencies Boolean feature, Is this a suffix word in a compound, that usually cannot stand on its own?');
  insert into linguistic_value (id, version, category_id, value, description) values(59,0, 23, 'yes', '');
insert into linguistic_category (id, version, category, description) values(24,0, 'valency', 'Not in universaldependencies. Verb valency or valence is the number of arguments controlled by a verbal predicate.');
  insert into linguistic_value (id, version, category_id, value, description) values(60,0, 24, '1', 'An intransitive verb takes one argument (no object)');
  insert into linguistic_value (id, version, category_id, value, description) values(61,0, 24, '2', 'A monotransitive verb takes two arguments (of which one object)');
  insert into linguistic_value (id, version, category_id, value, description) values(62,0, 24, '3', 'A ditransitive verb takes three arguments (of which a direct and an indirect object)');
insert into linguistic_category (id, version, category, description) values(25,0, 'convertedfrom', 'Not in universaldependencies. Words belonging to one part of speech category used as another category.');
  insert into linguistic_value (id, version, category_id, value, description) values(63,0, 25, 'adj', 'Not in universaldependencies. adjective used as another category');
  insert into linguistic_value (id, version, category_id, value, description) values(64,0, 25, 'adv', 'Not in universaldependencies. adverb used as another category');
  insert into linguistic_value (id, version, category_id, value, description) values(65,0, 25, 'ver', 'Not in universaldependencies. verb used as another category');
  insert into linguistic_value (id, version, category_id, value, description) values(66,0, 25, 'num', 'Not in universaldependencies. numeral used as another category');
  insert into linguistic_value (id, version, category_id, value, description) values(67,0, 25, 'pro', 'Not in universaldependencies. pronomen used as another category');
  insert into linguistic_value (id, version, category_id, value, description) values(68,0, 25, 'part', 'Not in universaldependencies. verbform part used as another category');
insert into linguistic_category (id, version, category, description) values(26,0, 'predicate', 'Not in universaldependencies. Predicate.');
  insert into linguistic_value (id, version, category_id, value, description) values(69,0, 26, 'yes', 'Not in universaldependencies. statement about the subject');
insert into linguistic_category (id, version, category, description) values(27,0, 'construction', 'Not in universaldependencies. Construction.');
  insert into linguistic_value (id, version, category_id, value, description) values(70,0, 27, 'attr', 'Not in universaldependencies. attributive');
insert into linguistic_category (id, version, category, description) values(28,0, 'pos', 'These tags mark the core part-of-speech categories.');
  insert into linguistic_value (id, version, category_id, value, description) values(71,0, 28, 'adj', 'Adjectives are words that typically modify nouns and specify their properties or attributes.');
  insert into linguistic_value (id, version, category_id, value, description) values(72,0, 28, 'adp', 'Adposition is a cover term for prepositions and postpositions.');
  insert into linguistic_value (id, version, category_id, value, description) values(73,0, 28, 'adv', 'Adverbs are words that typically modify verbs for such categories as time, place, direction or manner.');
  insert into linguistic_value (id, version, category_id, value, description) values(74,0, 28, 'aux', 'An auxiliary is a function word that accompanies the lexical verb of a verb phrase and expresses grammatical distinctions not carried by the lexical verb, such as person, number, tense, mood, aspect, voice or evidentiality.');
  insert into linguistic_value (id, version, category_id, value, description) values(75,0, 28, 'cconj', 'A coordinating conjunction is a word that links words or larger constituents without syntactically subordinating one to the other and expresses a semantic relationship between them.');
  insert into linguistic_value (id, version, category_id, value, description) values(76,0, 28, 'det', 'Determiners are words that modify nouns or noun phrases and express the reference of the noun phrase in context.');
  insert into linguistic_value (id, version, category_id, value, description) values(77,0, 28, 'intj', 'An interjection is a word that is used most often as an exclamation or part of an exclamation.');
  insert into linguistic_value (id, version, category_id, value, description) values(78,0, 28, 'noun', 'Nouns are a part of speech typically denoting a person, place, thing, animal or idea.');
  insert into linguistic_value (id, version, category_id, value, description) values(79,0, 28, 'num', 'A numeral is a word, functioning most typically as a determiner, adjective or pronoun, that expresses a number and a relation to the number, such as quantity, sequence, frequency or fraction.');
  insert into linguistic_value (id, version, category_id, value, description) values(80,0, 28, 'part', 'Particles are function words that must be associated with another word or phrase to impart meaning and that do not satisfy definitions of other universal parts of speech.');
  insert into linguistic_value (id, version, category_id, value, description) values(81,0, 28, 'pron', 'Pronouns are words that substitute for nouns or noun phrases, whose meaning is recoverable from the linguistic or extralinguistic context.');
  insert into linguistic_value (id, version, category_id, value, description) values(82,0, 28, 'propn', 'A proper noun is a noun (or nominal content word) that is the name (or part of the name) of a specific individual, place, or object.');
  insert into linguistic_value (id, version, category_id, value, description) values(83,0, 28, 'punct', 'Punctuation marks are non-alphabetical characters and character groups used in many languages to delimit linguistic units in printed text.');
  insert into linguistic_value (id, version, category_id, value, description) values(84,0, 28, 'sconj', 'A subordinating conjunction is a conjunction that links constructions by making one of them a constituent of the other.');
  insert into linguistic_value (id, version, category_id, value, description) values(85,0, 28, 'sym', 'A symbol is a word-like entity that differs from ordinary words by form, function, or both.');
  insert into linguistic_value (id, version, category_id, value, description) values(86,0, 28, 'verb', 'A verb is a member of the syntactic class of words that typically signal events and actions.');
  insert into linguistic_value (id, version, category_id, value, description) values(87,0, 28, 'x', 'The tag X is used for words that for some reason cannot be assigned a real part-of-speech category.');
