/*
 * Decompiled with CFR 0.152.
 */
package org.fryske_akademy.jpa;

import java.security.Principal;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.ejb.EJBException;
import javax.ejb.SessionContext;
import javax.faces.context.FacesContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;

public class JpaUtil {
    private static final Logger LOGGER = Logger.getLogger(JpaUtil.class.getName());
    private static final Map<String, EntityManagerFactory> factories = new ConcurrentHashMap<String, EntityManagerFactory>(1);

    public static EntityManagerFactory getFactory(String name) {
        if (!factories.containsKey(name)) {
            factories.put(name, Persistence.createEntityManagerFactory((String)name));
        }
        return factories.get(name);
    }

    public static Principal findPrincipal() throws EJBException, IllegalStateException {
        Principal p = null;
        try {
            p = FacesContext.getCurrentInstance().getExternalContext().getUserPrincipal();
        }
        catch (IllegalStateException e) {
            LOGGER.warning("failure finding principal in facescontext, trying ejbcontext");
        }
        if (p == null) {
            try {
                InitialContext ic = new InitialContext();
                SessionContext context = (SessionContext)ic.lookup("java:comp/EJBContext");
                p = context.getCallerPrincipal();
            }
            catch (NamingException ex) {
                throw new EJBException((Exception)ex);
            }
        }
        return p;
    }
}

