/*
 * Decompiled with CFR 0.152.
 */
package org.fryske_akademy.ejb;

import java.util.ArrayList;
import java.util.List;

public class ParamInfo {
    private final String propertyPath;
    private final String paramKey;
    private final String operator;
    private final Object paramValue;
    private final String not;
    private final AndOr andOr;

    private ParamInfo(String propertyPath, String paramKey, String operator, Object paramValue, boolean not, boolean or) {
        this.propertyPath = propertyPath;
        this.paramKey = paramKey;
        this.operator = operator;
        this.paramValue = paramValue;
        this.not = not ? " NOT " : " ";
        this.andOr = AndOr.fromBool(or);
    }

    private ParamInfo(String propertyPath, String paramKey, String operator, Object paramValue) {
        this(propertyPath, paramKey, operator, paramValue, false, false);
    }

    private ParamInfo(String paramKey, Object paramValue) {
        this(paramKey, paramKey, " = ", paramValue, false, false);
    }

    public String getPropertyPath() {
        return this.propertyPath;
    }

    public String getParamKey() {
        return this.paramKey;
    }

    public String getOperator() {
        return this.operator;
    }

    public Object getParamValue() {
        return this.paramValue;
    }

    public String getNot() {
        return this.not;
    }

    public AndOr getAndOr() {
        return this.andOr;
    }

    public static class ParamInfoBuilder {
        private final List<ParamInfo> params = new ArrayList<ParamInfo>(3);

        public ParamInfoBuilder add(String propertyPath, String paramKey, String operator, Object paramValue) {
            if (paramValue instanceof String) {
                return this.add(propertyPath, paramKey, operator, String.valueOf(paramValue), false);
            }
            return this.add(propertyPath, paramKey, operator, paramValue, false, false);
        }

        public ParamInfoBuilder add(String propertyPath, String paramKey, String operator, String paramValue, boolean or) {
            return this.add(propertyPath, paramKey, operator, this.stripNegation(paramValue), this.isNegation(paramValue), or);
        }

        public ParamInfoBuilder add(String propertyPath, String paramKey, String operator, Object paramValue, boolean not, boolean or) {
            this.params.add(new ParamInfo(propertyPath, paramKey, operator, paramValue, not, or));
            return this;
        }

        private boolean isNegation(String value) {
            return value != null && value.indexOf(33) == 0;
        }

        private String stripNegation(String value) {
            return this.isNegation(value) ? value.substring(1) : value;
        }

        public ParamInfoBuilder add(String paramKey, Object paramValue) {
            return this.add(paramKey, paramValue, false);
        }

        public ParamInfoBuilder add(String paramKey, Object paramValue, boolean or) {
            if (paramValue instanceof String) {
                return this.add(paramKey, paramKey, " like ", (String)paramValue, or);
            }
            return this.add(paramKey, paramKey, " = ", paramValue, false, or);
        }

        public List<ParamInfo> build() {
            return this.params;
        }
    }

    public static enum AndOr {
        AND,
        OR;


        private static AndOr fromBool(boolean or) {
            return or ? OR : AND;
        }

        public String toString() {
            return " " + this.name() + " ";
        }
    }
}

