/*
 * Decompiled with CFR 0.152.
 */
package org.fryske_akademy.jpa;

import java.security.Principal;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.ejb.SessionContext;
import javax.faces.context.FacesContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;

public class JpaUtil {
    private static final Logger LOGGER = Logger.getLogger(JpaUtil.class.getName());
    private static final Map<String, EntityManagerFactory> emFacts = new ConcurrentHashMap<String, EntityManagerFactory>(5){

        @Override
        public EntityManagerFactory get(Object key) {
            if (!this.containsKey(key) || !((EntityManagerFactory)super.get(key)).isOpen()) {
                this.put(String.valueOf(key), Persistence.createEntityManagerFactory((String)String.valueOf(key)));
            }
            return (EntityManagerFactory)super.get(key);
        }
    };

    public static EntityManagerFactory getEntityManagerFactory(String name) {
        return emFacts.get(name);
    }

    public static Principal findPrincipal() throws NamingException, IllegalStateException {
        Principal p = null;
        try {
            p = FacesContext.getCurrentInstance().getExternalContext().getUserPrincipal();
        }
        catch (IllegalStateException e) {
            LOGGER.warning("failure finding principal in facescontext, trying ejbcontext");
        }
        if (p == null) {
            InitialContext ic = new InitialContext();
            SessionContext context = (SessionContext)ic.lookup("java:comp/EJBContext");
            p = context.getCallerPrincipal();
        }
        return p;
    }
}

