package org.fryske_akademy.jpa;

/*-
 * #%L
 * ejbCrudApi
 * %%
 * Copyright (C) 2018 Fryske Akademy
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */
import java.security.Principal;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.security.enterprise.SecurityContext;
import org.fryske_akademy.Util;

public class JpaUtil {
    
    private static final Logger LOGGER = Logger.getLogger(JpaUtil.class.getName());
    
    private static final Map<String, EntityManagerFactory> emFacts
            = new ConcurrentHashMap<String, EntityManagerFactory>(5) {
        @Override
        public EntityManagerFactory get(Object key) {
            if (!containsKey(key) || !super.get(key).isOpen()) {
                put(String.valueOf(key), Persistence.createEntityManagerFactory(String.valueOf(key)));
            }
            return super.get(key);
        }
    };
    
    /**
     * return a cached EntityManagerFactory, make sure you close it when it is not needed anymore.
     * @param name
     * @return 
     */
    public static EntityManagerFactory getEntityManagerFactory(String name) {
        return emFacts.get(name);
    }

    /**
     * Looks for principal in CDI
     *
     * @return
     * @throws IllegalStateException
     */
    public static Principal findPrincipal() throws IllegalStateException {
        return Util.getBean(SecurityContext.class).getCallerPrincipal();
    }
    
}
