/*
 * Decompiled with CFR 0.152.
 */
package org.fryske_akademy.ejb;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RolesAllowed;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Selection;
import javax.transaction.Transactional;
import org.fryske_akademy.ejb.CrudReadService;
import org.fryske_akademy.ejb.CrudWriteService;
import org.fryske_akademy.jpa.EntityInterface;
import org.fryske_akademy.jpa.JpqlBuilder;
import org.fryske_akademy.jpa.Param;

@DeclareRoles(value={"editor"})
@Transactional(value=Transactional.TxType.NOT_SUPPORTED)
public abstract class AbstractCrudService
implements CrudWriteService,
CrudReadService {
    private JpqlBuilder jpqlBuilder;
    private static final Logger LOGGER = Logger.getLogger(AbstractCrudService.class.getName());
    public static final int DEFAULT_PAGE_SIZE = 30;
    public static final String EDITORROLE = "editor";

    protected abstract EntityManager getEntityManager();

    @Override
    public <T extends Serializable> T find(Serializable id, Class<T> type) {
        return (T)((Serializable)this.getEntityManager().find(type, (Object)id));
    }

    @Override
    public <T extends Serializable> List<T> findAll(Class<T> type) {
        CriteriaQuery cq = this.getEntityManager().getCriteriaBuilder().createQuery();
        cq.select((Selection)cq.from(type));
        return this.getEntityManager().createQuery(cq).getResultList();
    }

    @Override
    public <T extends Serializable> List<T> findDynamic(Integer first, Integer pageSize, Map<String, CrudReadService.SORTORDER> sort, List<Param> params, Class<T> type) {
        String jpql = "from " + type.getSimpleName() + " e" + this.jpqlBuilder.whereClause(params) + this.jpqlBuilder.orderClause(sort);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(jpql);
        }
        TypedQuery q = this.getEntityManager().createQuery(jpql, type);
        this.jpqlBuilder.setWhereParams((Query)q, params);
        q.setFirstResult(first == null ? 0 : first);
        if (pageSize == null || pageSize >= 0) {
            q.setMaxResults(pageSize == null ? this.getDefaultPageSize() : pageSize.intValue());
        }
        return q.getResultList();
    }

    @Override
    public int countDynamic(List<Param> params, Class type) {
        String jpql = "select count(*) from " + type.getSimpleName() + " e" + this.jpqlBuilder.whereClause(params);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(jpql);
        }
        return this.doCount((Query)this.getEntityManager().createQuery(jpql, Long.class), params);
    }

    @Override
    public <T extends Serializable> List<T> find(String namedQuery, List<Param> params, Integer first, Integer max, Class<T> type) {
        return this.doFind((Query)this.getEntityManager().createNamedQuery(namedQuery, type), params, first, max);
    }

    @Override
    public <T extends Serializable> List<T> findNative(String namedNativeQuery, List<Param> params, Integer first, Integer max, Class<T> type) {
        return this.doFind(this.getEntityManager().createNamedQuery(namedNativeQuery), params, first, max);
    }

    @Override
    public int count(String namedQuery, List<Param> params) {
        return this.doCount(this.getEntityManager().createNamedQuery(namedQuery), params);
    }

    @Override
    public int getDefaultPageSize() {
        return 30;
    }

    @Override
    public <T extends Serializable> T findOne(String namedQuery, List<Param> params, Class<T> type) {
        TypedQuery q = this.getEntityManager().createNamedQuery(namedQuery, type);
        this.jpqlBuilder.setWhereParams((Query)q, params);
        try {
            return (T)((Serializable)q.getSingleResult());
        }
        catch (NoResultException e) {
            return null;
        }
    }

    @Override
    @Transactional
    @RolesAllowed(value={"editor"})
    public <T extends Serializable> T create(T t) {
        this.getEntityManager().persist(t);
        return t;
    }

    @Override
    @Transactional
    @RolesAllowed(value={"editor"})
    public <T extends EntityInterface> T save(T t) {
        if (t.isTransient()) {
            return this.create(t);
        }
        return this.update(t);
    }

    @Override
    @Transactional
    @RolesAllowed(value={"editor"})
    public <T extends Serializable> T update(T t) {
        return (T)((Serializable)this.getEntityManager().merge(t));
    }

    @Override
    @Transactional
    @RolesAllowed(value={"editor"})
    public void delete(EntityInterface t) {
        this.getEntityManager().remove(this.getEntityManager().find(t.getClass(), (Object)t.getId()));
    }

    @Override
    @Transactional
    @RolesAllowed(value={"editor"})
    public <T extends EntityInterface> Stream<T> batchSave(Collection<T> entities, Integer flushCount) {
        EntityManager em = this.getEntityManager();
        int i = 0;
        ArrayList<Object> l = new ArrayList<Object>(entities.size());
        for (EntityInterface t : entities) {
            if (t.isTransient()) {
                em.persist((Object)t);
                l.add(t);
            } else {
                l.add(em.merge((Object)t));
            }
            if (flushCount == null || ++i % flushCount != 0) continue;
            em.flush();
            em.clear();
        }
        return l.stream();
    }

    @Override
    @Transactional
    @RolesAllowed(value={"editor"})
    public int batchDelete(Collection<? extends EntityInterface> t, Integer flushCount) {
        EntityManager em = this.getEntityManager();
        AtomicInteger i = new AtomicInteger();
        t.forEach(e -> {
            em.remove(em.merge(e));
            int inc = i.incrementAndGet();
            if (flushCount != null && inc % flushCount == 0) {
                em.flush();
                em.clear();
            }
        });
        return i.get();
    }

    private List doFind(Query q, List<Param> params, Integer first, Integer max) {
        this.jpqlBuilder.setWhereParams(q, params);
        q.setFirstResult(first == null ? 0 : first);
        if (max != null) {
            if (max >= 0) {
                q.setMaxResults(max.intValue());
            }
        } else {
            q.setMaxResults(this.getDefaultPageSize());
        }
        return q.getResultList();
    }

    private int doCount(Query q, List<Param> params) {
        this.jpqlBuilder.setWhereParams(q, params);
        return Integer.parseInt(String.valueOf(q.getSingleResult()));
    }

    @Inject
    protected void setJpqlBuilder(JpqlBuilder jpqlBuilder) {
        this.jpqlBuilder = jpqlBuilder;
    }
}

