/*
 * Decompiled with CFR 0.152.
 */
package org.fryske_akademy.ejb;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import org.fryske_akademy.ejb.AbstractCrudService;
import org.fryske_akademy.ejb.Auditing;
import org.fryske_akademy.jpa.RevInfo;
import org.fryske_akademy.jpa.RevisionInfo;
import org.hibernate.envers.AuditReaderFactory;
import org.hibernate.envers.Audited;
import org.hibernate.envers.RevisionType;
import org.hibernate.envers.query.AuditEntity;
import org.hibernate.envers.query.AuditQuery;
import org.hibernate.envers.query.criteria.AuditCriterion;
import org.hibernate.envers.query.criteria.internal.IdentifierEqAuditExpression;

public abstract class AbstractCrudServiceEnvers
extends AbstractCrudService
implements Auditing {
    private static final Logger LOGGER = Logger.getLogger(AbstractCrudServiceEnvers.class.getName());

    @Override
    public <T extends Serializable> T getRevision(Number n, Class<T> type) {
        if (!type.isAnnotationPresent(Audited.class)) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("No @Audited annotation on " + type.getName());
            }
            return null;
        }
        return (T)((Serializable)AuditReaderFactory.get((EntityManager)this.getEntityManager()).createQuery().forEntitiesAtRevision(type, n).getSingleResult());
    }

    @Override
    public <T extends Serializable> List<RevInfo<T>> getRevisionInfo(Serializable id, Integer max, Class<T> type) {
        ArrayList<RevInfo<T>> result = new ArrayList<RevInfo<T>>(5);
        if (!type.isAnnotationPresent(Audited.class)) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("No @Audited annotation on " + type.getName());
            }
            return result;
        }
        if (id == null) {
            return result;
        }
        AuditQuery query = AuditReaderFactory.get((EntityManager)this.getEntityManager()).createQuery().forRevisionsOfEntity(type, false, true).addOrder(AuditEntity.revisionNumber().desc());
        query.add((AuditCriterion)new IdentifierEqAuditExpression(null, (Object)id, true)).setMaxResults(max == null ? 5 : max);
        List resultList = query.getResultList();
        if (resultList.isEmpty()) {
            return result;
        }
        for (Object[] object : resultList) {
            RevisionType rt = (RevisionType)object[2];
            switch (rt) {
                case ADD: {
                    result.add(new RevInfo<Serializable>((Serializable)object[0], RevInfo.TYPE.CREATE, (RevisionInfo)((Object)object[1])));
                    break;
                }
                case MOD: {
                    result.add(new RevInfo<Serializable>((Serializable)object[0], RevInfo.TYPE.UPDATE, (RevisionInfo)((Object)object[1])));
                    break;
                }
                case DEL: {
                    result.add(new RevInfo<Serializable>((Serializable)object[0], RevInfo.TYPE.DELETE, (RevisionInfo)((Object)object[1])));
                }
            }
        }
        return result;
    }

    @Override
    public <T extends Serializable> List<Number> getRevisionNumbers(Object id, Class<T> type) {
        if (!type.isAnnotationPresent(Audited.class)) {
            return Collections.emptyList();
        }
        return AuditReaderFactory.get((EntityManager)this.getEntityManager()).getRevisions(type, id);
    }
}

