/*
 * Decompiled with CFR 0.152.
 */
package org.fryske_akademy.jpa;

import java.lang.annotation.Annotation;
import java.security.Principal;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.security.enterprise.SecurityContext;
import org.fryske_akademy.Util;

public class JpaUtil {
    private static final Logger LOGGER = Logger.getLogger(JpaUtil.class.getName());
    private static final Map<String, EntityManagerFactory> emFacts = new ConcurrentHashMap<String, EntityManagerFactory>(5){

        @Override
        public EntityManagerFactory get(Object key) {
            if (!this.containsKey(key) || !((EntityManagerFactory)super.get(key)).isOpen()) {
                this.put(String.valueOf(key), Persistence.createEntityManagerFactory((String)String.valueOf(key)));
            }
            return (EntityManagerFactory)super.get(key);
        }
    };

    public static EntityManagerFactory getEntityManagerFactory(String name) {
        return emFacts.get(name);
    }

    public static Principal findPrincipal() throws IllegalStateException {
        return Util.getBean(SecurityContext.class, new Annotation[0]).getCallerPrincipal();
    }
}

