/*
 * Decompiled with CFR 0.152.
 */
package org.fryske_akademy.jpa;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Named;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.fryske_akademy.ejb.CrudReadService;
import org.fryske_akademy.jpa.JpqlBuilder;
import org.fryske_akademy.jpa.Param;

@ApplicationScoped
@Named
public class JpqlBuilderImpl
implements JpqlBuilder,
Serializable {
    private static final Logger LOGGER = Logger.getLogger(JpqlBuilder.class.getName());
    public static final String ENTITY_PREFIX = " e.";

    @Override
    public String orderClause(Map<String, CrudReadService.SORTORDER> sort) {
        if (sort != null && !sort.isEmpty()) {
            StringBuilder srt = new StringBuilder("");
            boolean first = true;
            for (Map.Entry<String, CrudReadService.SORTORDER> entry : sort.entrySet()) {
                String sortField = entry.getKey();
                if (sortField == null || entry.getValue() == CrudReadService.SORTORDER.NONE) continue;
                srt.append(first ? " order by" : ",").append(ENTITY_PREFIX).append(sortField).append(" ").append(entry.getValue());
                first = false;
            }
            return srt.toString();
        }
        return "";
    }

    @Override
    public String whereClause(List<Param> params) {
        if (params != null && !params.isEmpty()) {
            StringBuilder where = new StringBuilder("");
            boolean first = true;
            for (Param param : params) {
                where.append(first ? " where" : param.getAndOr()).append(this.whereCondition(param));
                first = false;
            }
            return where.toString();
        }
        return "";
    }

    @Override
    public String whereCondition(Param param) {
        if (param.getOperator().toLowerCase().contains("member of")) {
            if (param.getParamValue() instanceof Collection) {
                if (!((Collection)param.getParamValue()).isEmpty()) {
                    StringBuilder rv = new StringBuilder(" (");
                    AtomicBoolean first = new AtomicBoolean(true);
                    AtomicInteger i = new AtomicInteger();
                    ((Collection)param.getParamValue()).forEach(t -> {
                        if (first.get()) {
                            first.set(false);
                        } else {
                            rv.append(" or ");
                        }
                        rv.append(":").append(param.getParamKey()).append(i.getAndIncrement()).append(param.getNot()).append(param.getOperator()).append(ENTITY_PREFIX).append(param.getPropertyPath());
                    });
                    return rv.append(')').toString();
                }
                throw new PersistenceException("\"member of\" needs a non empty collection");
            }
            return " :" + param.getParamKey() + param.getNot() + param.getOperator() + ENTITY_PREFIX + param.getPropertyPath();
        }
        if (param.getOperator().toLowerCase().contains("in")) {
            return ENTITY_PREFIX + param.getPropertyPath() + param.getNot() + param.getOperator() + "( :" + param.getParamKey() + " )";
        }
        if (param.getOperator().toLowerCase().contains("null") || param.getOperator().toLowerCase().contains("empty")) {
            return ENTITY_PREFIX + param.getPropertyPath() + param.getOperator();
        }
        return param.isCaseInsensitive() && String.class.equals((Object)param.getParamType()) ? param.getNot() + "lower(" + ENTITY_PREFIX + param.getPropertyPath() + ")" + param.getOperator() + "lower(:" + param.getParamKey() + ")" : param.getNot() + ENTITY_PREFIX + param.getPropertyPath() + param.getOperator() + ":" + param.getParamKey();
    }

    @Override
    public void setWhereParams(Query q, List<Param> params) {
        if (params != null && !params.isEmpty()) {
            params.forEach(param -> this.setParam(q, (Param)param));
        }
    }

    protected void set(Query q, String key, Object value) {
        if (q instanceof TypedQuery) {
            q.setParameter(key, value);
        } else {
            q.setParameter((int)Short.valueOf(key).shortValue(), value);
        }
    }

    @Override
    public void setParam(Query q, Param param) {
        boolean hasParam = false;
        try {
            q.getParameter(param.getParamKey());
            hasParam = true;
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {
            // empty catch block
        }
        if (param.isSkipSetValue() && !hasParam) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("skipping " + param);
            }
            return;
        }
        if (param.isSkipSetValue() && hasParam && LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.warning("Param indicates skipping but query contains it, skipping is ignored: " + param);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("trying to set: " + param);
        }
        if (param.getOperator().toLowerCase().contains("member of") && param.getParamValue() instanceof Collection) {
            AtomicInteger i = new AtomicInteger();
            ((Collection)param.getParamValue()).forEach(t -> this.set(q, param.getParamKey() + i.getAndIncrement(), t));
        } else {
            if (param.getParamValue() instanceof Collection && !param.getOperator().toLowerCase().contains("in") && LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning("value for " + param.getParamKey() + " is a collection, you may want to use the \"in\" operator");
            }
            this.set(q, param.getParamKey(), param.getParamValue());
        }
    }
}

