/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.fryske_akademy.ejb;

/*-
 * #%L
 * ejbCrudApi
 * %%
 * Copyright (C) 2018 Fryske Akademy
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.fryske_akademy.jpa.EntityInterface;
import org.fryske_akademy.jpa.RevInfo;

/**
 * Generic interface for read operations on entities and their envers history
 * @see SORTORDER
 * @see Param
 * @author eduard
 */
public interface CrudReadService {

    public enum SORTORDER implements Serializable {
        DESC, ASC;

        public static class Builder {

            private final Map<String, SORTORDER> sort = new HashMap<>(2);

            public Builder add(String s, SORTORDER o) {
                sort.put(s, o);
                return this;
            }

            public Map<String, SORTORDER> build() {
                return sort;
            }
        }
    }
        
    public <T extends EntityInterface> T find(Serializable id, Class<T> type);

    public <T extends EntityInterface> List<T> findAll(Class<T> type);

    public <T extends EntityInterface> List<T> findPaged(int first, int pageSize, Map<String, SORTORDER> sort, List<Param> params, Class<T> type);

    public <T extends EntityInterface> List<T> find(Map<String, SORTORDER> sort, List<Param> params, Integer max, Class<T> type);

    public <T extends EntityInterface> List<T> find(String namedQuery, List<Param> params, Integer max, Class<T> type);
    
    public <T extends EntityInterface> List<T> autoComplete(String namedQuery, String paramName, String ParamValue, Integer max, Class<T> type);

    public <T extends EntityInterface> T findOne(String namedQuery, List<Param> params, Class<T> type);

    public <T extends EntityInterface> T findOne(String namedQuery, String paramName, Object paramValue, Class<T> type);
    
        public int count(List<Param> params, Class type);
    
    /**
     * return list of revision numbers, first is the oldest
     *
     * @param id
     * @return
     */
    public <T extends EntityInterface> List<Number> getRevisionNumbers(Object id, Class<T> type);

    /**
     * get historical data for a certain revision
     *
     * @param <T>
     * @param n
     * @param type
     * @return
     */
    public <T extends EntityInterface> T getRevision(Number n, Class<T> type);

    /**
     * return a list holding revision information, newest come first
     * @param <T>
     * @param entity
     * @param max the maximum to number of results to return, defaults to 5
     * @param type
     * @return
     */
    public <T extends EntityInterface> List<RevInfo<T>> getRevisionInfo(T entity, Integer max, Class<T> type);
        
}
